/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.binding.registry.internal;

import com.ibm.adapter.binding.registry.IBinding;
import com.ibm.adapter.binding.registry.internal.FaultBinding;
import commonj.connector.metadata.BindingConfigurationEdit;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class Binding
implements IBinding {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private String description;
    private String displayName;
    private String className;
    private Object instance;
    private List supportedTypes = new ArrayList();
    private List supportedDataTypes = new ArrayList();
    private List dataCategories = new ArrayList();
    private List supportedFaults = new ArrayList();
    private List asiNamespaces = new ArrayList();
    private String type;
    private String generatedType;
    private List supportedServiceTypes = new ArrayList();
    private List tags = new ArrayList();
    private boolean requireConfiguration;
    private String configurationClassName;
    private BindingConfigurationEdit configuration;
    private String propertiesJavaBeanClassName;
    private Object propertiesJavaBean;
    private int linkage;
    private String projectPath;
    private IProject project;
    private String providerDescription;

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getClassName() {
        if (this.instance != null) {
            return this.instance.getClass().getName();
        }
        return this.className;
    }

    @Override
    public void setInstance(Object instance) {
        this.instance = instance;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public List getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public void setSupportedTypes(List supportedTypes) {
        if (supportedTypes != null) {
            this.supportedTypes = supportedTypes;
        }
    }

    @Override
    public void addSupportedType(String supportedType) {
        if (!this.supportedTypes.contains(supportedType)) {
            this.supportedTypes.add(supportedType);
        }
    }

    @Override
    public void addSupportedTypes(List supportedTypes) {
        ArrayList<String> list = null;
        if (supportedTypes != null && !supportedTypes.isEmpty()) {
            list = new ArrayList<String>();
            boolean exist = false;
            for (String supportedType : supportedTypes) {
                for (String thisSupportedType : this.supportedTypes) {
                    if (!thisSupportedType.equals(supportedType)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(supportedType);
                }
                exist = false;
            }
            this.supportedTypes.addAll(list);
        }
    }

    @Override
    public List getAsiNamespaces() {
        return this.asiNamespaces;
    }

    @Override
    public void setAsiNamespaces(List asiNamespaces) {
        if (asiNamespaces != null) {
            this.asiNamespaces = asiNamespaces;
        }
    }

    @Override
    public void addAsiNamespace(String asiNamespace) {
        if (!this.asiNamespaces.contains(asiNamespace)) {
            this.asiNamespaces.add(asiNamespace);
        }
    }

    @Override
    public void addAsiNamespaces(List asiNamespaces) {
        ArrayList<String> list = null;
        if (asiNamespaces != null && !asiNamespaces.isEmpty()) {
            list = new ArrayList<String>();
            boolean exist = false;
            for (String asiNamespace : asiNamespaces) {
                for (String thisASINamespace : this.asiNamespaces) {
                    if (!thisASINamespace.equals(asiNamespace)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(asiNamespace);
                }
                exist = false;
            }
            this.asiNamespaces.addAll(list);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getGeneratedType() {
        return this.generatedType;
    }

    @Override
    public void setGeneratedType(String generatedType) {
        this.generatedType = generatedType;
    }

    @Override
    public List getSupportedServiceTypes() {
        return this.supportedServiceTypes;
    }

    @Override
    public void setSupportedServiceTypes(List supportedServiceTypes) {
        if (supportedServiceTypes != null) {
            this.supportedServiceTypes = supportedServiceTypes;
        }
    }

    @Override
    public void addSupportedServiceType(String supportedServiceType) {
        if (!this.supportedServiceTypes.contains(supportedServiceType)) {
            this.supportedServiceTypes.add(supportedServiceType);
        }
    }

    @Override
    public void addSupportedServiceTypes(List supportedServiceTypes) {
        ArrayList<String> list = null;
        if (supportedServiceTypes != null && !supportedServiceTypes.isEmpty()) {
            list = new ArrayList<String>();
            boolean exist = false;
            for (String supportedServiceType : supportedServiceTypes) {
                for (String thisSupportedServiceType : this.supportedServiceTypes) {
                    if (!thisSupportedServiceType.equals(supportedServiceType)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(supportedServiceType);
                }
                exist = false;
            }
            this.supportedServiceTypes.addAll(list);
        }
    }

    @Override
    public List getTags() {
        return this.tags;
    }

    @Override
    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    @Override
    public void addTags(List tags) {
        ArrayList<String> list = null;
        if (tags != null && !tags.isEmpty()) {
            list = new ArrayList<String>();
            boolean exist = false;
            for (String tag : tags) {
                for (String thisTag : this.tags) {
                    if (!thisTag.equals(tag)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(tag);
                }
                exist = false;
            }
            this.tags.addAll(list);
        }
    }

    @Override
    public void setTags(List tags) {
        if (tags != null) {
            this.tags = tags;
        }
    }

    @Override
    public String getConfigurationClassName() {
        if (this.configuration != null) {
            return this.configuration.getClass().getName();
        }
        return this.configurationClassName;
    }

    @Override
    public void setConfigurationClassName(String configurationClassName) {
        this.configurationClassName = configurationClassName;
    }

    @Override
    public String getPropertiesJavaBeanClassName() {
        if (this.propertiesJavaBean != null) {
            return this.propertiesJavaBean.getClass().getName();
        }
        return this.propertiesJavaBeanClassName;
    }

    @Override
    public void setPropertiesJavaBeanClassName(String propertiesJavaBeanClassName) {
        this.propertiesJavaBeanClassName = propertiesJavaBeanClassName;
    }

    @Override
    public BindingConfigurationEdit getConfiguration() {
        return this.configuration;
    }

    @Override
    public Object getPropertiesJavaBean() {
        return this.propertiesJavaBean;
    }

    @Override
    public boolean requireConfiguration() {
        return this.requireConfiguration;
    }

    @Override
    public void setConfiguration(BindingConfigurationEdit configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setPropertiesJavaBean(Object propertiesJavaBean) {
        this.propertiesJavaBean = propertiesJavaBean;
    }

    @Override
    public void setRequireConfiguration(boolean requireConfiguration) {
        this.requireConfiguration = requireConfiguration;
    }

    @Override
    public int getLinkage() {
        return this.linkage;
    }

    @Override
    public void setLinkage(int linkage) {
        this.linkage = linkage;
    }

    @Override
    public String getProjectPath() {
        if (this.projectPath == null && this.project != null) {
            try {
                this.projectPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toURL().getFile()) + this.project.getFullPath().toString();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.projectPath;
    }

    @Override
    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    private IProject getProjectFromPath() {
        if (this.projectPath != null && (2 == this.linkage || 1 == this.linkage)) {
            IProject proj;
            IJavaProject javaProject;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int index = this.projectPath.lastIndexOf(47);
            if (index == -1) {
                index = this.projectPath.lastIndexOf(92);
            }
            if ((javaProject = JavaCore.create((IProject)(proj = workspaceRoot.getProject(this.projectPath.substring(index + 1))))) != null && javaProject.exists()) {
                return proj;
            }
        }
        return null;
    }

    @Override
    public IProject getProject() {
        if (this.project != null) {
            return this.project;
        }
        if (this.projectPath != null) {
            this.project = this.getProjectFromPath();
        }
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public void addSupportedDataType(QName supportedDataType) {
        if (!this.supportedDataTypes.contains(supportedDataType)) {
            this.supportedDataTypes.add(supportedDataType);
        }
    }

    @Override
    public void addSupportedDataTypes(List supportedDataTypes) {
        ArrayList<String> list = null;
        if (supportedDataTypes != null && !supportedDataTypes.isEmpty()) {
            list = new ArrayList<String>();
            boolean exist = false;
            for (String supportedDataType : supportedDataTypes) {
                for (String thisSupportedDataType : this.supportedDataTypes) {
                    if (!thisSupportedDataType.equals(supportedDataType)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(supportedDataType);
                }
                exist = false;
            }
            this.supportedDataTypes.addAll(list);
        }
    }

    @Override
    public void addSupportedFault(IBinding.IFault fault) {
        if (!this.supportedFaults.contains(fault)) {
            this.supportedFaults.add(fault);
        }
    }

    @Override
    public void addSupportedFaults(List supportedFaults) {
        ArrayList<IBinding.IFault> list = null;
        if (supportedFaults != null && !supportedFaults.isEmpty()) {
            list = new ArrayList<IBinding.IFault>();
            boolean exist = false;
            for (IBinding.IFault supportedFault : supportedFaults) {
                for (IBinding.IFault thisSupportedFault : this.supportedFaults) {
                    if (!thisSupportedFault.equals(supportedFault)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(supportedFault);
                }
                exist = false;
            }
            this.supportedFaults.addAll(list);
        }
    }

    @Override
    public List getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @Override
    public List getSupportedFaults() {
        return this.supportedFaults;
    }

    @Override
    public void setSupportedDataTypes(List supportedDataTypes) {
        if (supportedDataTypes != null) {
            this.supportedDataTypes = supportedDataTypes;
        }
    }

    @Override
    public void setSupportedFaults(List supportedFaults) {
        if (supportedFaults != null) {
            this.supportedFaults = supportedFaults;
        }
    }

    @Override
    public List getDataCategories() {
        return this.dataCategories;
    }

    @Override
    public void addDataCategory(String dataCategory) {
        if (!this.dataCategories.contains(dataCategory)) {
            this.dataCategories.add(dataCategory);
        }
    }

    @Override
    public void addDataCategories(List dataCategories) {
        ArrayList<String> list = null;
        if (dataCategories != null && !dataCategories.isEmpty()) {
            list = new ArrayList<String>();
            boolean exist = false;
            for (String dataCategory : dataCategories) {
                for (String thisDataCategory : this.dataCategories) {
                    if (!thisDataCategory.equals(dataCategory)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    list.add(dataCategory);
                }
                exist = false;
            }
            this.dataCategories.addAll(list);
        }
    }

    @Override
    public void setDataCategories(List dataCategories) {
        if (dataCategories != null) {
            this.dataCategories = dataCategories;
        }
    }

    @Override
    public IBinding.IFault createFault() {
        return new FaultBinding();
    }

    @Override
    public boolean isConfigurable() {
        return this.getPropertiesJavaBeanClassName() != null;
    }

    public int hashCode() {
        int hashCode = this.getClassName().hashCode() + this.description.hashCode() + this.displayName.hashCode() + this.type.hashCode() + this.supportedServiceTypes.hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        boolean equals;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IBinding other = (IBinding)object;
        boolean bl = equals = this.getClassName().equals(other.getClassName()) && this.description.equals(other.getDescription()) && this.displayName.equals(other.getDisplayName()) && this.type.equals(other.getType()) && this.supportedServiceTypes.equals(other.getSupportedServiceTypes());
        if (!equals) {
            return equals;
        }
        if (!this.supportedTypes.isEmpty() && !(equals = this.supportedTypes.equals(other.getSupportedTypes()))) {
            return equals;
        }
        if (!this.supportedDataTypes.isEmpty() && !(equals = this.supportedDataTypes.equals(other.getSupportedDataTypes()))) {
            return equals;
        }
        if (!this.asiNamespaces.isEmpty() && !(equals = this.asiNamespaces.equals(other.getAsiNamespaces()))) {
            return equals;
        }
        if (!this.tags.isEmpty() && !(equals = this.tags.equals(other.getTags()))) {
            return equals;
        }
        if (!this.dataCategories.isEmpty() && !(equals = this.dataCategories.equals(other.getDataCategories()))) {
            return equals;
        }
        if (!this.supportedFaults.isEmpty() && !(equals = this.supportedFaults.equals(other.getSupportedFaults()))) {
            return equals;
        }
        if (this.projectPath != null && !(equals = this.projectPath.equals(other.getProjectPath()))) {
            return equals;
        }
        boolean bl2 = equals = this.requireConfiguration == other.requireConfiguration();
        if (!equals) {
            return equals;
        }
        if (this.configurationClassName != null && !(equals = this.configurationClassName.equals(other.getConfigurationClassName()))) {
            return equals;
        }
        if (this.propertiesJavaBeanClassName != null && !(equals = this.propertiesJavaBeanClassName.equals(other.getPropertiesJavaBeanClassName()))) {
            return equals;
        }
        return equals;
    }

    @Override
    public Object clone() {
        int i;
        Binding clone = new Binding();
        clone.setDescription(this.description);
        clone.setDisplayName(this.displayName);
        clone.setClassName(this.getClassName());
        clone.setType(this.type);
        clone.setGeneratedType(this.generatedType);
        clone.setLinkage(this.linkage);
        if (this.supportedServiceTypes != null) {
            String[] supportedServiceTypes = this.supportedServiceTypes.toArray(new String[0]);
            ArrayList<String> cloneSupportedServiceTypes = new ArrayList<String>();
            i = 0;
            while (i < supportedServiceTypes.length) {
                String supportedServiceType = supportedServiceTypes[i];
                String cloneSupportedServiceType = new String(supportedServiceType);
                cloneSupportedServiceTypes.add(cloneSupportedServiceType);
                ++i;
            }
            clone.setSupportedServiceTypes(cloneSupportedServiceTypes);
        }
        if (this.supportedTypes != null && !this.supportedTypes.isEmpty()) {
            String[] supportedTypes = this.supportedTypes.toArray(new String[0]);
            ArrayList<String> cloneSupportedTypes = new ArrayList<String>();
            i = 0;
            while (i < supportedTypes.length) {
                String supportedType = supportedTypes[i];
                String cloneSupportedType = new String(supportedType);
                cloneSupportedTypes.add(cloneSupportedType);
                ++i;
            }
            clone.setSupportedTypes(cloneSupportedTypes);
        }
        if (this.supportedDataTypes != null && !this.supportedDataTypes.isEmpty()) {
            QName[] supportedDataTypes = this.supportedDataTypes.toArray(new QName[0]);
            ArrayList<QName> cloneSupportedDataTypes = new ArrayList<QName>();
            i = 0;
            while (i < supportedDataTypes.length) {
                QName supportedDataType = supportedDataTypes[i];
                QName cloneSupportedDataType = new QName(supportedDataType.getNamespaceURI(), supportedDataType.getLocalPart());
                cloneSupportedDataTypes.add(cloneSupportedDataType);
                ++i;
            }
            clone.setSupportedDataTypes(cloneSupportedDataTypes);
        }
        if (this.supportedFaults != null && !this.supportedFaults.isEmpty()) {
            IBinding.IFault[] supportedFaults = this.supportedFaults.toArray(new IBinding.IFault[0]);
            ArrayList<FaultBinding> cloneSupportedFaults = new ArrayList<FaultBinding>();
            i = 0;
            while (i < supportedFaults.length) {
                IBinding.IFault supportedFault = supportedFaults[i];
                FaultBinding cloneSupportedFault = new FaultBinding();
                cloneSupportedFault.setDataType(supportedFault.getDataType());
                cloneSupportedFault.setNativeName(supportedFault.getNativeName());
                cloneSupportedFaults.add(cloneSupportedFault);
                ++i;
            }
            clone.setSupportedFaults(cloneSupportedFaults);
        }
        if (this.asiNamespaces != null && !this.asiNamespaces.isEmpty()) {
            String[] asiNamespaces = this.asiNamespaces.toArray(new String[0]);
            ArrayList<String> cloneASINamespaces = new ArrayList<String>();
            i = 0;
            while (i < asiNamespaces.length) {
                String asiNamespace = asiNamespaces[i];
                String cloneASINamespace = new String(asiNamespace);
                cloneASINamespaces.add(cloneASINamespace);
                ++i;
            }
            clone.setAsiNamespaces(cloneASINamespaces);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            String[] tags = this.tags.toArray(new String[0]);
            ArrayList<String> cloneTags = new ArrayList<String>();
            i = 0;
            while (i < tags.length) {
                String tag = tags[i];
                String cloneTag = new String(tag);
                cloneTags.add(cloneTag);
                ++i;
            }
            clone.setTags(cloneTags);
        }
        if (this.dataCategories != null && !this.dataCategories.isEmpty()) {
            String[] dataCategories = this.dataCategories.toArray(new String[0]);
            ArrayList<String> cloneDataCategories = new ArrayList<String>();
            i = 0;
            while (i < dataCategories.length) {
                String dataCategory = dataCategories[i];
                String cloneDataCategory = new String(dataCategory);
                cloneDataCategories.add(cloneDataCategory);
                ++i;
            }
            clone.setDataCategories(cloneDataCategories);
        }
        if (this.projectPath != null) {
            clone.setProjectPath(this.projectPath);
        }
        clone.setRequireConfiguration(this.requireConfiguration);
        if (this.configurationClassName != null) {
            clone.setConfigurationClassName(this.getConfigurationClassName());
        }
        if (this.propertiesJavaBeanClassName != null) {
            clone.setPropertiesJavaBeanClassName(this.getPropertiesJavaBeanClassName());
        }
        try {
            if (this.instance != null) {
                clone.setInstance(this.instance.getClass().newInstance());
            }
            if (this.configuration != null) {
                clone.setConfiguration((BindingConfigurationEdit)this.configuration.getClass().newInstance());
            }
            if (this.propertiesJavaBean != null) {
                clone.setPropertiesJavaBean(this.propertiesJavaBean.getClass().newInstance());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        return clone;
    }

    @Override
    public String getProviderDescription() {
        return this.providerDescription;
    }

    @Override
    public void setProviderDescription(String providerDescription) {
        this.providerDescription = providerDescription;
    }
}

