/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.preference.ui.common;

import com.ibm.ccl.pli.importer.IPliPreferenceConstants;
import com.ibm.ccl.pli.importer.PliPreferenceStore;
import com.ibm.ccl.pli.preference.ui.common.IPliUIPreferenceConstants;
import com.ibm.ccl.pli.preference.ui.common.PliCodePageSelectionDialog;
import com.ibm.ccl.pli.preference.ui.plugin.PliPreferenceResources;
import com.ibm.ccl.pli.preference.ui.preferencepage.PliPreferencePage;
import com.ibm.ccl.pli.preference.ui.typeimport.PliImporterPropertiesPage;
import com.ibm.etools.lang.common.ui.LocalSystemLibraryTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PliPropertiesPage
implements SelectionListener,
ModifyListener,
IPliPreferenceConstants {
    public static final String copyright = "(c) Copyright IBM Corporation 2005, 2020.";
    private static final String VALIDATE_ERROR_LIMITS_NAME_RANGE = PliPreferenceResources.VALIDATE_ERROR_LIMITS_NAME_RANGE;
    private static final String VALIDATE_ERROR_LIMITS_EXTNAME_RANGE = PliPreferenceResources.VALIDATE_ERROR_LIMITS_EXTNAME_RANGE;
    private static final String VALIDATE_ERROR_MARGINS_LEFT_RANGE = PliPreferenceResources.VALIDATE_ERROR_MARGINS_LEFT_RANGE;
    private static final String VALIDATE_ERROR_MARGINS_RIGHT_RANGE = PliPreferenceResources.VALIDATE_ERROR_MARGINS_RIGHT_RANGE;
    private static final String VALIDATE_ERROR_NAMES_DIFFERENCE_LENGTH = PliPreferenceResources.VALIDATE_ERROR_NAMES_DIFFERENCE_LENGTH;
    private static final String VALIDATE_ERROR_NAMES_MISSING_QUOTE = PliPreferenceResources.VALIDATE_ERROR_NAMES_MISSING_QUOTE;
    private static final String VALIDATE_ERROR_BLANK_MISSING_QUOTE = PliPreferenceResources.VALIDATE_ERROR_BLANK_MISSING_QUOTE;
    private static final String VALIDATE_ERROR_CURRENCY_MISSING_QUOTE = PliPreferenceResources.VALIDATE_ERROR_CURRENCY_MISSING_QUOTE;
    private static final String VALIDATE_ERROR_NOT_MISSING_QUOTE = PliPreferenceResources.VALIDATE_ERROR_NOT_MISSING_QUOTE;
    private static final String VALIDATE_ERROR_OR_MISSING_QUOTE = PliPreferenceResources.VALIDATE_ERROR_OR_MISSING_QUOTE;
    private static final String TAB_LABEL_1 = PliPreferenceResources.TAB_LABEL_1;
    private static final String TAB_LABEL_2 = PliPreferenceResources.TAB_LABEL_2;
    private static final String PAGE_1_DESCRIPTION = PliPreferenceResources.PAGE_1_DESCRIPTION;
    private static final String PAGE_2_DESCRIPTION = PliPreferenceResources.PAGE_2_DESCRIPTION;
    private static final String FILE_EXTENSION_SUPPORT = PliPreferenceResources.FILE_EXTENSION_SUPPORT;
    private static final String NATLANG_LABEL = PliPreferenceResources.NATLANG_LABEL;
    private static final String DBCS_LABEL = PliPreferenceResources.DBCS_LABEL;
    private static final String DBCS_VALUE_NODBCS = PliPreferenceResources.DBCS_VALUE_NODBCS;
    private static final String DBCS_VALUE_DBCS = PliPreferenceResources.DBCS_VALUE_DBCS;
    private static final String GRAPHIC_LABEL = PliPreferenceResources.GRAPHIC_LABEL;
    private static final String GRAPHIC_VALUE_NOGRAPHIC = PliPreferenceResources.GRAPHIC_VALUE_NOGRAPHIC;
    private static final String GRAPHIC_VALUE_GRAPHIC = PliPreferenceResources.GRAPHIC_VALUE_GRAPHIC;
    private static final String TABLE_EDIT_BUTTON_LABEL = PliPreferenceResources.TABLE_EDIT_BUTTON_LABEL;
    private static final String TABLE_COLUMN_LABEL_SUPPORT = PliPreferenceResources.TABLE_COLUMN_LABEL_SUPPORT;
    private static final String TABLE_COLUMN_LABEL_EXTENSION = PliPreferenceResources.TABLE_COLUMN_LABEL_EXTENSION;
    private static final String MARGINS_LABEL_GROUP = PliPreferenceResources.MARGINS_LABEL_GROUP;
    private static final String MARGINS_LABEL_LEFT = PliPreferenceResources.MARGINS_LABEL_LEFT;
    private static final String MARGINS_LABEL_RIGHT = PliPreferenceResources.MARGINS_LABEL_RIGHT;
    private static final String MACRO_LABEL = PliPreferenceResources.MACRO_LABEL;
    private static final String MACRO_VALUE_NOMACRO = PliPreferenceResources.MACRO_VALUE_NOMACRO;
    private static final String MACRO_VALUE_MACRO = PliPreferenceResources.MACRO_VALUE_MACRO;
    private static final String SYSPARM_LABEL = PliPreferenceResources.SYSPARM_LABEL;
    private static final String CHARACTER_CONVERSION_LABEL = PliPreferenceResources.CHARACTER_CONVERSION_LABEL;
    private static final String CHARACTER_CONVERSION_BLANK = PliPreferenceResources.CHARACTER_CONVERSION_BLANK;
    private static final String CHARACTER_CONVERSION_CURRENCY = PliPreferenceResources.CHARACTER_CONVERSION_CURRENCY;
    private static final String CHARACTER_CONVERSION_NOT = PliPreferenceResources.CHARACTER_CONVERSION_NOT;
    private static final String CHARACTER_CONVERSION_OR = PliPreferenceResources.CHARACTER_CONVERSION_OR;
    private static final String NAMES_GROUP = PliPreferenceResources.NAMES_GROUP;
    private static final String NAMES_DEFAULT = PliPreferenceResources.NAMES_DEFAULT;
    private static final String NAMES_NULL = "";
    private static final String NAMES_ARROW = PliPreferenceResources.NAMES_ARROW;
    private static final String EXIT_LABEL = PliPreferenceResources.EXIT_LABEL;
    private static final String EXIT_VALUE_NOEXIT = PliPreferenceResources.EXIT_VALUE_NOEXIT;
    private static final String EXIT_VALUE_EXIT = PliPreferenceResources.EXIT_VALUE_EXIT;
    private static final String EXIT_INF_FILE_LABEL = PliPreferenceResources.EXIT_INF_FILE_LABEL;
    private static final String LIMITS_GROUP = PliPreferenceResources.LIMITS_GROUP;
    private static final String LIMITS_LABEL_NAME = PliPreferenceResources.LIMITS_LABEL_NAME;
    private static final String LIMITS_LABEL_EXTNAME = PliPreferenceResources.LIMITS_LABEL_EXTNAME;
    private static final String LIMITS_LABEL_FIXEDBIN = PliPreferenceResources.LIMITS_LABEL_FIXEDBIN;
    private static final String LIMITS_LABEL_FIXEDDEC = PliPreferenceResources.LIMITS_LABEL_FIXEDDEC;
    private static final String LIMITS_VALUE_FIXEDBIN_31 = PliPreferenceResources.LIMITS_VALUE_FIXEDBIN_31;
    private static final String LIMITS_VALUE_FIXEDBIN_63 = PliPreferenceResources.LIMITS_VALUE_FIXEDBIN_63;
    private static final String LIMITS_VALUE_FIXEDBIN_31_63 = PliPreferenceResources.LIMITS_VALUE_FIXEDBIN_31_63;
    private static final String LIMITS_VALUE_FIXEDDEC_15 = PliPreferenceResources.LIMITS_VALUE_FIXEDDEC_15;
    private static final String LIMITS_VALUE_FIXEDDEC_31 = PliPreferenceResources.LIMITS_VALUE_FIXEDDEC_31;
    private static final String LIMITS_VALUE_FIXEDDEC_15_31 = PliPreferenceResources.LIMITS_VALUE_FIXEDDEC_15_31;
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private DialogPage parentPage;
    private Composite main;
    private Button radioDBCS_NODBCS;
    private Button radioDBCS_DBCS;
    private Button radioGRAPHIC_NOGRAPHIC;
    private Button radioGRAPHIC_GRAPHIC;
    private TableViewer tableViewer;
    private MyTableElement[] tableElements;
    private Button btnEditTable;
    private final String[] COLUMNS = new String[]{"STRING", "COMBO"};
    private final String[] VALUES = new String[]{PliPreferenceResources.FILE_TYPE_FULL, PliPreferenceResources.FILE_TYPE_DATA};
    private ArrayList<String> platform_selection_values = new ArrayList();
    private ArrayList<String> floating_pt_values = new ArrayList();
    private HashMap<Button, String> endian_values = new HashMap();
    private Text textMargin_Left;
    private Text textMargin_Right;
    private Button radioMacro_NOMACRO;
    private Button radioMacro_MACRO;
    private Text textSysparm;
    private Text textCharacterConversion_BLANK;
    private Text textCharacterConversion_CURRENCY;
    private Text textCharacterConversion_NOT;
    private Text textCharacterConversion_OR;
    private Text textNames_SINGLE;
    private Text textNames_DOUBLE_1;
    private Text textNames_DOUBLE_2;
    private Button radioNames_DEFAULT;
    private Button radioNames_SINGLE;
    private Button radioNames_DOUBLE;
    private Text textLimits_NAME;
    private Text textLimits_EXTNAME;
    private Combo comboLimits_FIXEDBIN;
    private Combo comboLimits_FIXEDDEC;
    private Button radioExit_NOEXIT;
    private Button radioExit_EXIT;
    private Text textExitInfFile;
    private Button buttonINFBrowse;
    private Combo comboNatLang;
    public Combo comboPS;
    public Text textCP;
    public Button buttonCPSelect;
    public Combo comboFPF;
    public Button radioEBig;
    public Button radioELittle;
    public String DEFAULT_CODEPAGE = "ISO-8859-1";
    public String OS_CODEPAGE = "IBM-037";
    public Button checkBoxIMS;
    public Button checkBoxDFP;
    private Combo comboCICSVersion;
    private LocalSystemLibraryTable libraryTable;

    public PliPropertiesPage(DialogPage page) {
        this.parentPage = page;
    }

    public Control createContents(Composite parent) {
        this.main = this.createComposite(parent, 1, true);
        this.createTabControl(this.main);
        this.main.pack(true);
        this.main.layout(true);
        this.initializePreferenceStoreValues();
        this.initializeValues();
        return this.main;
    }

    protected void initializeValues() {
        int ix = 0;
        while (ix < IPliUIPreferenceConstants.PS_ITEM.length) {
            this.comboPS.add(IPliUIPreferenceConstants.PS_ITEM[ix]);
            ++ix;
        }
        ix = 0;
        while (ix < IPliUIPreferenceConstants.FPF_ITEM.length) {
            this.comboFPF.add(IPliUIPreferenceConstants.FPF_ITEM[ix]);
            ++ix;
        }
        this.setValuesFromMap(PliPreferenceStore.getValues());
        this.updateControlAvailability();
    }

    public void performDefaults() {
        this.setValuesFromMap(PliPreferenceStore.getDefaultValues());
        this.parentPage.setErrorMessage(null);
        this.updateControlAvailability();
    }

    private void setValuesFromMap(HashMap<String, Object> map) {
        Button b;
        String work;
        int iValue = 0;
        boolean bValue = false;
        if (map.containsKey("com.ibm.ccl.pli.PLI_PLATFORM_SELECTION")) {
            iValue = (Integer)map.get("com.ibm.ccl.pli.PLI_PLATFORM_SELECTION");
            this.comboPS.setText(this.comboPS.getItem(iValue));
        }
        if ((work = (String)map.get("com.ibm.ccl.pli.PLI_CODEPAGE")) != null) {
            this.textCP.setText(work);
        }
        if (map.containsKey("com.ibm.ccl.pli.PLI_IMS_SUPPORT")) {
            bValue = (Boolean)map.get("com.ibm.ccl.pli.PLI_IMS_SUPPORT");
            this.checkBoxIMS.setSelection(bValue);
        }
        if (map.containsKey("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT") && (iValue = ((Integer)map.get("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT")).intValue()) < this.comboFPF.getItemCount()) {
            this.comboFPF.setText(this.comboFPF.getItem(iValue));
        }
        if (map.containsKey("com.ibm.ccl.pli.PLI_DFP")) {
            bValue = (Boolean)map.get("com.ibm.ccl.pli.PLI_DFP");
            this.checkBoxDFP.setSelection(bValue);
        }
        if ((work = (String)map.get("com.ibm.ccl.pli.PLI_ENDIAN")) != null && (b = this.getKey(this.endian_values, work)) != null) {
            b.setSelection(true);
            if (b.equals(this.radioEBig)) {
                this.radioELittle.setSelection(false);
            } else {
                this.radioEBig.setSelection(false);
            }
        }
        bValue = this.getBoolean(map, "com.ibm.ccl.pli.PLI_DBCS");
        this.radioDBCS_DBCS.setSelection(bValue);
        this.radioDBCS_NODBCS.setSelection(!bValue);
        bValue = this.getBoolean(map, "com.ibm.ccl.pli.PLI_GRAPHIC");
        this.radioGRAPHIC_GRAPHIC.setSelection(bValue);
        this.radioGRAPHIC_NOGRAPHIC.setSelection(!bValue);
        int numExt = FILE_EXTENSION.length;
        this.tableElements = new MyTableElement[numExt];
        int i = 0;
        while (i < numExt) {
            iValue = this.getInt(map, PRE_PLI_EXTENSION[i]);
            this.tableElements[i] = new MyTableElement(PRE_PLI_EXTENSION[i], "." + FILE_EXTENSION[i], this.VALUES[iValue]);
            ++i;
        }
        this.tableViewer.setInput((Object)this.tableElements);
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_LIMITS_NAME");
        this.textLimits_NAME.setText(String.valueOf(iValue));
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_LIMITS_EXTNAME");
        this.textLimits_EXTNAME.setText(String.valueOf(iValue));
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN");
        this.comboLimits_FIXEDBIN.select(iValue);
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC");
        this.comboLimits_FIXEDDEC.select(iValue);
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_MARGIN_LEFT");
        this.textMargin_Left.setText(String.valueOf(iValue));
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_MARGIN_RIGHT");
        this.textMargin_Right.setText(String.valueOf(iValue));
        bValue = this.getBoolean(map, "com.ibm.ccl.pli.PLI_MACRO");
        if (bValue) {
            this.radioMacro_MACRO.setSelection(true);
            this.radioMacro_NOMACRO.setSelection(false);
        } else {
            this.radioMacro_MACRO.setSelection(false);
            this.radioMacro_NOMACRO.setSelection(true);
        }
        work = this.getString(map, "com.ibm.ccl.pli.PLI_SYSPARM");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textSysparm.setText(work);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_BLANK");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textCharacterConversion_BLANK.setText(work);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_CURRENCY");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textCharacterConversion_CURRENCY.setText(work);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_NOT");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textCharacterConversion_NOT.setText(work);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_OR");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textCharacterConversion_OR.setText(work);
        iValue = this.getInt(map, "com.ibm.ccl.pli.PLI_NAMES_TYPE");
        switch (iValue) {
            case 0: {
                this.radioNames_DEFAULT.setSelection(true);
                this.radioNames_SINGLE.setSelection(false);
                this.radioNames_DOUBLE.setSelection(false);
                break;
            }
            case 1: {
                this.radioNames_DEFAULT.setSelection(false);
                this.radioNames_SINGLE.setSelection(true);
                this.radioNames_DOUBLE.setSelection(false);
                break;
            }
            default: {
                this.radioNames_DEFAULT.setSelection(false);
                this.radioNames_SINGLE.setSelection(false);
                this.radioNames_DOUBLE.setSelection(true);
            }
        }
        work = this.getString(map, "com.ibm.ccl.pli.PLI_NAMES_SINGLE_TEXT");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textNames_SINGLE.setText(work);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_1");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textNames_DOUBLE_1.setText(work);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_2");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textNames_DOUBLE_2.setText(work);
        this.comboNatLang.select(3);
        work = this.getString(map, "com.ibm.ccl.pli.PLI_NATLANG");
        if (work == null) {
            work = NAMES_NULL;
        }
        i = 0;
        while (i < NATLANG.length) {
            if (NATLANG[i][0].equalsIgnoreCase(work)) {
                this.comboNatLang.select(i);
                break;
            }
            ++i;
        }
        bValue = this.getBoolean(map, "com.ibm.ccl.pli.PLI_EXIT");
        if (bValue) {
            this.radioExit_EXIT.setSelection(true);
            this.radioExit_NOEXIT.setSelection(false);
        } else {
            this.radioExit_EXIT.setSelection(false);
            this.radioExit_NOEXIT.setSelection(true);
        }
        work = this.getString(map, "com.ibm.ccl.pli.PLI_EXIT_INF_FILE");
        if (work == null) {
            work = NAMES_NULL;
        }
        this.textExitInfFile.setText(work);
        work = (String)map.get("com.ibm.ccl.pli.PLI_SYSLIB");
        if (work != null) {
            this.loadDataIntoSyslibTable(work);
        }
        if (this.comboCICSVersion != null && map.containsKey("com.ibm.ccl.pli.PLI_CICS_VERSION") && (work = (String)map.get("com.ibm.ccl.pli.PLI_CICS_VERSION")) != null && work.trim().length() > 0) {
            if (work.trim().equals("NOCICS")) {
                this.comboCICSVersion.select(0);
            } else if (work.trim().equals("31")) {
                this.comboCICSVersion.select(1);
            } else if (work.trim().equals("32")) {
                this.comboCICSVersion.select(2);
            }
        }
    }

    private void loadDataIntoSyslibTable(String work) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(work, PATH_SEPARATOR);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        this.libraryTable.setTableInput(list);
    }

    private void updateControlAvailability() {
        if (this.radioNames_DEFAULT.getSelection()) {
            this.textNames_SINGLE.setEnabled(false);
            this.textNames_DOUBLE_1.setEnabled(false);
            this.textNames_DOUBLE_2.setEnabled(false);
        } else if (this.radioNames_SINGLE.getSelection()) {
            this.textNames_SINGLE.setEnabled(true);
            this.textNames_DOUBLE_1.setEnabled(false);
            this.textNames_DOUBLE_2.setEnabled(false);
        } else if (this.radioNames_DOUBLE.getSelection()) {
            this.textNames_SINGLE.setEnabled(false);
            this.textNames_DOUBLE_1.setEnabled(true);
            this.textNames_DOUBLE_2.setEnabled(true);
        }
        if (this.comboCICSVersion != null) {
            if (this.checkBoxIMS.getSelection()) {
                this.comboCICSVersion.select(0);
                this.comboCICSVersion.setEnabled(false);
            } else {
                this.comboCICSVersion.setEnabled(true);
            }
            if (this.comboCICSVersion.getSelectionIndex() != 0) {
                this.checkBoxIMS.setSelection(false);
                this.checkBoxIMS.setEnabled(false);
            } else {
                this.checkBoxIMS.setEnabled(true);
            }
        }
        this.checkBoxDFP.setEnabled(this.comboPS.getSelectionIndex() == 1);
        if (this.radioExit_NOEXIT.getSelection()) {
            this.textExitInfFile.setEnabled(false);
            this.buttonINFBrowse.setEnabled(false);
        } else if (this.radioExit_EXIT.getSelection()) {
            this.textExitInfFile.setEnabled(true);
            this.buttonINFBrowse.setEnabled(true);
        }
    }

    private String getString(HashMap<String, Object> map, String key) {
        String result = null;
        Object obj = map.get(key);
        if (obj instanceof String) {
            result = (String)obj;
        }
        return result;
    }

    private int getInt(HashMap<String, Object> map, String key) {
        int result = 0;
        Object obj = map.get(key);
        if (obj instanceof Integer) {
            result = (Integer)obj;
        }
        return result;
    }

    private boolean getBoolean(HashMap<String, Object> map, String key) {
        boolean result = false;
        Object obj = map.get(key);
        if (obj instanceof Boolean) {
            result = (Boolean)obj;
        }
        return result;
    }

    private void setString(HashMap<String, Object> map, String key, String str) {
        if (map != null && key != null) {
            map.put(key, str);
        }
    }

    private void setInt(HashMap<String, Object> map, String key, int v) {
        if (map != null && key != null) {
            map.put(key, new Integer(v));
        }
    }

    private void setInt(HashMap<String, Object> map, String key, String str) {
        if (map != null && key != null && str != null) {
            int v = 0;
            try {
                v = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                v = 0;
            }
            map.put(key, new Integer(v));
        }
    }

    private void setBoolean(HashMap<String, Object> map, String key, boolean b) {
        if (map != null && key != null) {
            map.put(key, new Boolean(b));
        }
    }

    private void createTabControl(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        folder.setLayoutData((Object)data);
        TabItem item = new TabItem(folder, 0);
        item.setText(TAB_LABEL_1);
        item.setControl(this.createPage1Contents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(TAB_LABEL_2);
        item.setControl(this.createPage2Contents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("SYSLIB");
        this.libraryTable = new LocalSystemLibraryTable((Composite)folder);
        item.setControl((Control)this.libraryTable);
    }

    private Control createPage1Contents(Composite parent) {
        Composite main = this.createComposite(parent, 1, false);
        Composite compLabel = this.createComposite(main, 1, false);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        compLabel.setLayout((Layout)layout);
        Label lb = new Label(compLabel, 0);
        lb.setText(PAGE_1_DESCRIPTION);
        Composite platformComp = this.createComposite(main, 2, false);
        this.comboPS = this.createCombo(platformComp, PliPreferenceResources.PLATFORM_LABEL);
        this.createCodePageGroup(main);
        Composite imsComp = this.createComposite(main, 2, false);
        this.checkBoxIMS = this.createCheckboxButton(imsComp, PliPreferenceResources.IMS_SUPPORT_LABEL);
        this.createCICSGroup(main);
        Composite floatingPtComp = this.createComposite(main, 2, false);
        this.comboFPF = this.createCombo(floatingPtComp, PliPreferenceResources.FLOATING_POINT_LABEL);
        Composite dfpComp = this.createComposite(main, 2, false);
        this.checkBoxDFP = this.createCheckboxButton(dfpComp, PliPreferenceResources.DFP_LABEL);
        this.createEndianGroup(main);
        Composite labelComp = this.createComposite(main, 1, false);
        layout = new GridLayout();
        layout.marginHeight = 1;
        labelComp.setLayout((Layout)layout);
        lb = new Label(labelComp, 0);
        lb.setText(PAGE_2_DESCRIPTION);
        this.createDBCSGroup(main);
        this.createGraphicGroup(main);
        Composite compLabelForFileExt = this.createComposite(main, 1, false);
        layout = new GridLayout();
        layout.marginHeight = 1;
        compLabelForFileExt.setLayout((Layout)layout);
        lb = new Label(compLabelForFileExt, 0);
        lb.setText(FILE_EXTENSION_SUPPORT);
        this.createFileExtensionTable(main);
        return main;
    }

    private void createCodePageGroup(Composite parent) {
        Composite group = this.createComposite(parent, 3, false);
        this.textCP = this.createText(group, PliPreferenceResources.CODEPAGE_LABEL);
        this.buttonCPSelect = this.createPushButton(group, PliPreferenceResources.SELECT_BTN_LABEL);
    }

    private void createNatLangGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, NATLANG_LABEL);
        this.comboNatLang = this.createCombo((Composite)group, NAMES_NULL);
        int i = 0;
        while (i < NATLANG.length) {
            this.comboNatLang.add(NATLANG[i][1]);
            ++i;
        }
    }

    private void createDBCSGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, DBCS_LABEL);
        this.radioDBCS_NODBCS = this.createRadioButton((Composite)group, DBCS_VALUE_NODBCS);
        this.radioDBCS_DBCS = this.createRadioButton((Composite)group, DBCS_VALUE_DBCS);
    }

    private void createGraphicGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, GRAPHIC_LABEL);
        this.radioGRAPHIC_NOGRAPHIC = this.createRadioButton((Composite)group, GRAPHIC_VALUE_NOGRAPHIC);
        this.radioGRAPHIC_GRAPHIC = this.createRadioButton((Composite)group, GRAPHIC_VALUE_GRAPHIC);
    }

    private void createFileExtensionTable(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite composite = new Composite(parent, 0);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)PliPropertiesPage.createFill());
        this.createFileExtensionTableViewer(composite);
        Composite btnGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 15;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)PliPropertiesPage.createVerticalFill());
        this.btnEditTable = new Button(btnGroup, 8);
        this.btnEditTable.setText(TABLE_EDIT_BUTTON_LABEL);
        this.btnEditTable.setLayoutData((Object)PliPropertiesPage.createHorizontalFill());
        this.btnEditTable.setEnabled(false);
        this.btnEditTable.addSelectionListener((SelectionListener)this);
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    private void createFileExtensionTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 100356);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = PliPropertiesPage.createFill();
        data.heightHint = 50;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[this.COLUMNS.length];
        TableColumn stringColumn = new TableColumn(table, 16384);
        stringColumn.setText(TABLE_COLUMN_LABEL_EXTENSION);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn comboColumn = new TableColumn(table, 16384);
        comboColumn.setText(TABLE_COLUMN_LABEL_SUPPORT);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        cellEditors[1] = new ComboBoxCellEditor((Composite)table, this.VALUES);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(this.COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new MyPreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MyPreferenceLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new MyPreferenceCellModifier((Viewer)this.tableViewer));
        this.tableViewer.setCellEditors(cellEditors);
    }

    private Control createPage2Contents(Composite parent) {
        Composite main = this.createComposite(parent, 1, false);
        Composite labelComp = this.createComposite(main, 1, false);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        labelComp.setLayout((Layout)layout);
        Label lb = new Label(labelComp, 0);
        lb.setText(PAGE_2_DESCRIPTION);
        this.createNatLangGroup(main);
        this.createLimitsGroup(main);
        this.createMarginsGroup(main);
        this.createMacroGroup(main);
        this.createCharacterConversionGroup(main);
        this.createExitGroup(main);
        return main;
    }

    private void createMarginsGroup(Composite parent) {
        Group group = this.createGroup(parent, 4, MARGINS_LABEL_GROUP);
        this.textMargin_Left = this.createText((Composite)group, MARGINS_LABEL_LEFT);
        this.textMargin_Right = this.createText((Composite)group, MARGINS_LABEL_RIGHT);
    }

    private void createMacroGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, MACRO_LABEL);
        this.radioMacro_NOMACRO = this.createRadioButton((Composite)group, MACRO_VALUE_NOMACRO);
        this.radioMacro_MACRO = this.createRadioButton((Composite)group, MACRO_VALUE_MACRO);
        this.textSysparm = this.createText((Composite)group, SYSPARM_LABEL);
    }

    private void createLimitsGroup(Composite parent) {
        Group group = this.createGroup(parent, 4, LIMITS_GROUP);
        this.textLimits_NAME = this.createText((Composite)group, LIMITS_LABEL_NAME);
        this.textLimits_EXTNAME = this.createText((Composite)group, LIMITS_LABEL_EXTNAME);
        this.comboLimits_FIXEDBIN = this.createCombo((Composite)group, LIMITS_LABEL_FIXEDBIN);
        this.comboLimits_FIXEDDEC = this.createCombo((Composite)group, LIMITS_LABEL_FIXEDDEC);
        this.comboLimits_FIXEDBIN.add(LIMITS_VALUE_FIXEDBIN_31);
        this.comboLimits_FIXEDBIN.add(LIMITS_VALUE_FIXEDBIN_63);
        this.comboLimits_FIXEDBIN.add(LIMITS_VALUE_FIXEDBIN_31_63);
        this.comboLimits_FIXEDDEC.add(LIMITS_VALUE_FIXEDDEC_15);
        this.comboLimits_FIXEDDEC.add(LIMITS_VALUE_FIXEDDEC_31);
        this.comboLimits_FIXEDDEC.add(LIMITS_VALUE_FIXEDDEC_15_31);
    }

    private void createCharacterConversionGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, CHARACTER_CONVERSION_LABEL);
        this.textCharacterConversion_BLANK = this.createText((Composite)group, CHARACTER_CONVERSION_BLANK);
        this.textCharacterConversion_CURRENCY = this.createText((Composite)group, CHARACTER_CONVERSION_CURRENCY);
        this.textCharacterConversion_NOT = this.createText((Composite)group, CHARACTER_CONVERSION_NOT);
        this.textCharacterConversion_OR = this.createText((Composite)group, CHARACTER_CONVERSION_OR);
        this.createNamesGroup((Composite)group, 2);
    }

    private void createNamesGroup(Composite parent, int parentColumn) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = parentColumn;
        group.setLayoutData((Object)gd);
        group.setText(NAMES_GROUP);
        this.radioNames_DEFAULT = new Button((Composite)group, 16);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.radioNames_DEFAULT.setLayoutData((Object)gd);
        this.radioNames_DEFAULT.addSelectionListener((SelectionListener)this);
        new Label((Composite)group, 0).setText(NAMES_DEFAULT);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        this.radioNames_SINGLE = new Button((Composite)group, 16);
        this.radioNames_SINGLE.setText(NAMES_NULL);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.radioNames_SINGLE.setLayoutData((Object)gd);
        this.radioNames_SINGLE.addSelectionListener((SelectionListener)this);
        this.textNames_SINGLE = new Text((Composite)group, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 100;
        this.textNames_SINGLE.setLayoutData((Object)gd);
        this.textNames_SINGLE.addSelectionListener((SelectionListener)this);
        this.textNames_SINGLE.addModifyListener((ModifyListener)this);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        this.radioNames_DOUBLE = new Button((Composite)group, 16);
        this.radioNames_DOUBLE.setText(NAMES_NULL);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.radioNames_DOUBLE.setLayoutData((Object)gd);
        this.radioNames_DOUBLE.addSelectionListener((SelectionListener)this);
        this.textNames_DOUBLE_1 = new Text((Composite)group, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 100;
        this.textNames_DOUBLE_1.setLayoutData((Object)gd);
        this.textNames_DOUBLE_1.addSelectionListener((SelectionListener)this);
        this.textNames_DOUBLE_1.addModifyListener((ModifyListener)this);
        new Label((Composite)group, 0).setText(NAMES_ARROW);
        this.textNames_DOUBLE_2 = new Text((Composite)group, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 100;
        this.textNames_DOUBLE_2.setLayoutData((Object)gd);
        this.textNames_DOUBLE_2.addSelectionListener((SelectionListener)this);
        this.textNames_DOUBLE_2.addModifyListener((ModifyListener)this);
    }

    private void createExitGroup(Composite parent) {
        Group group = this.createGroup(parent, 1, EXIT_LABEL);
        this.radioExit_NOEXIT = this.createRadioButton((Composite)group, EXIT_VALUE_NOEXIT);
        this.radioExit_EXIT = this.createRadioButton((Composite)group, EXIT_VALUE_EXIT);
        Composite infFileComp = this.createComposite((Composite)group, 3, false);
        this.textExitInfFile = this.createText(infFileComp, EXIT_INF_FILE_LABEL);
        this.buttonINFBrowse = this.createPushButton(infFileComp, PliPreferenceResources.EXIT_BROWSE_BTN_LABEL);
    }

    public Vector<String> getValidationErrorMessages() {
        Vector<String> errorMessages = new Vector<String>();
        this.checkRange(this.textLimits_NAME, 31, 100, errorMessages, VALIDATE_ERROR_LIMITS_NAME_RANGE);
        this.checkRange(this.textLimits_EXTNAME, 7, 100, errorMessages, VALIDATE_ERROR_LIMITS_EXTNAME_RANGE);
        int marginsLeftValue = this.checkRange(this.textMargin_Left, 1, 100, 2, errorMessages, VALIDATE_ERROR_MARGINS_LEFT_RANGE);
        this.checkRange(this.textMargin_Right, marginsLeftValue, 200, errorMessages, VALIDATE_ERROR_MARGINS_RIGHT_RANGE);
        this.checkQuote(this.textCharacterConversion_BLANK, errorMessages, VALIDATE_ERROR_BLANK_MISSING_QUOTE);
        this.checkQuote(this.textCharacterConversion_CURRENCY, errorMessages, VALIDATE_ERROR_CURRENCY_MISSING_QUOTE);
        this.checkQuote(this.textCharacterConversion_NOT, errorMessages, VALIDATE_ERROR_NOT_MISSING_QUOTE);
        this.checkQuote(this.textCharacterConversion_OR, errorMessages, VALIDATE_ERROR_OR_MISSING_QUOTE);
        this.checkQuote(this.textNames_SINGLE, errorMessages, VALIDATE_ERROR_NAMES_MISSING_QUOTE);
        this.checkQuote(this.textNames_DOUBLE_1, errorMessages, VALIDATE_ERROR_NAMES_MISSING_QUOTE);
        this.checkQuote(this.textNames_DOUBLE_2, errorMessages, VALIDATE_ERROR_NAMES_MISSING_QUOTE);
        if (this.radioNames_DOUBLE.getSelection()) {
            try {
                int l1 = this.textNames_DOUBLE_1.getText().trim().length();
                int l2 = this.textNames_DOUBLE_2.getText().trim().length();
                if (l1 != l2) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                errorMessages.add(VALIDATE_ERROR_NAMES_DIFFERENCE_LENGTH);
            }
        }
        return errorMessages;
    }

    private int checkRange(Text textControl, int minValue, int maxValue, Vector<String> errorMessages, String errMsg) {
        return this.checkRange(textControl, minValue, maxValue, 0, errorMessages, errMsg);
    }

    private int checkRange(Text textControl, int minValue, int maxValue, int defaultValue, Vector<String> errorMessages, String errMsg) {
        int result = 0;
        try {
            int v = Integer.parseInt(textControl.getText());
            if (v < minValue || v > maxValue) {
                throw new Exception();
            }
            result = v;
        }
        catch (Exception exception) {
            errorMessages.add(errMsg);
        }
        return result;
    }

    private String checkQuote(Text textControl, Vector<String> errorMessages, String errMsg) {
        String result = NAMES_NULL;
        try {
            char lch;
            String param = textControl.getText().trim();
            int len = param.length();
            if (len >= 2) {
                char lch2 = param.charAt(0);
                char rch = param.charAt(param.length() - 1);
                if (lch2 == '\'' || lch2 == '\"' ? rch != lch2 : rch == '\'' || rch == '\"') {
                    throw new Exception();
                }
            } else if (len == 1 && ((lch = param.charAt(0)) == '\'' || lch == '\"')) {
                throw new Exception();
            }
            result = param;
        }
        catch (Exception exception) {
            errorMessages.add(errMsg);
        }
        return result;
    }

    public HashMap<String, Object> getValues() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("com.ibm.ccl.pli.PLI_PLATFORM_SELECTION", new Integer(this.comboPS.getSelectionIndex()));
        propertyMap.put("com.ibm.ccl.pli.PLI_CODEPAGE", this.textCP.getText());
        propertyMap.put("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT", new Integer(this.comboFPF.getSelectionIndex()));
        propertyMap.put("com.ibm.ccl.pli.PLI_DFP", new Boolean(this.checkBoxDFP.getSelection()));
        if (this.radioEBig.getSelection()) {
            propertyMap.put("com.ibm.ccl.pli.PLI_ENDIAN", this.endian_values.get(this.radioEBig));
        } else {
            propertyMap.put("com.ibm.ccl.pli.PLI_ENDIAN", this.endian_values.get(this.radioELittle));
        }
        this.setBoolean(propertyMap, "com.ibm.ccl.pli.PLI_DBCS", this.radioDBCS_DBCS.getSelection());
        this.setBoolean(propertyMap, "com.ibm.ccl.pli.PLI_GRAPHIC", this.radioGRAPHIC_GRAPHIC.getSelection());
        int i = 0;
        while (i < this.tableElements.length) {
            String key = this.tableElements[i].getKey();
            String value = this.tableElements[i].getValue();
            int v = 0;
            int j = 0;
            while (j < this.VALUES.length) {
                if (this.VALUES[j].equals(value)) {
                    v = j;
                    break;
                }
                ++j;
            }
            this.setInt(propertyMap, key, v);
            ++i;
        }
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_LIMITS_NAME", this.textLimits_NAME.getText());
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_LIMITS_EXTNAME", this.textLimits_EXTNAME.getText());
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN", this.comboLimits_FIXEDBIN.getSelectionIndex());
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC", this.comboLimits_FIXEDBIN.getSelectionIndex());
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_MARGIN_LEFT", this.textMargin_Left.getText());
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_MARGIN_RIGHT", this.textMargin_Right.getText());
        this.setBoolean(propertyMap, "com.ibm.ccl.pli.PLI_MACRO", this.radioMacro_MACRO.getSelection());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_SYSPARM", this.textSysparm.getText());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_BLANK", this.textCharacterConversion_BLANK.getText());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_CURRENCY", this.textCharacterConversion_CURRENCY.getText());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_NOT", this.textCharacterConversion_NOT.getText());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_OR", this.textCharacterConversion_OR.getText());
        this.setBoolean(propertyMap, "com.ibm.ccl.pli.PLI_EXIT", this.radioExit_EXIT.getSelection());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_EXIT_INF_FILE", this.textExitInfFile.getText());
        int namesType = 0;
        if (this.radioNames_SINGLE.getSelection()) {
            namesType = 1;
        } else if (this.radioNames_DOUBLE.getSelection()) {
            namesType = 2;
        }
        this.setInt(propertyMap, "com.ibm.ccl.pli.PLI_NAMES_TYPE", namesType);
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_NAMES_SINGLE_TEXT", this.textNames_SINGLE.getText());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_1", this.textNames_DOUBLE_1.getText());
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_2", this.textNames_DOUBLE_2.getText());
        int selNatLang = this.comboNatLang.getSelectionIndex();
        if (selNatLang < 0 || selNatLang >= NATLANG.length) {
            selNatLang = 3;
        }
        this.setString(propertyMap, "com.ibm.ccl.pli.PLI_NATLANG", NATLANG[selNatLang][0]);
        propertyMap.put("com.ibm.ccl.pli.PLI_IMS_SUPPORT", new Boolean(this.checkBoxIMS.getSelection()));
        Collection syslibList = this.libraryTable.getTableList();
        String syslib = NAMES_NULL;
        Iterator iter = syslibList.iterator();
        while (iter.hasNext()) {
            syslib = String.valueOf(syslib) + (String)iter.next() + PATH_SEPARATOR;
        }
        propertyMap.put("com.ibm.ccl.pli.PLI_SYSLIB", syslib);
        Object ver = PliPreferenceStore.getDefaultValues().get("com.ibm.ccl.pli.PLI_CICS_VERSION");
        if (this.comboCICSVersion != null) {
            switch (this.comboCICSVersion.getSelectionIndex()) {
                case 0: {
                    ver = "NOCICS";
                    break;
                }
                case 1: {
                    ver = "31";
                    break;
                }
                case 2: {
                    ver = "32";
                }
            }
        }
        propertyMap.put("com.ibm.ccl.pli.PLI_CICS_VERSION", ver);
        return propertyMap;
    }

    protected Composite createComposite(Composite parent, int numColumns, boolean bGrabExcessVert) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (bGrabExcessVert) {
            data.grabExcessVerticalSpace = true;
        }
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Group createGroup(Composite parent, int numColumns, String label) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setText(label);
        return composite;
    }

    protected Combo createCombo(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        combo.setLayoutData((Object)gd);
        combo.addSelectionListener((SelectionListener)this);
        return combo;
    }

    protected Text createText(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Text textField = new Text(parent, 2052);
        GridData gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        textField.addSelectionListener((SelectionListener)this);
        textField.addModifyListener((ModifyListener)this);
        return textField;
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckboxButton(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected static GridData createFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    protected static GridData createHorizontalFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    protected static GridData createVerticalFill() {
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.tableViewer.getTable()) {
            this.enableButtons();
            return;
        }
        if (src == this.btnEditTable) {
            int idx = this.tableViewer.getTable().getSelectionIndex();
            if (idx != -1) {
                CBETableElement sel = (CBETableElement)this.tableViewer.getElementAt(idx);
                String extension = sel.getText();
                String support = sel.getValue();
                this.showEditDialog(PliPreferenceResources.FILE_EXTENSION_SUPPORT, extension, support);
            }
            return;
        }
        if (src == this.buttonINFBrowse) {
            this.browseINF(this.textExitInfFile);
        } else if (src == this.comboPS) {
            this.resetPlatformSelection();
        } else if (src == this.buttonCPSelect) {
            this.selectCP(this.textCP);
        }
        this.updateControlAvailability();
        this.invokeValidationToParent();
    }

    private void enableButtons() {
        int selection = this.tableViewer.getTable().getSelectionIndex();
        this.btnEditTable.setEnabled(this.tableViewer.getTable().getItemCount() > 0 && selection != -1);
    }

    private void showEditDialog(String title, String extension, String support) {
        int idx;
        EditDialog dialog = new EditDialog(this.main.getShell(), title, extension, support);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (idx = this.tableViewer.getTable().getSelectionIndex()) != -1) {
            CBETableElement tableElem = (CBETableElement)this.tableViewer.getElementAt(idx);
            tableElem.setValue(dialog.support());
            tableElem.setUserModified(true);
            this.tableViewer.update((Object)tableElem, null);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.updateControlAvailability();
        this.invokeValidationToParent();
    }

    private void invokeValidationToParent() {
        if (this.parentPage instanceof PliPreferencePage) {
            ((PliPreferencePage)this.parentPage).validate();
        } else if (this.parentPage instanceof WizardPage) {
            ((PliImporterPropertiesPage)this.parentPage).validatePage();
        }
    }

    public void setHelpContextIds() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.parentPage.getControl(), "com.ibm.ccl.pli.preference.ui.ppli0010");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboPS, "com.ibm.ccl.pli.preference.ui.ppli0080");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCP, "com.ibm.ccl.pli.preference.ui.ppli0090");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboFPF, "com.ibm.ccl.pli.preference.ui.ppli0100");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboFPF, "com.ibm.ccl.pli.preference.ui.ppli0105");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioELittle, "com.ibm.ccl.pli.preference.ui.ppli0300");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioEBig, "com.ibm.ccl.pli.preference.ui.ppli0310");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboNatLang, "com.ibm.ccl.pli.preference.ui.ppli0020");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioDBCS_NODBCS, "com.ibm.ccl.pli.preference.ui.ppli0030");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioDBCS_DBCS, "com.ibm.ccl.pli.preference.ui.ppli0040");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioGRAPHIC_NOGRAPHIC, "com.ibm.ccl.pli.preference.ui.ppli0050");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioGRAPHIC_GRAPHIC, "com.ibm.ccl.pli.preference.ui.ppli0060");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableViewer.getTable(), "com.ibm.ccl.pli.preference.ui.ppli0070");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textLimits_NAME, "com.ibm.ccl.pli.preference.ui.ppli0110");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textLimits_EXTNAME, "com.ibm.ccl.pli.preference.ui.ppli0120");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboLimits_FIXEDBIN, "com.ibm.ccl.pli.preference.ui.ppli0130");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboLimits_FIXEDDEC, "com.ibm.ccl.pli.preference.ui.ppli0140");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textMargin_Left, "com.ibm.ccl.pli.preference.ui.ppli0150");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textMargin_Right, "com.ibm.ccl.pli.preference.ui.ppli0160");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioMacro_NOMACRO, "com.ibm.ccl.pli.preference.ui.ppli0170");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioMacro_MACRO, "com.ibm.ccl.pli.preference.ui.ppli0180");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textSysparm, "com.ibm.ccl.pli.preference.ui.ppli0190");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCharacterConversion_BLANK, "com.ibm.ccl.pli.preference.ui.ppli0200");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCharacterConversion_CURRENCY, "com.ibm.ccl.pli.preference.ui.ppli0210");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCharacterConversion_NOT, "com.ibm.ccl.pli.preference.ui.ppli0220");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCharacterConversion_OR, "com.ibm.ccl.pli.preference.ui.ppli0230");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioNames_DEFAULT, "com.ibm.ccl.pli.preference.ui.ppli0240");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textNames_DOUBLE_1, "com.ibm.ccl.pli.preference.ui.ppli0240");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textNames_DOUBLE_2, "com.ibm.ccl.pli.preference.ui.ppli0240");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioExit_NOEXIT, "com.ibm.ccl.pli.preference.ui.ppli0250");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioExit_EXIT, "com.ibm.ccl.pli.preference.ui.ppli0260");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textExitInfFile, "com.ibm.ccl.pli.preference.ui.ppli0270");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.checkBoxIMS, "com.ibm.ccl.pli.preference.ui.ppli0350");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboCICSVersion, "com.ibm.ccl.pli.preference.ui.ppli0360");
    }

    private void selectCP(Text textButton) {
        PliCodePageSelectionDialog ccpsd = new PliCodePageSelectionDialog(this.main.getShell(), textButton.getText());
        int rtnBtn = ccpsd.open();
        if (rtnBtn == 0 && ccpsd.getSelectedObject() != null) {
            textButton.setText((String)ccpsd.getSelectedObject());
        }
    }

    private void browseINF(Text textButton) {
        FileDialog fd = new FileDialog(textButton.getShell(), 4096);
        String fileName = fd.open();
        textButton.setText(fileName);
    }

    private void createEndianGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, PliPreferenceResources.ENDIAN_GROUP_LABEL);
        this.radioELittle = this.createRadioButton((Composite)group, PliPreferenceResources.LITTLE_ENDIAN_LABEL);
        this.radioEBig = this.createRadioButton((Composite)group, PliPreferenceResources.BIG_ENDIAN_LABEL);
    }

    private void createCICSGroup(Composite parent) {
        Composite cicsComp = this.createComposite(parent, 2, false);
        this.comboCICSVersion = this.createCombo(cicsComp, PliPreferenceResources.CICS_OPTION_LABEL_UI_);
        this.comboCICSVersion.add(IPliPreferenceConstants.CICSNONELABEL, 0);
        this.comboCICSVersion.add(IPliPreferenceConstants.CICS31LABEL, 1);
        this.comboCICSVersion.add(IPliPreferenceConstants.CICS32LABEL, 2);
        this.comboCICSVersion.select(0);
    }

    private Button getKey(Map<Button, String> map, Object value) {
        for (Button o : map.keySet()) {
            if (!map.get(o).equals(value)) continue;
            return o;
        }
        return null;
    }

    private void resetPlatformSelection() {
        int iValue = 0;
        iValue = this.comboPS.getSelectionIndex() >= 0 ? this.comboPS.getSelectionIndex() : 0;
        switch (iValue) {
            case 0: {
                this.textCP.setText(this.DEFAULT_CODEPAGE);
                this.comboFPF.setText(this.comboFPF.getItem(0));
                this.radioEBig.setSelection(false);
                this.radioELittle.setSelection(true);
                break;
            }
            case 1: {
                this.textCP.setText(this.OS_CODEPAGE);
                this.comboFPF.setText(this.comboFPF.getItem(1));
                this.radioEBig.setSelection(true);
                this.radioELittle.setSelection(false);
                break;
            }
        }
    }

    private void initializePreferenceStoreValues() {
        this.floating_pt_values.add("IEEE Binary");
        this.floating_pt_values.add("IBM 390 Hexadecimal");
        this.platform_selection_values.add("Win32");
        this.platform_selection_values.add("z/OS");
        this.platform_selection_values.add(PLATFORM_NONE);
        this.endian_values.put(this.radioEBig, "Big");
        this.endian_values.put(this.radioELittle, "Little");
    }

    private class CBETableElement {
        private String myText;
        private String myValue;
        private String originalValue;
        private String defaultValue;
        private boolean useDefaultValue;
        private boolean isUserModified = false;

        public CBETableElement(String text, String value, String defaultValue, boolean useDefaultValue) {
            this.setText(text);
            this.setValue(value);
            this.originalValue = value;
            this.defaultValue = defaultValue;
            this.useDefaultValue = useDefaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isUserModified() {
            return this.isUserModified;
        }

        public void setUserModified(boolean isUserModified) {
            this.isUserModified = isUserModified;
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }

        public String getText() {
            return this.myText;
        }

        public void setText(String text) {
            this.myText = text;
        }

        public boolean isUseDefaultValue() {
            return this.useDefaultValue;
        }

        public void setUseDefaultValue(boolean useDefaultValue) {
            this.useDefaultValue = useDefaultValue;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean isAffected() {
            return this.isUseDefaultValue();
        }

        public String toString() {
            return "<text=\"" + this.myText + "\" value=\"" + this.myValue + "\" originalValue=\"" + this.originalValue + "\" defaultValue=\"" + this.defaultValue + "\"/>";
        }
    }

    private class EditDialog
    extends Dialog {
        private String _extension;
        private String _support;
        private Text _extensionText;
        private Combo _supportCombo;
        private String _title;

        public EditDialog(Shell shell, String title, String extension, String support) {
            super(shell);
            if (extension != null) {
                this._extension = extension;
            }
            this._support = support;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void extension(String extension) {
            this._extension = extension;
        }

        public String extension() {
            return this._extension;
        }

        public void support(String support) {
            this._support = support;
        }

        public String support() {
            return this._support;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridData data = new GridData();
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            Label label = new Label(result, 0);
            label.setText(TABLE_COLUMN_LABEL_SUPPORT);
            this._extensionText = new Text(result, 2048);
            this._extensionText.setLayoutData((Object)data);
            this._extensionText.setEditable(false);
            label = new Label(result, 0);
            label.setText(TABLE_COLUMN_LABEL_EXTENSION);
            this._supportCombo = new Combo(result, 2056);
            this._supportCombo.setLayoutData((Object)data);
            int i = 0;
            while (i < PliPropertiesPage.this.VALUES.length) {
                this._supportCombo.add(PliPropertiesPage.this.VALUES[i]);
                ++i;
            }
            if (this._extension != null) {
                this._extensionText.setText(this._extension);
            }
            if (this._support != null) {
                this._supportCombo.setText(this._support);
            }
            this._supportCombo.setFocus();
            return result;
        }

        protected void okPressed() {
            this._extension = this._extensionText.getText().trim();
            this._support = this._supportCombo.getText();
            super.okPressed();
        }
    }

    private class MyPreferenceCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public MyPreferenceCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof MyTableElement) {
                if (property.equals(PliPropertiesPage.this.COLUMNS[0])) {
                    return false;
                }
                if (property.equals(PliPropertiesPage.this.COLUMNS[1])) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)element;
                if (property.equals(PliPropertiesPage.this.COLUMNS[0])) {
                    return myTableElement.getText();
                }
                if (property.equals(PliPropertiesPage.this.COLUMNS[1])) {
                    return this.getValueIndex(myTableElement.getValue());
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object myElement;
            if (element instanceof TableItem && (myElement = ((TableItem)element).getData()) instanceof MyTableElement) {
                String stringValue;
                MyTableElement myTableElement = (MyTableElement)myElement;
                if (property.equals(PliPropertiesPage.this.COLUMNS[0])) {
                    myTableElement.setText((String)value);
                }
                if (property.equals(PliPropertiesPage.this.COLUMNS[1]) && (stringValue = this.getValue((Integer)value)) != null) {
                    myTableElement.setValue(stringValue);
                }
                this.viewer.refresh();
            }
        }

        private Integer getValueIndex(String value) {
            int i = 0;
            int length = PliPropertiesPage.this.VALUES.length;
            while (i < length) {
                if (PliPropertiesPage.this.VALUES[i].equals(value)) {
                    return new Integer(i);
                }
                ++i;
            }
            return new Integer(0);
        }

        private String getValue(Integer index) {
            int idx;
            if (index != null && (idx = index.intValue()) >= 0 && idx < PliPropertiesPage.this.VALUES.length) {
                return PliPropertiesPage.this.VALUES[idx];
            }
            return null;
        }
    }

    private class MyPreferenceContentProvider
    implements IStructuredContentProvider {
        private MyPreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof MyTableElement[]) {
                return (MyTableElement[])element;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MyPreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyPreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)element;
                if (columnIndex == 0) {
                    return myTableElement.getText();
                }
                if (columnIndex == 1) {
                    return myTableElement.getValue();
                }
            }
            return PliPropertiesPage.NAMES_NULL;
        }
    }

    private class MyTableElement
    extends CBETableElement {
        private String text;
        private String value;
        private String key;

        public MyTableElement(String k, String text, String value) {
            super(text, value, PliPropertiesPage.NAMES_NULL, false);
            this.setText(text);
            this.setValue(value);
            this.setKey(k);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String k) {
            this.key = k;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }
}

