/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.IType;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.internal.AttributeValueRuntimeTypeFactory;
import org.eclipse.jst.jsf.metadataprocessors.internal.IMetaDataEnabledFeatureExtension;
import org.osgi.framework.Bundle;

public final class MetaDataEnabledFeatureAdapterFactory {
    private static MetaDataEnabledFeatureAdapterFactory INSTANCE;
    private Map<String, Class> typesCache = new HashMap<String, Class>();

    public static MetaDataEnabledFeatureAdapterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataEnabledFeatureAdapterFactory();
        }
        return INSTANCE;
    }

    private MetaDataEnabledFeatureAdapterFactory() {
    }

    public IMetaDataEnabledFeature getFeatureAdapter(IMetaDataEnabledFeatureExtension feature, Class processingFeature) {
        if (feature != null) {
            return this.createFeature(feature, processingFeature);
        }
        return null;
    }

    public IMetaDataEnabledFeature getFeatureAdapterForSubclass(IMetaDataEnabledFeatureExtension feature, Class processingFeature, IType type) {
        ITypeDescriptor aType;
        Class<?> klass;
        if (feature != null && (klass = (aType = AttributeValueRuntimeTypeFactory.getInstance().getType(feature.getTypeID())).getTypeExtension().getClass()).asSubclass(type.getClass()) != null) {
            return this.createFeature(feature, processingFeature);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMetaDataEnabledFeature createFeature(IMetaDataEnabledFeatureExtension featureExt, Class processingFeature) {
        String className = featureExt.getClassName();
        Class klass = null;
        try {
            if (!this.typesCache.containsKey(featureExt.getTypeID())) {
                Bundle bundle = Platform.getBundle((String)featureExt.getBundleID());
                if (bundle == null) {
                    JSFCorePlugin.log(4, featureExt.getBundleID() + " could not be created to load " + className);
                    return null;
                }
                klass = bundle.loadClass(className);
                if (klass != null) {
                    this.typesCache.put(featureExt.getTypeID(), klass);
                }
            } else {
                klass = this.typesCache.get(featureExt.getTypeID());
            }
            if (!IMetaDataEnabledFeature.class.isAssignableFrom(klass)) {
                JSFCorePlugin.log(1, className + " is not a IMetaDataEnabledFeature. " + featureExt.getBundleID() + " : " + featureExt.getTypeID());
                return null;
            }
            if (klass == null) return null;
            if (!processingFeature.isAssignableFrom(klass)) return null;
            return (IMetaDataEnabledFeature)klass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            JSFCorePlugin.log(4, className + " was not found in " + featureExt.getBundleID() + " for " + featureExt.getTypeID());
            return null;
        }
        catch (InstantiationException instantiationException) {
            JSFCorePlugin.log(4, "InstantiationException: " + className + " in " + featureExt.getBundleID() + " for " + featureExt.getTypeID());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            JSFCorePlugin.log(4, "IllegalAccessException: " + className + " in " + featureExt.getBundleID() + " for " + featureExt.getTypeID());
        }
        return null;
    }
}

