/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers.model;

import com.ibm.zosconnect.ui.common.projects.ServiceProjectNature;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ServiceProjectController
implements IServiceProjectController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Pattern ESCAPED_URI_CHAR_REGEX = Pattern.compile("(%[0-9A-Fa-f]{2})");
    private IProject project;
    private IFile servicePropertiesFile;
    private ServiceModelController serviceModelController;

    public ServiceProjectController(IProject project) {
        this.project = project;
        this.servicePropertiesFile = this.project.getFile("service.properties");
        this.serviceModelController = new ServiceModelController(this.servicePropertiesFile);
    }

    public static ServiceProjectController createNewServiceProject(String projectName, IProgressMonitor monitor) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        project.create(monitor);
        project.open(monitor);
        ServiceProjectNature.appendNature((IProject)project);
        return new ServiceProjectController(project);
    }

    @Override
    public IFolder getFolder(String folderName) throws CoreException {
        this.createFolderInProject(folderName, (IProgressMonitor)new NullProgressMonitor());
        return this.project.getFolder(folderName);
    }

    @Override
    public IFile getServicePropertiesFile(IProgressMonitor monitor) throws CoreException {
        if (!this.servicePropertiesFile.exists()) {
            this.createFileInProject("service.properties", monitor);
        }
        return this.servicePropertiesFile;
    }

    @Override
    public IFile getServicePropertiesFile() throws CoreException {
        return this.getServicePropertiesFile((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public ServiceModelController getServiceModel() {
        return this.serviceModelController;
    }

    @Override
    public void createFolderInProject(String folderName, IProgressMonitor monitor) throws CoreException {
        IFolder newFolder = this.project.getFolder(folderName);
        if (!newFolder.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FOLDER", (String[])new String[]{folderName}), -1);
            newFolder.create(true, true, monitor);
            newFolder.refreshLocal(2, monitor);
            monitor.done();
        }
    }

    @Override
    public void createFolderInProject(String folderName) throws CoreException {
        this.createFolderInProject(folderName, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void createFileInProject(String fileName, IProgressMonitor monitor) throws CoreException {
        IFile newFile = this.project.getFile(fileName);
        if (!newFile.exists()) {
            monitor.beginTask(Xlat.description((String)"STATUS_CREATING_FILE", (String[])new String[]{fileName}), -1);
            ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
            newFile.create((InputStream)is, true, monitor);
            newFile.refreshLocal(2, monitor);
            monitor.done();
        }
    }

    @Override
    public void createFileInProject(String fileName) throws CoreException {
        this.createFileInProject(fileName, (IProgressMonitor)new NullProgressMonitor());
    }

    public static String decodeServiceName(String serviceName) {
        StringBuffer retVal = new StringBuffer();
        Matcher matcher = ESCAPED_URI_CHAR_REGEX.matcher(serviceName);
        while (matcher.find()) {
            String encoded = matcher.group();
            int codepoint = Integer.parseInt(encoded.substring(1), 16);
            String decoded = String.valueOf((char)codepoint);
            matcher.appendReplacement(retVal, decoded);
        }
        matcher.appendTail(retVal);
        return retVal.toString();
    }
}

