/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers.model;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionCompositeProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ServiceModelController
implements IServiceModelController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IFile servicePropertiesFile;
    private Properties properties = new Properties();
    private static final List<String> STANDARD_SERVICE_PROPERTIES = Arrays.asList("name", "version", "description", "servicetype", "provider");
    private final String defaultString = "";
    private final String defaultFalseValue = "false";
    private final String defaultTrueValue = "true";
    private final String defaultIntString = "-1";

    public ServiceModelController(IFile servicePropertiesFile) {
        this.servicePropertiesFile = servicePropertiesFile;
        if (servicePropertiesFile.exists()) {
            this.loadPropertiesFromServicePropertiesFile();
        } else {
            this.properties = new Properties();
        }
    }

    public void loadPropertiesFromServicePropertiesFile() {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"loadPropertiesFromServicePropertiesFile", (Object[])new Object[0]);
        try {
            InputStream is = this.servicePropertiesFile.getContents();
            ZCeeUILogger.info((String)"Loading properties from file {0}", (Object[])new Object[]{this.servicePropertiesFile.getName()});
            this.properties = new Properties();
            this.properties.load(is);
            is.close();
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"loadPropertiesFromServicePropertiesFile", (Object[])new Object[0]);
    }

    public void savePropertiesAndRefreshProjectExplorer() {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"savePropertiesAndRefreshProjectExplorer", (Object[])new Object[0]);
        try {
            FileOutputStream os = new FileOutputStream(this.servicePropertiesFile.getLocation().toFile());
            ZCeeUILogger.info((String)"Writing properties to file {0}", (Object[])new Object[]{this.servicePropertiesFile.getName()});
            this.getServiceExtension().omitProperties(this.properties).store(os, null);
            ((OutputStream)os).close();
            this.servicePropertiesFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"savePropertiesAndRefreshProjectExplorer", (Object[])new Object[0]);
    }

    public void setAllServiceProperties(String name, String description, String type) throws CoreException {
        this.properties.put("name", name);
        this.properties.put("version", "1.0.0");
        this.properties.put("description", description);
        this.properties.put("servicetype", type);
        this.properties.put("provider", this.getServiceExtension().getProvider());
        this.setServiceExtensionCompositeProperties(this.getServiceExtension());
        this.setServiceExtensionConfigurationProperties(this.getServiceExtension());
        this.savePropertiesAndRefreshProjectExplorer();
    }

    @Override
    public IProject getServiceProject() {
        return this.servicePropertiesFile.getProject();
    }

    public String getServiceName() {
        return this.properties.getProperty("name", "");
    }

    public String getServiceVersion() {
        return this.properties.getProperty("version", "");
    }

    @Override
    public String getServiceSQL() {
        return this.properties.getProperty("sqlCommand", "");
    }

    @Override
    public String getServiceConnectionName() {
        return this.properties.getProperty("connectionName", "");
    }

    @Override
    public String getServicePSBName() {
        return this.properties.getProperty("psbName", "");
    }

    @Override
    public Boolean getArraySupport() {
        String value = this.properties.getProperty("arraySupport", "true");
        if (value != null && value.contentEquals("true")) {
            return true;
        }
        return false;
    }

    @Override
    public String getServiceMetadata() {
        return this.properties.getProperty("metadata", "false");
    }

    @Override
    public String getServiceRequestSIName() {
        return this.properties.getProperty("requestSIName", "");
    }

    @Override
    public String getServiceResponseSIName() {
        return this.properties.getProperty("responseSIName", "");
    }

    public String getServiceDescription() {
        return this.properties.getProperty("description", "");
    }

    public String getServiceType() {
        return this.properties.getProperty("servicetype", "");
    }

    public String getServiceTypeLabel() {
        String tempLabel = this.getServiceExtension().getTypeLabelFromExtension(this.getServiceType());
        if (this.getServiceExtension().getLabel() == null || tempLabel.isEmpty()) {
            return Xlat.error((String)"ERROR_UNKNOWN_SERVICE");
        }
        return tempLabel;
    }

    public void setServiceName(String name) {
        this.properties.put("name", name);
    }

    public void setServiceVersion(String version) {
        this.properties.put("version", version);
    }

    public void setServiceDescription(String description) {
        this.properties.put("description", description);
    }

    public void setServiceType(String serviceType) {
        this.properties.put("servicetype", serviceType);
    }

    @Override
    public void setServiceSQL(String sqlCommand) {
        this.properties.put("sqlCommand", sqlCommand);
    }

    @Override
    public void setServiceConnectionName(String connection) {
        this.properties.put("connectionName", connection);
    }

    @Override
    public void setServicePSBName(String psbname) {
        this.properties.put("psbName", psbname);
    }

    @Override
    public void setArraySupport(Boolean arraySupport) {
        this.properties.put("arraySupport", Boolean.valueOf(arraySupport).toString());
    }

    @Override
    public void setServiceMetadata(String generated) {
        this.properties.put("metadata", generated);
    }

    @Override
    public void setServiceRequestSIName(String requestSIName) {
        this.properties.put("requestSIName", requestSIName);
    }

    @Override
    public void setServiceResponseSIName(String responseSIName) {
        this.properties.put("responseSIName", responseSIName);
    }

    public String getServiceTitle() {
        String retVal = this.getServiceName();
        return retVal;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static List<String> getStandardPropertyNamesList() {
        return new ArrayList<String>(STANDARD_SERVICE_PROPERTIES);
    }

    public Set<String> getExistingNonStandardPropertyNamesList() {
        HashSet<String> stringPropertyNames = new HashSet<String>(this.properties.stringPropertyNames());
        stringPropertyNames.removeAll(ServiceModelController.getStandardPropertyNamesList());
        return stringPropertyNames;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public String getValue(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public void setValue(String key, String value) {
        this.properties.put(key, value);
    }

    public boolean existsPropertiesFile() {
        return this.servicePropertiesFile.exists();
    }

    @Override
    public IResource getResource() {
        return this.servicePropertiesFile;
    }

    public ServiceExtension getServiceExtension() {
        return ServiceExtension.getServiceExtension(this.getServiceType());
    }

    public void setServiceExtensionCompositeProperties(ServiceExtension serviceExtension) {
        for (ServiceExtensionCompositeProperty s : serviceExtension.getCompositeProperties()) {
            if (s.getProjectKey() == null || s.getProjectKey().isEmpty()) continue;
            if (s.getDefaultValue() != null) {
                this.properties.put(s.getProjectKey(), s.getDefaultValue());
                continue;
            }
            this.properties.put(s.getProjectKey(), "");
        }
    }

    public void setServiceExtensionConfigurationProperties(ServiceExtension serviceExtension) {
        for (ServiceExtensionProperty s : serviceExtension.getProperties()) {
            if (s.getPropertyType().equalsIgnoreCase(IServicePropertiesValidator.ProviderPropertyType.STRING.toString())) {
                if (s.isRequired() && !s.getPropertyAcceptedValues().isEmpty()) {
                    this.properties.put(s.getPropertyName(), s.getPropertyAcceptedValues().iterator().next());
                    continue;
                }
                if (s.isRequired() && s.getPropertyAcceptedValues().isEmpty() && s.getPropertyDefaultValue() != null && !s.getPropertyDefaultValue().isEmpty()) {
                    this.properties.put(s.getPropertyName(), s.getPropertyDefaultValue());
                    continue;
                }
                this.properties.put(s.getPropertyName(), "");
                continue;
            }
            if (s.getPropertyType().equalsIgnoreCase(IServicePropertiesValidator.ProviderPropertyType.BOOLEAN.toString())) {
                this.properties.put(s.getPropertyName(), "false");
                continue;
            }
            if (!s.getPropertyType().equalsIgnoreCase(IServicePropertiesValidator.ProviderPropertyType.INTEGER.toString())) continue;
            this.properties.put(s.getPropertyName(), "-1");
        }
    }
}

