/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers.model;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.controllers.exceptions.ServiceTypeExtensionException;
import java.util.Set;

public class ServiceExtensionProperty
implements Comparable<ServiceExtensionProperty> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String propertyName;
    private String propertyType;
    private boolean isRequired;
    private String propertyLabel;
    private Set<String> propertyAcceptedValues;
    private String defaultValue;
    private String dependsOn;
    private boolean omitIfDefault;
    private Integer displayOrder;
    private String tooltip;
    private String helpContextId;

    public ServiceExtensionProperty(String propertyName, String propertyType, boolean isRequired, String propertyLabel, Set<String> propertyAcceptedValues, String defaultValue, String dependsOn, boolean omitIfDefault, String displayOrder, String tooltip, String helpContextId) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.isRequired = isRequired;
        this.propertyLabel = propertyLabel;
        this.propertyAcceptedValues = propertyAcceptedValues;
        this.defaultValue = defaultValue;
        this.dependsOn = dependsOn;
        this.omitIfDefault = omitIfDefault;
        if (displayOrder != null && !displayOrder.isEmpty()) {
            try {
                this.displayOrder = Integer.parseInt(displayOrder);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceTypeExtensionException e = new ServiceTypeExtensionException(Xlat.error((String)"UNSUPPORTED_DISPLAY_ORDER_VALUE", (String[])new String[]{displayOrder}));
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                ZCeeErrorDialog.openError((Exception)e);
            }
        }
        this.tooltip = tooltip;
        this.helpContextId = helpContextId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public Set<String> getPropertyAcceptedValues() {
        return this.propertyAcceptedValues;
    }

    public String getPropertyDefaultValue() {
        return this.defaultValue;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public boolean getOmitIfDefault() {
        return this.omitIfDefault;
    }

    public void setOmitIfDefault(boolean omitIfDefault) {
        this.omitIfDefault = omitIfDefault;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getHelpContextId() {
        return this.helpContextId;
    }

    @Override
    public int compareTo(ServiceExtensionProperty sep) {
        if (this.displayOrder != null) {
            if (sep.getDisplayOrder() != null) {
                return this.displayOrder.compareTo(sep.getDisplayOrder());
            }
            return -1;
        }
        if (sep.getDisplayOrder() != null) {
            return 1;
        }
        return this.getPropertyLabel().compareTo(sep.getPropertyLabel());
    }

    public String toString() {
        String s = "Name: " + this.propertyName + "\nType: " + this.propertyType + "\nRequired: " + String.valueOf(this.isRequired) + "\nLabel: " + this.propertyLabel + "\nAccepted values: " + this.propertyAcceptedValues.toString() + "\nDefault value: " + this.defaultValue + "\nDepends on value: " + this.dependsOn + "\nOmit if default: " + this.omitIfDefault + "\nDisplay order value: " + String.valueOf(this.displayOrder) + "\nTooltip value: " + this.tooltip + "\nHelp context id value: " + this.helpContextId;
        return s;
    }
}

