/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers.model;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceCapabilityValidatorExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionCompositeProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceBuilder;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ServiceExtension {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IConfigurationElement[] serviceTypeElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.zosconnect.ui.servicetype");
    private String type;
    private String label;
    private String provider;
    private HashSet<String> projectNatureIds;
    private String compositeClass;
    private String validatorClass;
    private String sarGeneratorClass;
    private String builderClass;
    private String serviceIntefaceServiceType;
    private HashSet<ServiceExtensionProperty> properties;
    private HashMap<String, ServiceCapabilityValidatorExtension> capabilityValidatorExtensions;
    private HashSet<String> propertiesStringNames;
    private IConfigurationElement configurationElement;
    private HashSet<String> validServiceTypes;
    private HashSet<String> providerPrivateServiceNames;
    private String helpContextId;
    private HashSet<ServiceExtensionCompositeProperty> compositeProperties;
    private static final String EMPTY_STRING = "";

    private ServiceExtension(String type, String label, String provider, String validatorClass, String sarGeneratorClass, HashSet<ServiceExtensionProperty> properties, HashMap<String, ServiceCapabilityValidatorExtension> capabilityValidators, IConfigurationElement configurationElement, HashSet<String> validServiceTypes, HashSet<String> providerPrivateServiceNames, String helpContextId, String compositeClass, HashSet<ServiceExtensionCompositeProperty> compositeProperties, String builderClass, HashSet<String> projectNatureIds, String serviceInterfaceServiceType) {
        this.type = type;
        this.label = label;
        this.provider = provider;
        this.projectNatureIds = projectNatureIds;
        this.compositeClass = compositeClass;
        this.validatorClass = validatorClass;
        this.sarGeneratorClass = sarGeneratorClass;
        this.builderClass = builderClass;
        this.properties = properties;
        this.capabilityValidatorExtensions = capabilityValidators;
        this.configurationElement = configurationElement;
        this.validServiceTypes = validServiceTypes;
        this.providerPrivateServiceNames = providerPrivateServiceNames;
        this.helpContextId = helpContextId;
        this.compositeProperties = compositeProperties;
        this.serviceIntefaceServiceType = serviceInterfaceServiceType;
        this.setPropertiesAsStringSet(properties);
    }

    public static HashSet<String> getAllProviders() {
        HashSet<String> providers = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = serviceTypeElements;
        int n = serviceTypeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extensionElement = iConfigurationElementArray[n2];
            if (extensionElement.getName().equals("service")) {
                providers.add(extensionElement.getAttribute("provider"));
            }
            ++n2;
        }
        return providers;
    }

    public static HashSet<String> getAllProviderPrivateServiceNames() {
        HashSet<String> providerPrivateServiceNames = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = serviceTypeElements;
        int n = serviceTypeElements.length;
        int n2 = 0;
        while (n2 < n) {
            String providerPrivateServiceNamesVal;
            IConfigurationElement extensionElement = iConfigurationElementArray[n2];
            if (extensionElement.getName().equals("service") && !StringUtils.isBlank((CharSequence)(providerPrivateServiceNamesVal = extensionElement.getAttribute("providerPrivateServiceNames")))) {
                String[] stringArray = providerPrivateServiceNamesVal.split(",");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String serviceName = stringArray[n4];
                    providerPrivateServiceNames.add(serviceName);
                    ++n4;
                }
            }
            ++n2;
        }
        return providerPrivateServiceNames;
    }

    public static ServiceExtension getServiceExtension(String type) {
        String label = EMPTY_STRING;
        String provider = EMPTY_STRING;
        HashSet<String> projectNatureIds = new HashSet<String>();
        String compositeClass = EMPTY_STRING;
        String validatorClass = EMPTY_STRING;
        String sarGenClass = EMPTY_STRING;
        String builderClass = EMPTY_STRING;
        String privateServiceNames = EMPTY_STRING;
        String helpContextId = EMPTY_STRING;
        String serviceInterfaceServiceType = EMPTY_STRING;
        HashSet<ServiceExtensionCompositeProperty> compositeProperties = new HashSet<ServiceExtensionCompositeProperty>();
        HashSet<ServiceExtensionProperty> properties = new HashSet<ServiceExtensionProperty>();
        HashMap<String, ServiceCapabilityValidatorExtension> allCapabilityValidators = new HashMap<String, ServiceCapabilityValidatorExtension>();
        IConfigurationElement configurationElement = null;
        HashSet<String> validServiceTypes = new HashSet<String>();
        HashSet<String> providerPrivateServiceNames = new HashSet<String>();
        ArrayList<String> serviceTypeCapabilityValidatorIds = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = serviceTypeElements;
        int n = serviceTypeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extensionElement = iConfigurationElementArray[n2];
            if (extensionElement.getName().equals("service")) {
                String serviceType = extensionElement.getAttribute("serviceType");
                validServiceTypes.add(serviceType);
                if (serviceType.equals(type)) {
                    int n3;
                    int n4;
                    String[] stringArray;
                    label = extensionElement.getAttribute("label");
                    provider = extensionElement.getAttribute("provider");
                    String projectNatureIdsAttribute = extensionElement.getAttribute("projectNatureIds");
                    if (!StringUtils.isBlank((CharSequence)projectNatureIdsAttribute)) {
                        stringArray = projectNatureIdsAttribute.split(",");
                        n4 = stringArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            String projectNatureId = stringArray[n3];
                            projectNatureIds.add(projectNatureId);
                            ++n3;
                        }
                    }
                    compositeClass = extensionElement.getAttribute("compositeClass");
                    validatorClass = extensionElement.getAttribute("validatorClass");
                    sarGenClass = extensionElement.getAttribute("sarGeneratorClass");
                    builderClass = extensionElement.getAttribute("builderClass");
                    privateServiceNames = extensionElement.getAttribute("providerPrivateServiceNames");
                    configurationElement = extensionElement;
                    if (!StringUtils.isBlank((CharSequence)privateServiceNames)) {
                        stringArray = privateServiceNames.split(",");
                        n4 = stringArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            String serviceName = stringArray[n3];
                            providerPrivateServiceNames.add(serviceName);
                            ++n3;
                        }
                    }
                    helpContextId = extensionElement.getAttribute("helpContextId");
                    ArrayList<String> existingProjectKeys = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray2 = extensionElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    n4 = 0;
                    while (n4 < n5) {
                        IConfigurationElement extensionElementChild = iConfigurationElementArray2[n4];
                        if (extensionElementChild.getName().equals("property")) {
                            LinkedHashSet<String> elementChildAcceptedValues = new LinkedHashSet<String>();
                            if (extensionElementChild.getAttribute("acceptedValues") != null && extensionElementChild.getAttribute("acceptedValues").length() != 0) {
                                String[] values;
                                String[] stringArray2 = values = extensionElementChild.getAttribute("acceptedValues").split(",");
                                int n6 = values.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    String s = stringArray2[n7];
                                    elementChildAcceptedValues.add(s);
                                    ++n7;
                                }
                            }
                            properties.add(new ServiceExtensionProperty(extensionElementChild.getAttribute("key"), extensionElementChild.getAttribute("propertyType"), Boolean.valueOf(extensionElementChild.getAttribute("required")), extensionElementChild.getAttribute("label"), elementChildAcceptedValues, extensionElementChild.getAttribute("defaultValue"), extensionElementChild.getAttribute("dependsOn"), Boolean.valueOf(extensionElementChild.getAttribute("omitIfDefault")), extensionElementChild.getAttribute("displayOrder"), extensionElementChild.getAttribute("tooltip"), extensionElementChild.getAttribute("helpContextId")));
                        } else if (extensionElementChild.getName().equals("capabilityValidatorRef")) {
                            serviceTypeCapabilityValidatorIds.add(extensionElementChild.getAttribute("id"));
                        } else if (extensionElementChild.getName().equals("compositeProperty")) {
                            String projectKey = extensionElementChild.getAttribute("projectKey");
                            if (projectKey != null) {
                                if (existingProjectKeys.contains(projectKey)) {
                                    ZCeeUILogger.warn((String)"The service type extension {0} contains multiple composite properties with projectKey \"{1}\".", (Object[])new Object[]{serviceType, projectKey});
                                }
                                existingProjectKeys.add(projectKey);
                            }
                            compositeProperties.add(new ServiceExtensionCompositeProperty(projectKey, extensionElementChild.getAttribute("defaultValue"), Boolean.valueOf(extensionElementChild.getAttribute("omitIfDefault"))));
                        }
                        ++n4;
                    }
                }
            } else if (extensionElement.getName().equals("capabilityValidator")) {
                allCapabilityValidators.put(extensionElement.getAttribute("id"), new ServiceCapabilityValidatorExtension(extensionElement, extensionElement.getAttribute("id"), extensionElement.getAttribute("supportedCapabilities"), extensionElement.getAttribute("validatorClass")));
            }
            ++n2;
        }
        HashMap<String, ServiceCapabilityValidatorExtension> capabilityValidators = new HashMap<String, ServiceCapabilityValidatorExtension>();
        for (String currID : serviceTypeCapabilityValidatorIds) {
            capabilityValidators.put(currID, (ServiceCapabilityValidatorExtension)allCapabilityValidators.get(currID));
        }
        return new ServiceExtension(type, label, provider, validatorClass, sarGenClass, properties, capabilityValidators, configurationElement, validServiceTypes, providerPrivateServiceNames, helpContextId, compositeClass, compositeProperties, builderClass, projectNatureIds, serviceInterfaceServiceType);
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getServiceInterfaceServiceType() {
        return this.serviceIntefaceServiceType;
    }

    public HashSet<String> getProviderPrivateServiceNames() {
        HashSet<String> retVal = null;
        retVal = this.providerPrivateServiceNames != null ? this.providerPrivateServiceNames : new HashSet();
        return retVal;
    }

    public String getHelpContextId() {
        return this.helpContextId;
    }

    public HashSet<String> getProjectNatureIds() {
        HashSet<String> retVal = null;
        retVal = this.projectNatureIds != null ? this.projectNatureIds : new HashSet();
        return retVal;
    }

    public Object getCompositeClass() throws CoreException {
        if (this.configurationElement != null && this.compositeClass != null && !this.compositeClass.isEmpty()) {
            return this.configurationElement.createExecutableExtension("compositeClass");
        }
        return null;
    }

    public IServicePropertiesValidator getValidatorClass() throws CoreException {
        Object executableExtension;
        if (this.configurationElement != null && this.validatorClass != null && !this.validatorClass.isEmpty() && (executableExtension = this.configurationElement.createExecutableExtension("validatorClass")) != null && executableExtension instanceof IServicePropertiesValidator) {
            return (IServicePropertiesValidator)executableExtension;
        }
        return null;
    }

    public String getSarGenClass() {
        if (this.configurationElement != null && this.sarGeneratorClass != null && !this.sarGeneratorClass.isEmpty()) {
            return this.sarGeneratorClass;
        }
        return EMPTY_STRING;
    }

    public IServiceBuilder getBuilderClass() throws CoreException {
        Object executableExtension;
        if (this.configurationElement != null && this.builderClass != null && !this.builderClass.isEmpty() && (executableExtension = this.configurationElement.createExecutableExtension("builderClass")) != null && executableExtension instanceof IServiceBuilder) {
            return (IServiceBuilder)executableExtension;
        }
        return null;
    }

    public HashSet<ServiceExtensionProperty> getProperties() {
        return this.properties;
    }

    public HashSet<ServiceExtensionCompositeProperty> getCompositeProperties() {
        return this.compositeProperties;
    }

    public ServiceExtensionProperty getPropertyByKey(String key) {
        for (ServiceExtensionProperty property : this.properties) {
            if (!property.getPropertyName().equals(key)) continue;
            return property;
        }
        return null;
    }

    public Properties omitProperties(Properties serviceProperties) {
        String defaultValue;
        String value;
        boolean omitIfDefault;
        Properties sanitizedProps = new Properties();
        sanitizedProps.putAll((Map<?, ?>)serviceProperties);
        for (ServiceExtensionProperty property : this.properties) {
            omitIfDefault = property.getOmitIfDefault();
            value = serviceProperties.getProperty(property.getPropertyName());
            if (value == null) {
                value = EMPTY_STRING;
            }
            if ((defaultValue = property.getPropertyDefaultValue()) == null) {
                defaultValue = EMPTY_STRING;
            }
            if (!omitIfDefault || !value.equals(defaultValue)) continue;
            sanitizedProps.remove(property.getPropertyName());
        }
        for (ServiceExtensionCompositeProperty compositeProperty : this.compositeProperties) {
            omitIfDefault = compositeProperty.getOmitIfDefault();
            value = serviceProperties.getProperty(compositeProperty.getProjectKey());
            if (value == null) {
                value = EMPTY_STRING;
            }
            if ((defaultValue = compositeProperty.getDefaultValue()) == null) {
                defaultValue = EMPTY_STRING;
            }
            if (!omitIfDefault || !value.equals(defaultValue)) continue;
            sanitizedProps.remove(compositeProperty.getProjectKey());
        }
        return sanitizedProps;
    }

    public ServiceExtensionProperty getPropertyByLabel(String label) {
        for (ServiceExtensionProperty property : this.properties) {
            if (!property.getPropertyLabel().equals(label)) continue;
            return property;
        }
        return null;
    }

    public String getPropertyValueByKey(String key) {
        return this.configurationElement.getAttribute(key);
    }

    public HashSet<String> getPropertiesAsStringSet() {
        return this.propertiesStringNames;
    }

    private void setPropertiesAsStringSet(HashSet<ServiceExtensionProperty> properties) {
        this.propertiesStringNames = new HashSet();
        for (ServiceExtensionProperty s : properties) {
            this.propertiesStringNames.add(s.getPropertyName());
        }
    }

    public HashSet<String> getValidServiceTypes() {
        return this.validServiceTypes;
    }

    public String getTypeLabelFromExtension(String serviceType) {
        if (this.type.equals(serviceType)) {
            return this.label;
        }
        return null;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public HashMap<String, ServiceCapabilityValidatorExtension> getCapabilityValidators() {
        return this.capabilityValidatorExtensions;
    }

    public static String getLabelUsingServiceInterfaceServiceType(String myServiceInterfaceServiceType) {
        String serviceType = null;
        IConfigurationElement[] iConfigurationElementArray = serviceTypeElements;
        int n = serviceTypeElements.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceInterfaceServiceType;
            IConfigurationElement extensionElement = iConfigurationElementArray[n2];
            if (extensionElement.getName().equals("service") && (serviceInterfaceServiceType = extensionElement.getAttribute("serviceInterfaceServiceType")).equals(myServiceInterfaceServiceType)) {
                serviceType = extensionElement.getAttribute("serviceType");
            }
            ++n2;
        }
        if (serviceType == null) {
            return myServiceInterfaceServiceType;
        }
        return ServiceExtension.getServiceExtension(serviceType).getLabel();
    }
}

