/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers;

import com.ibm.zosconnect.buildtoolkit.SARGenerator;
import com.ibm.zosconnect.buildtoolkit.Trace;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionCompositeProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ServiceExportController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    final String className = this.getClass().getName();
    private IProject inputProject;
    private String outputZipFilePath;
    private File outputZipFile;
    private String inputProjectPath;

    public ServiceExportController(IProject project) {
        this.inputProject = project;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputZipFilePath = outputFileName;
    }

    public boolean createZipFile() throws Exception {
        String currentPropertyValue;
        ZCeeUILogger.entering((String)this.className, (String)"createZipFile", (Object[])new Object[0]);
        boolean methodsRemoved = false;
        this.outputZipFile = new File(this.outputZipFilePath);
        this.inputProjectPath = this.inputProject.getLocation().toOSString();
        ServiceProjectController serviceProject = new ServiceProjectController(this.inputProject);
        this.inputProject.build(6, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("name", serviceProject.getServiceModel().getServiceName());
        parms.put("provider", serviceProject.getServiceModel().getServiceExtension().getProvider());
        parms.put("version", serviceProject.getServiceModel().getServiceVersion());
        parms.put("description", serviceProject.getServiceModel().getServiceDescription());
        parms.put("projectFolder", this.inputProjectPath);
        for (ServiceExtensionCompositeProperty property : serviceProject.getServiceModel().getServiceExtension().getCompositeProperties()) {
            currentPropertyValue = serviceProject.getServiceModel().getValue(property.getProjectKey());
            if (currentPropertyValue == null) continue;
            parms.put(property.getProjectKey(), currentPropertyValue);
        }
        for (ServiceExtensionProperty sep : serviceProject.getServiceModel().getServiceExtension().getProperties()) {
            currentPropertyValue = serviceProject.getServiceModel().getValue(sep.getPropertyName());
            if (currentPropertyValue == null) continue;
            parms.put(sep.getPropertyName(), currentPropertyValue);
        }
        if (ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
            Trace.active();
        }
        String provider = serviceProject.getServiceModel().getServiceExtension().getProvider();
        String genClass = serviceProject.getServiceModel().getServiceExtension().getSarGenClass();
        SARGenerator.addPlugin((String)provider, (String)genClass);
        SARGenerator sarGenerator = new SARGenerator(parms);
        if (!this.outputZipFilePath.endsWith(".sar")) {
            this.outputZipFilePath = String.valueOf(this.outputZipFilePath) + ".sar";
        }
        sarGenerator.save(this.outputZipFile.getAbsolutePath());
        Trace.deactivate();
        ZCeeUILogger.exiting((String)this.className, (String)"createZipFile", (Object[])new Object[]{methodsRemoved});
        return methodsRemoved;
    }

    public byte[] getZipFileBytes() {
        byte[] fileBytes = null;
        if (this.outputZipFile != null) {
            File file = this.outputZipFile;
            try {
                FileInputStream fin = new FileInputStream(file);
                fileBytes = new byte[(int)file.length()];
                fin.read(fileBytes);
                fin.close();
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
        return fileBytes;
    }

    public String getProjectName() {
        return this.inputProject.getName();
    }

    public IProject getProject() {
        return this.inputProject;
    }
}

