/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ServiceDeployController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<IProject> projects;

    public ServiceDeployController(List<IProject> projects) {
        this.projects = projects;
    }

    public List<IProject> getProjects() {
        return this.projects;
    }

    public ArrayList<ServiceModelController> getServiceModelControllers() {
        ArrayList<ServiceModelController> retVal = new ArrayList<ServiceModelController>();
        int i = 0;
        while (i < this.projects.size()) {
            IProject proj = this.projects.get(i);
            IFile servicePropertiesFile = proj.getFile("service.properties");
            try {
                retVal.add(new ServiceModelController(servicePropertiesFile));
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++i;
        }
        return retVal;
    }

    public HashMap<String, ServiceModelController> getServiceModelControllersMap() {
        HashMap<String, ServiceModelController> retVal = new HashMap<String, ServiceModelController>();
        int i = 0;
        while (i < this.projects.size()) {
            IProject proj = this.projects.get(i);
            IFile servicePropertiesFile = proj.getFile("service.properties");
            try {
                retVal.put(proj.getName(), new ServiceModelController(servicePropertiesFile));
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++i;
        }
        return retVal;
    }
}

