/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.controllers;

import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;

public class AdvancedDataConversionOptionsController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DEFAULT_STRING = "";
    public static final String IMS_LARGE_DATA_SERVICE = "imsLargeDataStructure";
    public static final String IMS_TRAN_SERVICE = "imsMessageSegment";
    public static final String CICS_CHANNEL = "cicsChannel";
    public static final String CICS_COMMAREA = "cicsCommarea";
    private IServiceModelController serviceModelController;
    private Boolean saveTrimOutputLeadingWhitespace;
    private Boolean saveTrimOutputTrailingWhitespace;
    private Boolean saveEscapeOutputControlCharacters;
    private Boolean saveInitializeInputFields;
    private Boolean saveOmitOutputFieldsByValue;
    private String saveOmitOutputFieldsByValueByte;
    private Boolean saveOmitOutputEmptyTags;
    private Boolean saveEnforceMinArrayOccurrence;
    private Boolean saveEnforceMinArrayOccurrenceResponse;
    private Boolean saveLdsStartsWithLLZZTRANCODE;
    private Boolean saveLdsStartsWithLLZZ;
    private Boolean saveTruncateInputLastCharField;

    public AdvancedDataConversionOptionsController(IServiceModelController serviceModelController) {
        this.serviceModelController = serviceModelController;
    }

    public IServiceModelController getServiceModelController() {
        return this.serviceModelController;
    }

    public void setTrimOutputLeadingWhitespace(boolean bool) {
        this.serviceModelController.setValue("trimOutputLeadingWhitespace", String.valueOf(bool));
    }

    public void setTrimOutputTrailingWhitespace(boolean bool) {
        this.serviceModelController.setValue("trimOutputTrailingWhitespace", String.valueOf(bool));
    }

    public void setEscapeControlCharacters(boolean bool) {
        this.serviceModelController.setValue("escapeOutputControlCharacters", String.valueOf(bool));
    }

    public void setInitializeInputField(boolean bool) {
        this.serviceModelController.setValue("initializeInputFields", String.valueOf(bool));
    }

    public void setEnforceMinArrayOccurrence(boolean bool) {
        this.serviceModelController.setValue("enforceMinArrayOccurrence", String.valueOf(bool));
    }

    public void setOmitFieldsByValue(boolean bool) {
        this.serviceModelController.setValue("omitOutputFieldsByValue", String.valueOf(bool));
    }

    public void setOmitFieldsByValueByte(String value) {
        Object prefixedValue = value.startsWith("0x") ? value : "0x" + value;
        this.serviceModelController.setValue("omitOutputFieldsByValueByte", (String)prefixedValue);
    }

    public void setOmitOutputEmptyTags(boolean bool) {
        this.serviceModelController.setValue("omitOutputEmptyTags", String.valueOf(bool));
    }

    public void setEnforceMinArrayOccurrenceResponse(boolean bool) {
        this.serviceModelController.setValue("enforceMinArrayOccurrenceResponse", String.valueOf(bool));
    }

    public void setLdsStartsWithLLZZTRANCODE(boolean bool) {
        this.serviceModelController.setValue("ldsStartsWithLLZZTRANCODE", String.valueOf(bool));
    }

    public void setLdsStartsWithLLZZ(boolean bool) {
        this.serviceModelController.setValue("ldsStartsWithLLZZ", String.valueOf(bool));
    }

    public void setTruncateInputLastCharField(boolean bool) {
        this.serviceModelController.setValue("truncateInputLastCharField", String.valueOf(bool));
    }

    public boolean getTrimOutputLeadingWhitespace() {
        String value = this.serviceModelController.getValue("trimOutputLeadingWhitespace");
        return value != null && value.contentEquals("true");
    }

    public boolean getTrimOutputTrailingWhitespace() {
        String value = this.serviceModelController.getValue("trimOutputTrailingWhitespace");
        return value != null && value.contentEquals("true");
    }

    public boolean getEscapeControlCharacters() {
        String value = this.serviceModelController.getValue("escapeOutputControlCharacters");
        return value != null && value.contentEquals("true");
    }

    public boolean getInitializeInputField() {
        String value = this.serviceModelController.getValue("initializeInputFields");
        return value != null && value.contentEquals("true");
    }

    public boolean getEnforceMinArrayOccurrence() {
        String value = this.serviceModelController.getValue("enforceMinArrayOccurrence");
        return value != null && value.contentEquals("true");
    }

    public boolean getOmitFieldsByValue() {
        String value = this.serviceModelController.getValue("omitOutputFieldsByValue");
        return value != null && value.contentEquals("true");
    }

    public String getOmitFieldsByValueByte() {
        String retVal = this.serviceModelController.getValue("omitOutputFieldsByValueByte");
        if (retVal == null) {
            retVal = DEFAULT_STRING;
        }
        if (retVal.startsWith("0x")) {
            retVal = retVal.substring(2);
        }
        return retVal;
    }

    public boolean getOmitOutputEmptyTags() {
        String value = this.serviceModelController.getValue("omitOutputEmptyTags");
        return value != null && value.contentEquals("true");
    }

    public boolean getEnforceMinArrayOccurrenceResponse() {
        String value = this.serviceModelController.getValue("enforceMinArrayOccurrenceResponse");
        return value != null && value.contentEquals("true");
    }

    public boolean getLdsStartsWithLLZZTRANCODE() {
        String value = this.serviceModelController.getValue("ldsStartsWithLLZZTRANCODE");
        return value != null && value.contentEquals("true");
    }

    public boolean getLdsStartsWithLLZZ() {
        String value = this.serviceModelController.getValue("ldsStartsWithLLZZ");
        return value != null && value.contentEquals("true");
    }

    public boolean getTruncateInputLastCharField() {
        String value = this.serviceModelController.getValue("truncateInputLastCharField");
        return value != null && value.contentEquals("true");
    }

    public void saveAdvancedOptions() {
        this.saveTrimOutputLeadingWhitespace = this.getTrimOutputLeadingWhitespace();
        this.saveTrimOutputTrailingWhitespace = this.getTrimOutputTrailingWhitespace();
        this.saveEscapeOutputControlCharacters = this.getEscapeControlCharacters();
        this.saveInitializeInputFields = this.getInitializeInputField();
        this.saveOmitOutputFieldsByValue = this.getOmitFieldsByValue();
        this.saveOmitOutputFieldsByValueByte = this.getOmitFieldsByValueByte();
        this.saveOmitOutputEmptyTags = this.getOmitOutputEmptyTags();
        this.saveEnforceMinArrayOccurrence = this.getEnforceMinArrayOccurrence();
        this.saveEnforceMinArrayOccurrenceResponse = this.getEnforceMinArrayOccurrenceResponse();
        String serviceType = this.serviceModelController.getValue("servicetype");
        if (serviceType.equals(IMS_LARGE_DATA_SERVICE) || serviceType.equals(IMS_TRAN_SERVICE)) {
            this.saveLdsStartsWithLLZZTRANCODE = this.getLdsStartsWithLLZZTRANCODE();
            this.saveLdsStartsWithLLZZ = this.getLdsStartsWithLLZZ();
            this.saveTruncateInputLastCharField = this.getTruncateInputLastCharField();
        }
    }

    public void restoreAdvancedOptions() {
        this.setTrimOutputLeadingWhitespace(this.saveTrimOutputLeadingWhitespace);
        this.setTrimOutputTrailingWhitespace(this.saveTrimOutputTrailingWhitespace);
        this.setEscapeControlCharacters(this.saveEscapeOutputControlCharacters);
        this.setInitializeInputField(this.saveInitializeInputFields);
        this.setEnforceMinArrayOccurrence(this.saveEnforceMinArrayOccurrence);
        this.setOmitFieldsByValue(this.saveOmitOutputFieldsByValue);
        this.setOmitFieldsByValueByte(this.saveOmitOutputFieldsByValueByte);
        this.setOmitOutputEmptyTags(this.saveOmitOutputEmptyTags);
        this.setEnforceMinArrayOccurrenceResponse(this.saveEnforceMinArrayOccurrenceResponse);
        String serviceType = this.serviceModelController.getValue("servicetype");
        if (serviceType.equals(IMS_LARGE_DATA_SERVICE) || serviceType.equals(IMS_TRAN_SERVICE)) {
            this.setLdsStartsWithLLZZTRANCODE(this.saveLdsStartsWithLLZZTRANCODE);
            this.setLdsStartsWithLLZZ(this.saveLdsStartsWithLLZZ);
            this.setTruncateInputLastCharField(this.saveTruncateInputLastCharField);
        }
    }
}

