/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72," 
 *   years="2005,2012" 
 *   crc="1866746417" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72, 
 *    
 *   (C) Copyright IBM Corp. 2005, 2012 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.extensions.TreeNodeId;

/**
 * Tree node factory class, this class is supplied to the extension point and is responsible for
 * creating tree nodes for display in the Navigator View
 */
public class SimpleTreeNodeFactory implements IExecutableExtension, ITreeNodeFactory {

  /** SCSS id - expanded when file is extracted from CMVC */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimpleTreeNodeFactory.java"; //$NON-NLS-1$

  /** Copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** Empty simple object for use with the tree node */
  private static SimpleObject simpleObject = null;

  /**
   * Constructor
   */
  public SimpleTreeNodeFactory() {
    super();
    simpleObject = new SimpleObject();
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory#addChildrenToTreeNode(com.ibm.mq.explorer
   * .ui.extensions.TreeNode)
   */
  public void addChildrenToTreeNode(TreeNode parent) {
    String parentId = parent.getId();
    if (parentId.compareTo(TreeNodeId.NODEID_WMQ) == 0) {
      SimpleTreeNode simpleTreeNode = (SimpleTreeNode) simpleObject.getTreeNode();
      if (simpleTreeNode == null) {
        simpleTreeNode = new SimpleTreeNode(parent, simpleObject, SimplePlugin.PLUGIN_ID);
        simpleObject.setTreeNode(simpleTreeNode);
        parent.addChildToNode(simpleTreeNode, TreeNode.SIMPLE_COMPLEXITY); // add as a simple node
      }
      else {
        simpleTreeNode.setParent(parent);
      }
    }
  }

  /*
   * (non-Javadoc)
   * @see
   * org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime
   * .IConfigurationElement, java.lang.String, java.lang.Object)
   */
  public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {
  // Not used
  }

}
