/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="4179772285" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.SequenceId;
import com.ibm.mq.explorer.ui.extensions.TreeNode;

/**
 * Simple tree node - this class is the actual treenode that appears in the Navigator view
 */
public class SimpleTreeNode extends TreeNode {

  /** SCCS id - expanded when file is extracted from CMVC */
  @SuppressWarnings("hiding")
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimpleTreeNode.java"; //$NON-NLS-1$

  /** Copyright notice */
  @SuppressWarnings("hiding")
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /**
   * Constructor
   * 
   * @param parent the parent tree node
   * @param object the MQExtObject associated with this treenode
   * @param plugin_id the ID of the plug-in creating the node
   */
  public SimpleTreeNode(TreeNode parent, MQExtObject object, String plugin_id) {
    super(parent, object, plugin_id);
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return "Simple"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#getId()
   */
  public String getId() {
    return "com.ibm.mq.explorer.sample.simple"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#getSequence()
   */
  public String getSequence() {
    return SequenceId.SEQ_SAMPLE_SIMPLE_PLUGIN;
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#getContentPageId()
   */
  public String getContentPageId() {
    return "com.ibm.mq.explorer.sample.simple"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#getIcon()
   */
  public Image getIcon() {
    return null;
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.TreeNode#compare(com.ibm.mq.explorer.ui.extensions.TreeNode,
   * com.ibm.mq.explorer.ui.extensions.TreeNode)
   */
  public int compare(TreeNode child1, TreeNode child2) {
    return super.compareBySequence(child1, child2);
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#isContextMenuFromUiMQObject()
   */
  public boolean isContextMenuFromUiObject() {
    return false;
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.TreeNode#appendToContextMenu(org.eclipse.swt.widgets.Shell,
   * org.eclipse.jface.action.IMenuManager)
   */
  public void appendToContextMenu(Shell shell, IMenuManager manager) {
  // not used
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#isAddChildrenWhenExpanded()
   */
  public boolean isAddChildrenWhenExpanded() {
    return false;
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.TreeNode#getHelpId()
   */
  public String getHelpId() {
    return null;
  }

}
