/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2003,2014" 
 *   crc="2948047940" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2003, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.swt.widgets.Composite;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.IPropertyTabFactory;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.PropertyPage;

/**
 * Defines the interface to be provided by this Simple class which contributes Property Pages for
 * associated property tabs in a property dialog
 */
public class SimplePropertyTabFactory implements IPropertyTabFactory {

  /** Common copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** CMVC descriptors - expanded during extraction */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimplePropertyTabFactory.java"; //$NON-NLS-1$

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IPropertyTabFactory#createPropertyPage(org.eclipse.swt.widgets
   * .Composite, com.ibm.mq.explorer.ui.internal.objects.MQExtObject,
   * com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup)
   */
  public PropertyPage createPropertyPage(Composite parent, MQExtObject mqExtObj, Object uiDispGroup) {

    return new SimplePropertyPage(parent, 0, mqExtObj, uiDispGroup, false);
  }

}
