/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2007,2014" 
 *   crc="2622311409" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2007, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.PropertyPage;

/**
 * Sample Simple Property Page to display a label, input text box and a third label that gets
 * updated when apply is hit.
 */
public class SimplePropertyPage extends PropertyPage {

  /** Common copyright notice */
  @SuppressWarnings("hiding")
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** CMVC descriptors - expanded during extraction */
  @SuppressWarnings("hiding")
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimplePropertyPage.java"; //$NON-NLS-1$

  /** The parent composite */
  private Composite parent;

  /** The text field to input a name */
  private Text nameText;

  /** The Label that gets updated every time the apply or ok buttons are pressed */
  private Label messageLabel;

  /** The current name that the user has entered */
  private String currentName;

  /**
   * Constructor
   * 
   * @param parent the parent composite
   * @param style the SWT style flags to use
   * @param mqExtObj the object for which the property page is for
   * @param internalObj an internal MQ object
   * @param readonly whether the controls should be readonly
   */
  public SimplePropertyPage(
    Composite parent,
    int style,
    MQExtObject mqExtObj,
    Object internalObj,
    boolean readonly) {

    super(parent, style, mqExtObj, internalObj, readonly);
    this.parent = parent;
    currentName = ""; //$NON-NLS-1$

  }

  /**
   * Notification that Apply has been pressed - Gets the name that has been input by the user and
   * updates the message label to say hello + name
   * 
   * @see com.ibm.mq.explorer.ui.extensions.PropertyPage#apply()
   */
  public void apply() {
    System.out.println("com.ibm.mq.explorer.sample.simple.SimplePropertyPage:apply() called"); //$NON-NLS-1$ 

    // Update the UI components
    parent.getDisplay().asyncExec(new Runnable() {

      public void run() {
        // Get the text from the input text box
        currentName = nameText.getText();
        // Update the message label
        messageLabel.setText("Hello " + currentName); //$NON-NLS-1$
      }
    });

  }

  /**
   * Initialises and lays out the property controls for the property page. Creates a label that
   * prompts the user to enter their name, an input text box where the user can input their name and
   * a label that contains a message that updates when the user enters their name.
   * 
   * @see com.ibm.mq.explorer.ui.extensions.PropertyPage#init()
   */
  public void init() {

    /* Layout information */
    GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 2;
    gridLayout.makeColumnsEqualWidth = false;
    gridLayout.verticalSpacing = 10;
    this.setLayout(gridLayout);

    /* The "Enter your name" Label */
    Label label = new Label(this, SWT.LEFT);
    label.setText("Enter your name: "); //$NON-NLS-1$
    GridData gridData = new GridData();
    gridData.horizontalSpan = 1;
    label.setLayoutData(gridData);

    /* The input name text box */
    nameText = new Text(this, SWT.BORDER);
    gridData = new GridData(GridData.FILL_HORIZONTAL);
    gridData.horizontalSpan = 1;
    nameText.setLayoutData(gridData);

    /* The label that displays your name */
    messageLabel = new Label(this, SWT.LEFT);
    gridData = new GridData(GridData.FILL_HORIZONTAL);
    gridData.horizontalSpan = 2;
    messageLabel.setLayoutData(gridData);
    messageLabel.setText("Hello "); //$NON-NLS-1$

    layout();

  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.PropertyPage#isAnyControlEnabled()
   */
  public boolean isAnyControlEnabled() {
    System.out
        .println("com.ibm.mq.explorer.sample.simple.SimplePropertyPage:isAnyControlEnabled() called"); //$NON-NLS-1$ 
    return true;
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.PropertyPage#getBusyDialogText()
   */
  public String getBusyDialogText() {
    return "Applying the changes from the SimplePropertyPage"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.PropertyPage#isChanged()
   */
  public boolean isChanged() {
    boolean changed = false;
    if (!(currentName.equals(nameText.getText()))) {
      changed = true;
    }
    return changed;
  }

}
