/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72," 
 *   years="2005,2012" 
 *   crc="2280138197" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72, 
 *    
 *   (C) Copyright IBM Corp. 2005, 2012 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.ibm.mq.explorer.ui.Common;

/**
 * The main plugin class, this class is used by eclipse as a central control point
 */
public class SimplePlugin extends AbstractUIPlugin {

  /** SCSS id - expanded when file is extracted from CMVC */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimplePlugin.java"; //$NON-NLS-1$

  /** Copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** The shared instance. */
  private static SimplePlugin plugin;

  /** Resource bundle. */
  private ResourceBundle resourceBundle;

  /** Plug-in ID */
  public static final String PLUGIN_ID = "com.ibm.mq.explorer.sample.simple"; //$NON-NLS-1$

  /**
   * The constructor.
   */
  public SimplePlugin() {
    super();
    plugin = this;
    try {
      resourceBundle = ResourceBundle
          .getBundle("com.ibm.mq.explorer.sample.simple.SimplePluginResources"); //$NON-NLS-1$
    }
    catch (MissingResourceException x) {
      resourceBundle = null;
    }
  }

  /**
   * Returns the shared instance.
   * 
   * @return shared instance
   */
  public static SimplePlugin getDefault() {
    return plugin;
  }

  /**
   * Returns the string from the plugin's resource bundle, or 'key' if not found.
   * 
   * @param key to get from resource
   * @return retrieve resource text
   */
  public static String getResourceString(String key) {
    ResourceBundle bundle = SimplePlugin.getDefault().getResourceBundle();
    try {
      return bundle.getString(key);
    }
    catch (MissingResourceException e) {
      return key;
    }
  }

  /**
   * Returns the plugin's resource bundle,
   * 
   * @return resource bundle
   */
  public ResourceBundle getResourceBundle() {
    return resourceBundle;
  }
}
