/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="2061638757" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;

/**
 * This is a sipmle MQ Ext object which can then be associated with the tree node when it is created
 */
public class SimpleObject extends MQExtObject {

  /** SCCS id - expanded when file is extracted from CMVC */
  @SuppressWarnings("hiding")
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimpleObject.java"; //$NON-NLS-1$

  /** Copyright notice */
  @SuppressWarnings("hiding")
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /**
   * Pointer to associated TreeNode
   */
  private TreeNode treeNode = null;

  /**
   * Constructor
   */
  public SimpleObject() {
    super(null, null, "com.ibm.mq.explorer.sample.simple.SimpleObject", //$NON-NLS-1$
          "com.ibm.mq.explorer.sample.simple", //$NON-NLS-1$
          "Simple"); //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.UiObject#getId()
   */
  public String getObjectId() {
    return "com.ibm.mq.explorer.sample.simple"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return "Simple"; //$NON-NLS-1$
  }

  /**
   * Update the Image Descriptor to use for this object.
   */
  public void updateIcon() {
  // not used - a folder icon is used and does not require updating
  }

  /**
   * @return the tree node
   */
  public TreeNode getTreeNode() {
    return treeNode;
  }

  /**
   * @param node
   */
  public void setTreeNode(TreeNode node) {
    treeNode = node;
  }

}
