/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="2127180468" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotify;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;

/**
 * IExplorerNotify class for Simple
 */
public class SimpleNotify implements IExplorerNotify, IExecutableExtension {

  /** Common copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** CMVC descriptors - expanded during extraction */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimpleNotify.java"; //$NON-NLS-1$

  /**
   * Constructor
   */
  public SimpleNotify() {
    super();
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.IExplorerNotify#explorerInitialised()
   */
  public void explorerInitialised() {
    System.out.println("Simple: explorerInitialised notification received"); //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerAdded(com.ibm.mq.explorer.ui.
   * extensions.ExplorerNotifyEvent)
   */
  public void queueManagerAdded(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerAdded notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#isRemoveQueueManager(com.ibm.mq.explorer.
   * ui.extensions.ExplorerNotifyEvent)
   */
  public boolean isPreventRemoveQueueManager(ExplorerNotifyEvent event) {
    System.out.println("Simple: isPreventRemoveQueueManager notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());
    return false;
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#isRemoveQueueManager(com.ibm.mq.explorer.
   * ui.extensions.ExplorerNotifyEvent)
   */
  public boolean isPreventDeleteQueueManager(ExplorerNotifyEvent event) {
    System.out.println("Simple: isPreventDeleteQueueManager notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());
    return false;
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerRemoved(com.ibm.mq.explorer.ui
   * .extensions.ExplorerNotifyEvent)
   */
  public void queueManagerRemoved(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerRemoved notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerDeleted(com.ibm.mq.explorer.ui
   * .extensions.ExplorerNotifyEvent)
   */
  public void queueManagerDeleted(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerDeleted notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerShown(com.ibm.mq.explorer.ui.
   * extensions.ExplorerNotifyEvent)
   */
  public void queueManagerShown(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerShown notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerHidden(com.ibm.mq.explorer.ui
   * .extensions.ExplorerNotifyEvent)
   */
  public void queueManagerHidden(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerHidden notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#viewOpened(com.ibm.mq.explorer.ui.extensions
   * .ExplorerNotifyEvent)
   */
  public void viewOpened(ExplorerNotifyEvent event) {
    System.out.println("Simple: viewOpened notification received - " + event.getId()); //$NON-NLS-1$

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#viewClosed(com.ibm.mq.explorer.ui.extensions
   * .ExplorerNotifyEvent)
   */
  public void viewClosed(ExplorerNotifyEvent event) {
    System.out.println("Simple: viewClosed notification received - " + event.getId()); //$NON-NLS-1$

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#pluginEnabled(com.ibm.mq.explorer.ui.extensions
   * .ExplorerNotifyEvent)
   */
  public void pluginEnabled(ExplorerNotifyEvent event) {
    System.out.println("Simple: pluginEnabled notification received - " + event.getId()); //$NON-NLS-1$

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#pluginDisabled(com.ibm.mq.explorer.ui.extensions
   * .ExplorerNotifyEvent)
   */
  public void pluginDisabled(ExplorerNotifyEvent event) {
  //System.out.println("Simple: pluginDisabled notification received - " + event.getId()); //$NON-NLS-1$

  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.IExplorerNotify#explorerClosing()
   */
  public void explorerClosing() {
    System.out.println("Simple: explorerClosing notification received"); //$NON-NLS-1$

  }

  /*
   * (non-Javadoc)
   * @see
   * org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime
   * .IConfigurationElement, java.lang.String, java.lang.Object)
   */
  public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
  // not used
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#isPreventStopQueueManager(com.ibm.mq.explorer
   * .ui.extensions.ExplorerNotifyEvent)
   */
  public boolean isPreventStopQueueManager(ExplorerNotifyEvent event) {
    System.out.println("Simple: isPreventStopQueueManager notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());
    return false;
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerStopped(com.ibm.mq.explorer.ui
   * .extensions.ExplorerNotifyEvent)
   */
  public void queueManagerStopped(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerStopped notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#queueManagerStarted(com.ibm.mq.explorer.ui
   * .extensions.ExplorerNotifyEvent)
   */
  public void queueManagerStarted(ExplorerNotifyEvent event) {
    System.out.println("Simple: queueManagerStarted notification received - " //$NON-NLS-1$
                       + ((MQExtObject) event.getObject()).getName());

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IExplorerNotify#explorerPreferenceChanged(com.ibm.mq.explorer
   * .ui.extensions.ExplorerNotifyEvent)
   */
  public void explorerPreferenceChanged(ExplorerNotifyEvent event) {
    System.out.println("Simple: explorerPreferenceChanged notification received - id: " //$NON-NLS-1$
                       + event.getId() + ", new value: " + event.getObject().toString()); //$NON-NLS-1$

  }

}
