/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="141511454" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.IContentPageFactory;

/**
 * This is the content page factory class which is specified in the extension point and is
 * responsible for creating the content page for display in the Content View.
 */
public class SimpleContentPageFactory implements IExecutableExtension, IContentPageFactory {

  /** Common copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** CMVC descriptors - expanded during extraction */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimpleContentPageFactory.java"; //$NON-NLS-1$

  /**
   * Constructor
   */
  public SimpleContentPageFactory() {
    super();
  }

  /**
   * Return the id of the content page that this factory creates
   * 
   * @return String the id of the content page that this factory creates
   */
  public String getPageId() {
    return "com.ibm.mq.explorer.sample.simple"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.IContentPageFactory#makePage(org.eclipse.swt.widgets.Composite
   * )
   */
  public ContentPage makePage(Composite parent) {
    return new SimpleContentPage(parent, SWT.NONE);
  }

  /*
   * (non-Javadoc)
   * @see
   * org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime
   * .IConfigurationElement, java.lang.String, java.lang.Object)
   */
  public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {
  // not used
  }

}
