/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="1376948852" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.simple;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;

/**
 * Simple content page that is displayed in the Content View when the simple tree node is selected
 */
public class SimpleContentPage extends ContentPage {

  /** SCCS id - expanded when file is extracted from CMVC */
  @SuppressWarnings("hiding")
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.simple/src/com/ibm/mq/explorer/sample/simple/SimpleContentPage.java"; //$NON-NLS-1$

  /** Copyright notice */
  @SuppressWarnings("hiding")
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /**
   * @param parent
   * @param style
   */
  public SimpleContentPage(Composite parent, int style) {
    super(parent, style);
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.ContentPage#init()
   */
  public void init() {
    // create the fixed part of the content page here
    GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 1;
    this.setLayout(gridLayout);

    ContentTitleBar contentTitlebar = new ContentTitleBar(this, SWT.NONE);
    contentTitlebar.setText("Simple Content Page"); //$NON-NLS-1$
    GridData gridData = new GridData();
    contentTitlebar.setLayoutData(gridData);
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.ContentPage#getId()
   */
  public String getId() {
    return "com.ibm.mq.explorer.sample.simple"; //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * @seecom.ibm.mq.explorer.ui.extensions.ContentPage#setObject(com.ibm.mq.explorer.ui.extensions.
   * MQExtObject)
   */
  public void setObject(MQExtObject object) {
  // not used
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.ContentPage#updatePage()
   */
  public void updatePage() {
  // not used
  }

  /**
   * Refresh the page content (Refresh button pressed)
   */
  public void refresh() {
  // never called as refresh not supported
  }

  /**
   * Get whether to enable the Refresh toolbar action
   * 
   * @return true if the Refresh toolbar action is to be enabled, false otherwise
   */
  public boolean isEnableRefreshAction() {
    return false;
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.ContentPage#repaint()
   */
  public void repaint() {
  // do nothing

  }

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.ui.extensions.ContentPage#instanceDeleted(com.ibm.mq.commonservices.internal
   * .trace.Trace, java.lang.Object)
   */
  public void instanceDeleted(Object object) {
  // not used
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.ContentPage#isEnableSystemObjectsButton()
   */
  public boolean isEnableSystemObjectsAction() {
    return false;
  }

  /*
   * (non-Javadoc)
   * @see com.ibm.mq.explorer.ui.extensions.ContentPage#showSystemObjects(boolean)
   */
  public void showSystemObjects(boolean show) {
  // do nothing
  }
}
