/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="2177621439" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.tests.sample;

import java.util.ArrayList;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;

import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;

/**
 * Sample test run from our new test sub set!
 */
public class WMQTestSubSet extends WMQTest {

  /** SCCS id - expanded when file is extracted from CMVC */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.sample/src/com/ibm/mq/explorer/tests/sample/WMQTestSubSet.java"; //$NON-NLS-1$

  /** Copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.tests.WMQTest#runTest(com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine
   * , org.eclipse.core.runtime.IProgressMonitor, com.ibm.mq.explorer.ui.extensions.MQExtObject[],
   * java.lang.String)
   */
  public void runTest(
    WMQTestEngine callback,
    IProgressMonitor guimonitor,
    MQExtObject[] contextObjects,
    TreeNode treenode) {

    // Start with the default implementation. this will store a handle
    // to the test engine that will be needed when we want to submit
    // any results at the end of the test
    super.runTest(callback, guimonitor, contextObjects, treenode);

    // prepare space to store test results
    ArrayList testresults = new ArrayList();

    // initialise the progress bar part of the GUI used to show progress (2 stages)
    guimonitor.beginTask(getTestName(), 2);

    for (int k = 0; k < 2; k++) {
      try {
        // Sleep for a bit so it looks like we are doing some work
        Thread.sleep(4000);
      }
      catch (InterruptedException e) {
        // empty
      }

      // increment GUI progress bar used to show progress, completed 1 sleep
      guimonitor.worked(1);
    }

    // Create a new test result and add it to our array list of results
    testresults.add(new WMQTestResult(IMarker.SEVERITY_INFO,
                                      "SAMPLE: Our simple own subset test worked!", //$NON-NLS-1$
                                      "Object name", getTestSubCategory())); //$NON-NLS-1$

    // package up results and return - test complete.
    testComplete((WMQTestResult[]) testresults.toArray(new WMQTestResult[testresults.size()]));
  }

}
