/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="3240921911" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.tests.sample;

import java.util.ArrayList;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;

import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;

/**
 * List all the context objects provided to standard out
 */
public class WMQTestListContextObjects extends WMQTest {

  /** SCCS id - expanded when file is extracted from CMVC */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.sample/src/com/ibm/mq/explorer/tests/sample/WMQTestListContextObjects.java"; //$NON-NLS-1$

  /** Copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /*
   * (non-Javadoc)
   * @see
   * com.ibm.mq.explorer.tests.WMQTest#runTest(com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine
   * , org.eclipse.core.runtime.IProgressMonitor, com.ibm.mq.explorer.ui.extensions.MQExtObject[],
   * java.lang.String)
   */
  public void runTest(
    WMQTestEngine callback,
    IProgressMonitor guimonitor,
    MQExtObject[] contextObjects,
    TreeNode treenode) {

    super.runTest(callback, guimonitor, contextObjects, treenode);

    // prepare space to store test results
    ArrayList testresults = new ArrayList();

    // Loop through all supplied MQExtObjects and output them to the console
    System.out.println("Objects supplied to this test:"); //$NON-NLS-1$
    for (int k = 0; k < contextObjects.length; k++) {
      if (contextObjects[k] != null) {
        System.out.println(contextObjects[k].getName());
      }
    }

    // Output the tree node id to the console
    System.out.println("tree node id supplied to this test: " + treenode); //$NON-NLS-1$

    // Add a test result
    testresults.add(new WMQTestResult(IMarker.SEVERITY_WARNING,
                                      "SAMPLE: Listing context completed", //$NON-NLS-1$
                                      "Object name", getTestSubCategory())); //$NON-NLS-1$

    // package up results and return - test complete.
    testComplete((WMQTestResult[]) testresults.toArray(new WMQTestResult[testresults.size()]));
  }

}
