/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="2453015074" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.menus;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.ibm.mq.explorer.ui.Common;

/**
 * The main plugin class to be used in the desktop.
 */
public class MenusPlugin extends AbstractUIPlugin {

  /** SCSS id - expanded when file is extracted from CMVC */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.menus/src/com/ibm/mq/explorer/sample/menus/MenusPlugin.java"; //$NON-NLS-1$

  /** Copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** The shared instance */
  private static MenusPlugin plugin;
  /** Resource bundle */
  private ResourceBundle resourceBundle;

  /**
   * The constructor.
   */
  public MenusPlugin() {
    super();
    plugin = this;
    try {
      resourceBundle = ResourceBundle
          .getBundle("com.ibm.mq.explorer.sample.menus.MenusPluginResources"); //$NON-NLS-1$
    }
    catch (MissingResourceException x) {
      resourceBundle = null;
    }
  }

  /**
   * This method is called upon plug-in activation
   * 
   * @param context
   * @throws Exception
   */
  public void start(BundleContext context) throws Exception {
    super.start(context);
  }

  /**
   * This method is called when the plug-in is stopped
   * 
   * @param context
   * @throws Exception
   */
  public void stop(BundleContext context) throws Exception {
    super.stop(context);
  }

  /**
   * Returns the shared instance.
   * 
   * @return MenusPlugin the shared resource
   */
  public static MenusPlugin getDefault() {
    return plugin;
  }

  /**
   * Returns the string from the plugin's resource bundle, or 'key' if not found.
   * 
   * @param key the hey for the string resource
   * @return String the string from the plugin's resource bundle
   */
  public static String getResourceString(String key) {
    ResourceBundle bundle = MenusPlugin.getDefault().getResourceBundle();
    try {
      return (bundle != null) ? bundle.getString(key) : key;
    }
    catch (MissingResourceException e) {
      return key;
    }
  }

  /**
   * Returns the plugin's resource bundle
   * 
   * @return ResourceBundle the plugin's resource bundle
   */
  public ResourceBundle getResourceBundle() {
    return resourceBundle;
  }

  /**
   * Return the current Shell
   * 
   * @return Shell the current Shell
   */
  public static Shell getShell() {
    IWorkbench wkbench = getDefault().getWorkbench();
    IWorkbenchWindow win = wkbench.getActiveWorkbenchWindow();
    if (win == null) {
      win = wkbench.getWorkbenchWindows()[0];
    }
    return win.getShell();
  }
}
