/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72" 
 *   years="2005,2014" 
 *   crc="2011728201" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72 
 *    
 *   (C) Copyright IBM Corp. 2005, 2014 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.sample.menus;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IActionDelegate;

import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.MQSetExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.extensions.TreeNodeId;

/**
 * IActionDelegate class for Menus menu actions
 */
public class MenuActions implements IActionDelegate {

  /** Common copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** CMVC descriptors - expanded during extraction */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.sample.menus/src/com/ibm/mq/explorer/sample/menus/MenuActions.java"; //$NON-NLS-1$

  /** The currently selected TreeNode */
  private TreeNode selectedTreeNode = null;

  /** The currently selected MQExtObject */
  private MQExtObject selectedMQExtObject = null;

  /**
   * Constructor
   */
  public MenuActions() {
    super();
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
   */
  public void run(IAction action) {
    String id = action.getId();
    if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.AnyTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the TreeNode '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.QueuesTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queues TreeNode '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.QueueManagerTreeNode") == 0) { //$NON-NLS-1$
      String msg = "Sample action on the Queue Manager TreeNode '" + selectedTreeNode.toString() + "'"; //$NON-NLS-1$ //$NON-NLS-2$
      // Get the connection details for the selected queue manager
      String details = ""; //$NON-NLS-1$
      if ((selectedMQExtObject != null) && (selectedMQExtObject instanceof MQQmgrExtObject)) {
        details = getQueueManagerConnectionDetails((MQQmgrExtObject) selectedMQExtObject);
      }
      displayMessageBox(msg + "\n\n" + details); //$NON-NLS-1$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.StartedQueueManagerTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queue Manager TreeNode for started Queue Manager '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.ConnectedQueueManagerTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queue Manager TreeNode for connected Queue Manager '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.NamedQueueManagerTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queue Manager TreeNode for a Queue Manager name starting with 'QM' - '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id
        .compareTo("com.ibm.mq.explorer.sample.menus.action.WindowsPlatformQueueManagerTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queue Manager TreeNode for a Queue Manager on the Windows platform"); //$NON-NLS-1$
    }
    else if (id
        .compareTo("com.ibm.mq.explorer.sample.menus.action.CmdLevelGreaterThan520ProcDefTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Process Definitions TreeNode for a Queue Manager with the command level greater than 520"); //$NON-NLS-1$
    }
    else if (id
        .compareTo("com.ibm.mq.explorer.sample.menus.action.CmdLevelLessThan600QueueManagerMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queue Manager TreeNode for a Queue Manager with a command level less than 600"); //$NON-NLS-1$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.AnyMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the MQExtObject '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.QueueManagerMQExtObject") == 0) { //$NON-NLS-1$
      String msg = "Sample action on the Queue Manager '" + selectedMQExtObject.toString() + "'"; //$NON-NLS-1$ //$NON-NLS-2$
      // Get the connection details for the selected queue manager
      String details = ""; //$NON-NLS-1$
      if ((selectedMQExtObject != null) && (selectedMQExtObject instanceof MQQmgrExtObject)) {
        details = getQueueManagerConnectionDetails((MQQmgrExtObject) selectedMQExtObject);
      }
      displayMessageBox(msg + "\n\n" + details); //$NON-NLS-1$
    }
    else if (id
        .compareTo("com.ibm.mq.explorer.sample.menus.action.zSeriesPlatformQueueManagerMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on a Queue Manager on the zSeries Platform"); //$NON-NLS-1$
    }
    else if (id
        .compareTo("com.ibm.mq.explorer.sample.menus.action.CmdLevelEqualTo600QueueManagerMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on a Queue Manager with a command level equal to 600"); //$NON-NLS-1$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.QueueMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Queue '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.NamedQueueMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the queue with name equal to SYSTEM.DEFAULT.LOCAL.QUEUE' - '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.LocalQueueMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the local Queue '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.SystemQueueMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the system Queue '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.TransmissionQueueMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the transmission Queue '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.ChannelMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Channel '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.SenderChannelMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the sender Channel '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.InactiveChannelMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Channel with overall status inactive '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.ServiceMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Service '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.StoppedServiceMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the stopped Service '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.ListenerMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Listener '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.TCPListenerMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the TCP Listener '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.StoppedListenerMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the stopped Listener '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.GroupQSGMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the MQExtObject with QSG disposition Group '" + selectedMQExtObject.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id
        .compareTo("com.ibm.mq.explorer.sample.menus.action.CmdLevelGreaterThan520NamelistMQExtObject") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Namelist '" + selectedMQExtObject.toString() + "' on a Queue Manager with command level greater than 520"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.SetTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Set TreeNode '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.ManualSetTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Manual Set TreeNode '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.AutomaticSetTreeNode") == 0) { //$NON-NLS-1$
      displayMessageBox("Sample action on the Automatic Set TreeNode '" + selectedTreeNode.toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
    }
    else if (id.compareTo("com.ibm.mq.explorer.sample.menus.action.AllMembersOfAnySet") == 0) { //$NON-NLS-1$
      setActions();
    }
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
   * org.eclipse.jface.viewers.ISelection)
   */
  public void selectionChanged(IAction action, ISelection selection) {
    if (selection != null) {
      if (selection instanceof IStructuredSelection) {
        IStructuredSelection structuredSelection = (IStructuredSelection) selection;
        // Get the selected object
        Object obj = structuredSelection.getFirstElement();
        if (obj != null) {
          // If the selected object is a TreeNode then remember it
          if (obj instanceof TreeNode) {
            selectedTreeNode = (TreeNode) obj;
            // If the selected object is a Queue Manager TreeNode,
            // then remember the Queue Manager MQExtObject associated with it
            if (selectedTreeNode.getId().startsWith(TreeNodeId.NODEID_PREFIX_QMGR)) {
              Object treeNodeObj = selectedTreeNode.getObject();
              if (treeNodeObj instanceof MQExtObject) {
                selectedMQExtObject = (MQExtObject) treeNodeObj;
              }
            }
          }
          // If the selected object is an MQExtObject then remember it
          else if (obj instanceof MQExtObject) {
            selectedMQExtObject = (MQExtObject) obj;
            if (selectedMQExtObject instanceof MQQmgrExtObject) {
              // Note we don't actually use the MQQmgrExtObject but it is left here as an example
              @SuppressWarnings("unused")
              MQQmgrExtObject mqQmgrExtObject = (MQQmgrExtObject) selectedMQExtObject;
            }
          }
        }
      }
    }
  }

  /**
   * Display a message box with an OK button
   * 
   * @param msg the text to display in the message box
   */
  private void displayMessageBox(String msg) {
    MessageBox msgBox = new MessageBox(MenusPlugin.getShell(), SWT.OK | SWT.ICON_INFORMATION);
    msgBox.setText("Menus"); //$NON-NLS-1$
    msgBox.setMessage(msg);
    msgBox.open();
  }

  /**
   * Return a string containing details of how Explorer is connected to the specfied queue manager
   * 
   * @param mqQmgrExtObject the queue manager to return the connection details for
   * @return String Explorer connection details for the specified queue manager
   */
  private String getQueueManagerConnectionDetails(MQQmgrExtObject mqQmgrExtObject) {
    String details = "connection details: "; //$NON-NLS-1$

    int connType = mqQmgrExtObject.getConnectionType();
    switch (connType) {
      case MQQmgrExtObject.CONNECTION_TYPE_SERVER :
        details += "server connection"; //$NON-NLS-1$
        break;
      case MQQmgrExtObject.CONNECTION_TYPE_CLIENT :
        String hostName = mqQmgrExtObject.getHostName();
        int portAddr = mqQmgrExtObject.getPortAddress();
        String channelName = mqQmgrExtObject.getChannelName();
        if ((hostName != null) && (portAddr != -1) && (channelName != null)) {
          details += "client connection using port address '" + portAddr + "' on host name='" + hostName + "' using channel name='" + channelName + "'"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
        }
        break;
      case MQQmgrExtObject.CONNECTION_TYPE_CHANNEL_DEF_TABLE :
        String channelDefTable = mqQmgrExtObject.getChannelDefintionTable();
        if (channelDefTable != null) {
          details += "using channel definition table '" + channelDefTable + "'"; //$NON-NLS-1$//$NON-NLS-2$
        }
        break;
      case MQQmgrExtObject.CONNECTION_TYPE_VIA_CMD_Q :
        String viaQueueManagerName = mqQmgrExtObject.getViaQueueManagerName();
        String viaCommandQName = mqQmgrExtObject.getViaCommandQueueName();
        if ((viaQueueManagerName != null) && (viaCommandQName != null)) {
          details += "via command queue '" + viaCommandQName + "' on queue manager '" + viaQueueManagerName + "'"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
        }
        break;
      case MQQmgrExtObject.CONNECTION_TYPE_NOT_AVAILABLE :
        details += "not available"; //$NON-NLS-1$
        break;
    }
    return details;
  }

  /**
   * Perform an action on all members of the selected Set
   */
  private void setActions() {
    // Get the MQSetExtObject associated with the selected TreeNode
    Object object = selectedTreeNode.getObject();
    if (object instanceof MQSetExtObject) {
      MQSetExtObject mqSetExtObject = (MQSetExtObject) object;
      // Get the MQExtObjects in the Set
      MQExtObject[] mqExtObjects = mqSetExtObject.getObjectsInSet();
      // Perform an action on all members of the Set
      for (int i = 0; i < mqExtObjects.length; i++) {
        displayMessageBox("Sample action on the Set member '" + mqExtObjects[i].toString() + "'"); //$NON-NLS-1$ //$NON-NLS-2$
      }
    }
  }
}
