/*
 *   <copyright 
 *   notice="lm-source-program" 
 *   pids="5724-H72," 
 *   years="2005,2012" 
 *   crc="1334807108" > 
 *   Licensed Materials - Property of IBM  
 *    
 *   5724-H72, 
 *    
 *   (C) Copyright IBM Corp. 2005, 2012 All Rights Reserved.  
 *    
 *   US Government Users Restricted Rights - Use, duplication or  
 *   disclosure restricted by GSA ADP Schedule Contract with  
 *   IBM Corp.  
 *   </copyright> 
 */
package com.ibm.mq.explorer.jmsadmin.sample.menus;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.ibm.mq.explorer.ui.Common;

/**
 * Plugin demonstrating how to extend the JMS Admin plugin
 */
public class MenusPlugin extends AbstractUIPlugin {

  /** CMVC descriptors - expanded during extraction */
  public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin.sample.menus/src/com/ibm/mq/explorer/jmsadmin/sample/menus/MenusPlugin.java"; //$NON-NLS-1$
  /** Common copyright notice */
  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;

  /** The shared instance */
  private static MenusPlugin plugin;
  /** Resource bundle */
  private ResourceBundle resourceBundle;

  /**
   * The constructor.
   */
  public MenusPlugin() {
    super();
    plugin = this;
    try {
      resourceBundle = ResourceBundle
          .getBundle("com.ibm.mq.explorer.jmsadmin.sample.menus.MenusPluginResources"); //$NON-NLS-1$
    }
    catch (MissingResourceException x) {
      resourceBundle = null;
    }
  }

  /**
   * This method is called upon plug-in activation
   * 
   * @param context
   * @throws Exception
   */
  public void start(BundleContext context) throws Exception {
    super.start(context);
  }

  /**
   * This method is called when the plug-in is stopped
   * 
   * @param context
   * @throws Exception
   */
  public void stop(BundleContext context) throws Exception {
    super.stop(context);
  }

  /**
   * Returns the shared instance.
   * 
   * @return the shared instance of this plugin
   */
  public static MenusPlugin getDefault() {
    return plugin;
  }

  /**
   * Returns the string from the plugin's resource bundle, or 'key' if not found.
   * 
   * @param key
   * @return the required string
   */
  public static String getResourceString(String key) {
    ResourceBundle bundle = MenusPlugin.getDefault().getResourceBundle();
    try {
      return (bundle != null) ? bundle.getString(key) : key;
    }
    catch (MissingResourceException e) {
      return key;
    }
  }

  /**
   * Returns the plugin's resource bundle,
   * 
   * @return the resource bundle
   */
  public ResourceBundle getResourceBundle() {
    return resourceBundle;
  }
}
