/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.ui;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TestConfigurationMismatchDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/ui/TestConfigurationMismatchDialog.java";
    private static final int NUM_COLS = 1;
    public static final int MINSIZE_X = 350;
    private Point preferredSize = null;
    private String msgText = null;
    private Button checkPersist = null;
    public static final int RUN_ON_ORIGINAL_OBJECTS = 0;
    public static final int RUN_ON_SELECTED_OBJECTS = 1;
    public static final int RUN_ON_BOTH = 2;
    private int selectedAction = 0;
    private boolean persistChanges = false;

    public TestConfigurationMismatchDialog(Trace t, Shell parent, ArrayList<MQExtObject> objectList) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        String objectString = objectList.toString();
        objectString = objectString.substring(1, objectString.length() - 1);
        this.msgText = objectList.size() == 1 ? Messages.getString(t, "TestConfigurationMismatchDialog.objectMismatchSingle", new String[]{objectString}) : Messages.getString(t, "TestConfigurationMismatchDialog.objectMismatch", new String[]{objectString});
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Trace t = Trace.getDefault();
        Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
        String title = msgFile.getMessage(t, "UI.GENERAL.MQ");
        newShell.setText(title);
        newShell.setImage(Icons.get((String)Icons.iconkeyExplorerSmall));
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.tests.infopop.TestObjectMismatch");
    }

    public Control createDialogArea(Composite parent) {
        GridData gridData;
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        parent.setLayout((Layout)gridLayout);
        if (this.msgText != null) {
            Composite compositeMsgBar = new Composite(parent, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.makeColumnsEqualWidth = false;
            compositeMsgBar.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            compositeMsgBar.setLayoutData((Object)gridData);
            Label labelMsgBarIcon = new Label(compositeMsgBar, 0);
            labelMsgBarIcon.setImage(UiPlugin.getDisplay().getSystemImage(4));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            labelMsgBarIcon.setLayoutData((Object)gridData);
            Text txtMsgBarMessage = new Text(compositeMsgBar, 64);
            txtMsgBarMessage.setText(this.msgText);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            txtMsgBarMessage.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)txtMsgBarMessage, (boolean)true);
            UiUtils.createBlankLine((Composite)parent, (int)1);
        }
        Group group = new Group(parent, 0);
        group.setText(Messages.getString(t, "TestConfigurationMismatchDialog.optionsGroupTitle"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        Button radioOriginalObjects = new Button((Composite)group, 16);
        radioOriginalObjects.setText(Messages.getString(t, "TestConfigurationMismatchDialog.runOnOriginal"));
        radioOriginalObjects.setSelection(this.selectedAction == 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        radioOriginalObjects.setLayoutData((Object)gridData);
        radioOriginalObjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestConfigurationMismatchDialog.this.selectedAction = 0;
                TestConfigurationMismatchDialog.this.checkPersist.setEnabled(false);
            }
        });
        Button radioSelectedObjects = new Button((Composite)group, 16);
        radioSelectedObjects.setText(Messages.getString(t, "TestConfigurationMismatchDialog.runOnSelected"));
        radioSelectedObjects.setSelection(this.selectedAction == 1);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        radioSelectedObjects.setLayoutData((Object)gridData);
        radioSelectedObjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestConfigurationMismatchDialog.this.selectedAction = 1;
                TestConfigurationMismatchDialog.this.checkPersist.setEnabled(true);
            }
        });
        Button radioBoth = new Button((Composite)group, 16);
        radioBoth.setText(Messages.getString(t, "TestConfigurationMismatchDialog.runOnBoth"));
        radioBoth.setSelection(this.selectedAction == 2);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        radioBoth.setLayoutData((Object)gridData);
        radioBoth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestConfigurationMismatchDialog.this.selectedAction = 2;
                TestConfigurationMismatchDialog.this.checkPersist.setEnabled(true);
            }
        });
        UiUtils.createBlankLine((Composite)parent, (int)1);
        Group groupPersist = new Group(parent, 0);
        groupPersist.setText(Messages.getString(t, "TestConfigurationMismatchDialog.persistGroupTitle"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        groupPersist.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        groupPersist.setLayout((Layout)gridLayout);
        this.checkPersist = new Button((Composite)groupPersist, 32);
        this.checkPersist.setText(Messages.getString(t, "TestConfigurationMismatchDialog.persistChanges"));
        this.checkPersist.setSelection(false);
        this.checkPersist.setEnabled(!radioOriginalObjects.getSelection());
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.checkPersist.setLayoutData((Object)gridData);
        this.checkPersist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestConfigurationMismatchDialog.this.persistChanges = TestConfigurationMismatchDialog.this.checkPersist.getSelection();
            }
        });
        parent.pack();
        this.preferredSize = parent.getSize();
        if (this.preferredSize.x < 350) {
            this.preferredSize.x = 350;
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setFocus();
        this.getShell().setDefaultButton(ok);
    }

    public int getSelectedAction() {
        return this.selectedAction;
    }

    public boolean isPersistChanges() {
        return this.persistChanges;
    }
}

