/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.problems;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.ClearWMQTestResultsAction;
import com.ibm.mq.explorer.tests.internal.actions.CopyAction;
import com.ibm.mq.explorer.tests.internal.actions.ExportResultsAction;
import com.ibm.mq.explorer.tests.internal.actions.FilterState;
import com.ibm.mq.explorer.tests.internal.actions.FilterWMQTestCompletionAction;
import com.ibm.mq.explorer.tests.internal.actions.FilterWMQTestResultsAction;
import com.ibm.mq.explorer.tests.internal.actions.SelectAllAction;
import com.ibm.mq.explorer.tests.internal.problems.MQMarkerOpenAction;
import com.ibm.mq.explorer.tests.internal.problems.MQMarkerRunTestAction;
import com.ibm.mq.explorer.tests.internal.problems.ProblemViewLabelProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.ToolbarAccessibility;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TestsProblemView
extends ViewPart {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/problems/TestsProblemView.java";
    private static final String COLUMN_WIDTH_KEY = "column_widths";
    private static final int NUMBER_OF_COLUMNS = 4;
    public static final int COLUMN_INDEX_SEVERITY = 0;
    public static final int COLUMN_INDEX_DESCRIPTION = 1;
    public static final int COLUMN_INDEX_OBJECT = 2;
    public static final int COLUMN_INDEX_CATEGORY = 3;
    private int[] defaultColumnWidths = new int[]{21, 350, 100, 150};
    private MQMarkerOpenAction mqAction;
    private MQMarkerRunTestAction runtestAction;
    private ClearWMQTestResultsAction clearAction;
    private FilterWMQTestResultsAction filterAction;
    private FilterWMQTestCompletionAction completeAction;
    private Action copyAction;
    private Action selectAllAction;
    private ExportResultsAction exportAction;
    private Clipboard fClipboard;
    private TableViewer viewer;
    private ArrayList<IMarker> problemMarkers;
    private Label markerTotals;
    private int error;
    private int warning;
    private int info;
    private int total;

    protected void createActions() {
        Trace t = Trace.getDefault();
        this.mqAction = new MQMarkerOpenAction();
        this.mqAction.setText(Messages.getString(t, "MQMarkerDisplayInfoResolution.furtherInfo"));
        UiPlugin.getHelpSystem().setHelp((IAction)this.mqAction, "com.ibm.mq.explorer.tests.infopop.ProblemViewAction_getMoreInfo");
        this.runtestAction = new MQMarkerRunTestAction();
        this.runtestAction.setText(Messages.getString(t, "MQMarkerRunTestAction.runAgain"));
        UiPlugin.getHelpSystem().setHelp((IAction)this.runtestAction, "com.ibm.mq.explorer.tests.infopop.ProblemViewAction_runAgain");
        this.clearAction = new ClearWMQTestResultsAction(t, this);
        this.clearAction.setImageDescriptor(Icons.getDescriptor(t, Icons.DELETE_ALL));
        UiPlugin.getHelpSystem().setHelp((IAction)this.clearAction, "com.ibm.mq.explorer.tests.infopop.ProblemViewAction_clearAll");
        this.filterAction = new FilterWMQTestResultsAction(t, this);
        this.filterAction.setImageDescriptor(Icons.getDescriptor(t, Icons.FILTER));
        UiPlugin.getHelpSystem().setHelp((IAction)this.filterAction, "com.ibm.mq.explorer.tests.infopop.ProblemViewAction_filter");
        this.exportAction = new ExportResultsAction(t, this, this.viewer);
        this.exportAction.setImageDescriptor(Icons.getDescriptor(t, Icons.EXPORT));
        UiPlugin.getHelpSystem().setHelp((IAction)this.exportAction, "com.ibm.mq.explorer.tests.infopop.ProblemViewAction_export");
        this.completeAction = new FilterWMQTestCompletionAction(t, this.filterAction.getFilterState());
        this.copyAction = new CopyAction(this.viewer, this.fClipboard);
        this.selectAllAction = new SelectAllAction(this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (manager != null) {
            manager.add((IAction)this.copyAction);
            manager.add((IAction)this.selectAllAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.clearAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.mqAction);
            manager.add((IAction)this.runtestAction);
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
        }
    }

    public void init(IViewSite viewSite, IMemento memento) throws PartInitException {
        String widths;
        super.init(viewSite, memento);
        if (memento != null && (widths = memento.getString(COLUMN_WIDTH_KEY)) != null) {
            StringTokenizer st = new StringTokenizer(widths, ":");
            int i = 0;
            i = 1;
            while (i < 4) {
                block5: {
                    try {
                        String val = st.nextToken();
                        this.defaultColumnWidths[i] = Integer.parseInt(val);
                        if (this.viewer == null) break block5;
                        this.viewer.getTable().getColumns()[i].setWidth(this.defaultColumnWidths[i]);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        break;
                    }
                }
                ++i;
            }
        }
        if (this.problemMarkers == null) {
            this.problemMarkers = new ArrayList();
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (!UiPlugin.isShutdownInProgress()) {
                    TestsProblemView.this.getMarkerList(Trace.getDefault());
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        memento.putString(COLUMN_WIDTH_KEY, this.getColumnsWidths());
        super.saveState(memento);
    }

    private String getColumnsWidths() {
        String widths = "";
        TableColumn[] tcs = this.viewer.getTable().getColumns();
        if (tcs.length >= 4) {
            int i = 1;
            while (i < 4) {
                TableColumn t = tcs[i];
                widths = String.valueOf(widths) + t.getWidth();
                if (i < 3) {
                    widths = String.valueOf(widths) + ":";
                }
                ++i;
            }
        }
        return widths;
    }

    public void createPartControl(Composite parent) {
        final Trace t = Trace.getDefault();
        this.getMarkerList(t);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(4, false);
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gd);
        this.markerTotals = new Label(comp, 0);
        this.markerTotals.setText("");
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 4;
        this.markerTotals.setLayoutData((Object)gd);
        this.viewer = new TableViewer(comp, 67586);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 4;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setUseHashlookup(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.fClipboard = new Clipboard(this.viewer.getControl().getDisplay());
        final TableColumn columnSeverity = new TableColumn(this.viewer.getTable(), 16384);
        columnSeverity.setText("");
        columnSeverity.setWidth(this.defaultColumnWidths[0]);
        columnSeverity.setResizable(false);
        final TableColumn columnDescription = new TableColumn(this.viewer.getTable(), 16384);
        columnDescription.setText(Messages.getString(t, "ProblemView.description"));
        columnDescription.setWidth(this.defaultColumnWidths[1]);
        final TableColumn columnObject = new TableColumn(this.viewer.getTable(), 16384);
        columnObject.setText(Messages.getString(t, "ProblemView.object"));
        columnObject.setWidth(this.defaultColumnWidths[2]);
        final TableColumn columnCategory = new TableColumn(this.viewer.getTable(), 16384);
        columnCategory.setText(Messages.getString(t, "ProblemView.category"));
        columnCategory.setWidth(this.defaultColumnWidths[3]);
        Listener sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn col = (TableColumn)event.widget;
                if (col == TestsProblemView.this.viewer.getTable().getSortColumn()) {
                    if (TestsProblemView.this.viewer.getTable().getSortDirection() == 128) {
                        TestsProblemView.this.viewer.getTable().setSortDirection(1024);
                    } else {
                        TestsProblemView.this.viewer.getTable().setSortDirection(128);
                    }
                } else {
                    TestsProblemView.this.viewer.getTable().setSortColumn(col);
                    TestsProblemView.this.viewer.getTable().setSortDirection(1024);
                }
                TestsProblemView.this.viewer.refresh();
            }
        };
        columnSeverity.addListener(13, sortListener);
        columnDescription.addListener(13, sortListener);
        columnObject.addListener(13, sortListener);
        columnCategory.addListener(13, sortListener);
        this.viewer.getTable().setSortColumn(columnSeverity);
        this.viewer.getTable().setSortDirection(1024);
        if (this.problemMarkers == null) {
            this.problemMarkers = new ArrayList();
        }
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                TestsProblemView.this.getMarkerList(Trace.getDefault());
                return TestsProblemView.this.problemMarkers.toArray(new Object[TestsProblemView.this.problemMarkers.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
                if (!TestsProblemView.this.markerTotals.isDisposed()) {
                    UiPlugin.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TestsProblemView.this.markerTotals.isDisposed()) {
                                TestsProblemView.this.markerTotals.setText(TestsProblemView.this.getInfoString(Trace.getDefault()));
                            }
                        }
                    });
                }
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProblemViewLabelProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer theViewer, Object e1, Object e2) {
                if (e1 instanceof IMarker && e2 instanceof IMarker) {
                    IMarker m1 = (IMarker)e1;
                    IMarker m2 = (IMarker)e2;
                    String comp1 = null;
                    String comp2 = null;
                    TableColumn col = TestsProblemView.this.viewer.getTable().getSortColumn();
                    try {
                        if (col == columnSeverity) {
                            comp1 = ((Integer)m1.getAttribute("severity")).toString();
                            comp2 = ((Integer)m2.getAttribute("severity")).toString();
                        } else if (col == columnDescription) {
                            comp1 = (String)m1.getAttribute("message");
                            comp2 = (String)m2.getAttribute("message");
                        } else if (col == columnObject) {
                            comp1 = (String)m1.getAttribute("qmgrname");
                            comp2 = (String)m2.getAttribute("qmgrname");
                        } else if (col == columnCategory) {
                            comp1 = (String)m1.getAttribute("formattedcategory");
                            comp2 = (String)m2.getAttribute("formattedcategory");
                        } else if (Trace.isTracing) {
                            t.data(66, "TestsProblemView.createPartControl", 900, "sorted tried to process invalid column");
                        }
                    }
                    catch (CoreException e) {
                        t.FFST(66, "TestsProblemView.createPartControl", 10, 50043, e.getMessage());
                    }
                    if (comp1 != null && comp2 != null) {
                        int ret = TestsProblemView.this.viewer.getTable().getSortDirection() == 128 ? this.compare((Viewer)TestsProblemView.this.viewer, comp1, comp2) : this.compare((Viewer)TestsProblemView.this.viewer, comp2, comp1);
                        return ret;
                    }
                }
                return super.compare(theViewer, e1, e2);
            }
        });
        this.viewer.setInput(this.problemMarkers);
        this.viewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection iSel = TestsProblemView.this.viewer.getSelection();
                if (iSel != null && iSel instanceof IStructuredSelection) {
                    IStructuredSelection iStructSel = (IStructuredSelection)iSel;
                    TestsProblemView.this.mqAction.selectionChanged(iStructSel);
                    TestsProblemView.this.runtestAction.selectionChanged(iStructSel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ISelection iSel = TestsProblemView.this.viewer.getSelection();
                if (iSel != null && iSel instanceof IStructuredSelection) {
                    IStructuredSelection iStructSel = (IStructuredSelection)iSel;
                    TestsProblemView.this.runtestAction.selectionChanged(iStructSel);
                    TestsProblemView.this.mqAction.selectionChanged(iStructSel);
                    TestsProblemView.this.mqAction.run();
                }
            }
        });
        UiPlugin.getHelpSystem().setHelp((Control)comp, "com.ibm.mq.explorer.tests.infopop.View_resultsView");
        this.createActions();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        IMenuManager menuManager = bars.getMenuManager();
        manager.add((IAction)this.exportAction);
        menuManager.add((IAction)this.exportAction);
        menuManager.add((IAction)this.filterAction);
        manager.add((IAction)this.filterAction);
        menuManager.add((IAction)this.clearAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.completeAction);
        manager.add((IAction)this.clearAction);
        bars.updateActionBars();
        ToolbarAccessibility.addViewToolbarAccessibility((IToolBarManager)manager);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        MenuManager mgr = new MenuManager();
        this.fillContextMenu((IMenuManager)mgr);
        Menu menu = mgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        comp.layout();
        TestsPlugin.setProblemView(this);
        this.refresh();
    }

    private void getMarkerList(Trace t) {
        try {
            IWorkspaceRoot root = TestsPlugin.getDefault().getProject().getWorkspace().getRoot();
            IMarker[] markers = root.findMarkers(null, true, 2);
            if (this.problemMarkers == null) {
                this.problemMarkers = new ArrayList();
            }
            this.problemMarkers.clear();
            this.info = 0;
            this.warning = 0;
            this.error = 0;
            this.total = 0;
            FilterState filters = this.filterAction.getFilterState();
            int k = 0;
            while (k < markers.length) {
                IMarker m = markers[k];
                if (m.getType().equals("com.ibm.mq.explorer.tests.mqmarker")) {
                    ++this.total;
                    if (this.isSelectedByFilters(t, m, filters)) {
                        this.problemMarkers.add(m);
                        switch ((Integer)m.getAttribute("severity")) {
                            case 2: {
                                ++this.error;
                                break;
                            }
                            case 1: {
                                ++this.warning;
                                break;
                            }
                            case 0: {
                                ++this.info;
                            }
                        }
                    }
                }
                ++k;
            }
        }
        catch (CoreException e) {
            t.FFST(66, "TestsProblemView.getMarkerList", 10, 50043, e.getMessage());
        }
        catch (NullPointerException nullPointerException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSelectedByFilters(Trace t, IMarker m, FilterState filters) {
        boolean keep = true;
        try {
            if (filters.isSeverityFilterEnabled()) {
                int sev = m.getAttribute("severity", -1);
                if (!filters.isErrorFilterEnabled() && sev == 2) {
                    return false;
                }
                if (!filters.isWarningFilterEnabled() && sev == 1) {
                    return false;
                }
                if (!filters.isInfoFilterEnabled() && sev == 0) {
                    return false;
                }
                if (!filters.isCompleteFilterEnabled()) {
                    Boolean isComplete = (Boolean)m.getAttribute("testcomplete");
                    if (isComplete == false) return true;
                    return false;
                }
            }
            if (filters.getNameFilter().length() > 0) {
                String name = (String)m.getAttribute("qmgrname");
                if (filters.isDoesntContain()) {
                    if (name.indexOf(filters.getNameFilter()) != -1) return false;
                    return true;
                }
                if (name.indexOf(filters.getNameFilter()) < 0) return false;
                return true;
            }
            if (filters.isCompleteFilterEnabled()) return keep;
            Boolean isComplete = (Boolean)m.getAttribute("testcomplete");
            if (isComplete == false) return true;
            return false;
        }
        catch (CoreException e) {
            t.FFST(66, "TestsProblemView.isSelectedByFilters", 10, 50043, e.getMessage());
        }
        return keep;
    }

    private String getInfoString(Trace t) {
        String ret = "";
        String[] eArray = new String[]{Integer.toString(this.error)};
        String[] wArray = new String[]{Integer.toString(this.warning)};
        String[] iArray = new String[]{Integer.toString(this.info)};
        String errText = "";
        String warnText = "";
        String infoText = "";
        errText = this.error == 0 ? Messages.getString(t, "ProblemView.summaryTextErr0", eArray) : (this.error == 1 ? Messages.getString(t, "ProblemView.summaryTextErr1", eArray) : Messages.getString(t, "ProblemView.summaryTextErr2", eArray));
        warnText = this.warning == 0 ? Messages.getString(t, "ProblemView.summaryTextWarn0", wArray) : (this.warning == 1 ? Messages.getString(t, "ProblemView.summaryTextWarn1", wArray) : Messages.getString(t, "ProblemView.summaryTextWarn2", wArray));
        infoText = this.info == 0 ? Messages.getString(t, "ProblemView.summaryTextInfo0", iArray) : (this.info == 1 ? Messages.getString(t, "ProblemView.summaryTextInfo1", iArray) : Messages.getString(t, "ProblemView.summaryTextInfo2", iArray));
        ret = Messages.getString(t, "ProblemView.summaryText", new String[]{errText, warnText, infoText});
        int totalMatched = this.error + this.warning + this.info;
        if (totalMatched < this.total) {
            ret = String.valueOf(ret) + " ";
            ret = this.total == 1 ? String.valueOf(ret) + Messages.getString(t, "ProblemView.filteredText1", new String[]{"" + totalMatched, "" + this.total}) : String.valueOf(ret) + Messages.getString(t, "ProblemView.filteredText2", new String[]{"" + totalMatched, "" + this.total});
        }
        return ret;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
    }

    public void refresh() {
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestsProblemView.this.getMarkerList(Trace.getDefault());
                TestsProblemView.this.viewer.refresh();
                TestsProblemView.this.markerTotals.setText(TestsProblemView.this.getInfoString(Trace.getDefault()));
                ISelection iSel = TestsProblemView.this.viewer.getSelection();
                if (iSel != null && iSel instanceof IStructuredSelection) {
                    IStructuredSelection iStructSel = (IStructuredSelection)iSel;
                    TestsProblemView.this.mqAction.selectionChanged(iStructSel);
                    TestsProblemView.this.runtestAction.selectionChanged(iStructSel);
                }
            }
        });
    }
}

