/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.problems;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProblemViewLabelProvider
implements ITableLabelProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/problems/ProblemViewLabelProvider.java";

    public Image getColumnImage(Object element, int columnIndex) {
        Trace t = Trace.getDefault();
        Image img = null;
        if (element instanceof IMarker) {
            IMarker m = (IMarker)element;
            try {
                if (columnIndex == 0) {
                    int sev = (Integer)m.getAttribute("severity");
                    switch (sev) {
                        case 2: {
                            img = Icons.getImage(t, Icons.ERROR);
                            break;
                        }
                        case 1: {
                            img = Icons.getImage(t, Icons.WARNING);
                            break;
                        }
                        case 0: {
                            img = Icons.getImage(t, Icons.INFO);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (CoreException e) {
                t.FFST(66, "ProblemViewLabelProvider.getColumnImage", 10, 50043, e.getMessage());
            }
        }
        return img;
    }

    public String getColumnText(Object element, int columnIndex) {
        String ret = "";
        if (element instanceof IMarker) {
            IMarker m = (IMarker)element;
            try {
                switch (columnIndex) {
                    case 0: {
                        int sev = m.getAttribute("severity", -1);
                        Trace t = Trace.getDefault();
                        if (sev == 2) {
                            return Messages.getString(t, "FilterWMQTestResultsDialog.severityError");
                        }
                        if (sev == 1) {
                            return Messages.getString(t, "FilterWMQTestResultsDialog.severityWarning");
                        }
                        if (sev == 0) {
                            return Messages.getString(t, "FilterWMQTestResultsDialog.severityInfo");
                        }
                        break;
                    }
                    case 1: {
                        ret = (String)m.getAttribute("message");
                        break;
                    }
                    case 2: {
                        ret = (String)m.getAttribute("qmgrname");
                        break;
                    }
                    case 3: {
                        ret = (String)m.getAttribute("formattedcategory");
                    }
                }
            }
            catch (CoreException e) {
                Trace.getDefault().FFST(66, "ProblemViewLabelProvider.getColumnText", 10, 50043, e.getMessage());
            }
        }
        return ret;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

