/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.problems;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.launch.ConfigurationManager;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.IMarkerResolution;

public class MQMarkerRerunTestResolution
implements IMarkerResolution {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/problems/MQMarkerRerunTestResolution.java";
    private static String labelText = null;

    public String getLabel() {
        if (labelText == null) {
            labelText = Messages.getString(Trace.getDefault(), "MQMarkerRerunTestResolution.labelText");
        }
        return labelText;
    }

    public void run(IMarker marker) {
        Trace t = Trace.getDefault();
        String id = MQMarkerRerunTestResolution.getTestId(t, marker);
        String nodeid = marker.getAttribute("treenodeid", "");
        TreeNode tn = TestsPlugin.findTreeNode(Trace.getDefault(), nodeid);
        ILaunchConfiguration config = ConfigurationManager.getConfiguration(t, marker);
        MQMarkerRerunTestResolution.rerunTest(t, id, config, tn);
    }

    public static void rerunTest(Trace t, String testid, ILaunchConfiguration config, TreeNode treeNode) {
        WMQTest test;
        if (testid != null && (test = WMQCategoryStore.getTest(t, testid)) != null) {
            WMQTest[] tests = new WMQTest[]{test};
            TestsPlugin plugin = TestsPlugin.getDefault();
            IProject runtimeproj = plugin.getProject();
            IMarker[] markers = new IMarker[1];
            try {
                markers = runtimeproj.findMarkers("com.ibm.mq.explorer.tests.mqmarker", true, 2);
            }
            catch (CoreException e) {
                t.data(66, "MQMarkerRerunTestResolution.rerunTest", 300, "Failed to get list of markers: " + e.getMessage());
            }
            int k = 0;
            while (k < markers.length) {
                IMarker mark = markers[k];
                String tstid = mark.getAttribute("testid", "");
                if (tstid.equals(testid)) {
                    try {
                        mark.delete();
                    }
                    catch (CoreException e1) {
                        t.data(66, "MQMarkerRerunTestResolution.rerunTest", 300, "Failed delete marker: " + e1.getMessage());
                    }
                }
                ++k;
            }
            new WMQTestEngine(t, config, (Object[])tests, treeNode).run();
        }
    }

    public static final String getTestId(Trace t, IMarker marker) {
        String testid = "";
        try {
            testid = (String)marker.getAttribute("testid");
        }
        catch (CoreException e) {
            t.data(66, "MQMarkerRerunTestResolution.getTestId", 900, "Error when getting testid attribute from MQ problem marker " + e.getMessage());
        }
        catch (Exception ee) {
            t.data(66, "MQMarkerRerunTestResolution.getTestId", 900, "Error when getting testid attribute from MQ problem marker " + ee.getMessage());
        }
        return testid;
    }
}

