/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextGroup;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class WMQContextStore {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/objects/WMQContextStore.java";
    private static Hashtable<String, WMQContextGroup> contextGroups = null;
    private static WMQContextStore self = null;
    private static TreeNode treeNode = null;
    private static TreeNode[] treeNodes = null;
    private static Hashtable<MQExtObject, Integer> objects = null;
    private static Hashtable<MQExtObject, TreeNode> selectedTreeNodes = null;

    public WMQContextStore(Trace t) {
        contextGroups = new Hashtable();
        objects = new Hashtable();
        selectedTreeNodes = new Hashtable();
        self = this;
    }

    public static void clear() {
        contextGroups.clear();
        objects.clear();
        selectedTreeNodes.clear();
    }

    public static WMQContextStore getDefault() {
        return self;
    }

    public static void addGroup(WMQContextGroup g) {
        String id = g.getGroupId();
        contextGroups.put(id, g);
    }

    public static Hashtable<String, WMQContextGroup> getGroups() {
        return contextGroups;
    }

    public static void clearExtObjects(Trace t) {
        Enumeration<WMQContextGroup> e = contextGroups.elements();
        while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            g.clearList();
        }
        objects.clear();
        selectedTreeNodes.clear();
    }

    public static void setExtObjectTicked(Trace t, MQExtObject o, boolean b) {
        Enumeration<WMQContextGroup> e = contextGroups.elements();
        while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            g.setExtObjectTicked(o, b);
        }
    }

    public static MQExtObject getExtObject(Trace t, String id) {
        MQExtObject res = null;
        Enumeration<WMQContextGroup> e = contextGroups.elements();
        block0: while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            Hashtable<MQExtObject, Integer> objs = g.getExtObjects();
            Enumeration<MQExtObject> e2 = objs.keys();
            while (e2.hasMoreElements()) {
                MQExtObject o = e2.nextElement();
                String match = TestsPlugin.generateObjectName(t, o);
                if (!match.equals(id)) continue;
                res = o;
                continue block0;
            }
        }
        return res;
    }

    public static WMQContextGroup getContextGroup(Trace t, MQExtObject o) {
        WMQContextGroup res = null;
        String objectId = TestsPlugin.generateObjectName(t, o);
        Enumeration<WMQContextGroup> e = contextGroups.elements();
        block0: while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            Hashtable<MQExtObject, Integer> objs = g.getExtObjects();
            Enumeration<MQExtObject> e2 = objs.keys();
            while (e2.hasMoreElements()) {
                MQExtObject o2 = e2.nextElement();
                String match = TestsPlugin.generateObjectName(t, o2);
                if (!objectId.equals(match)) continue;
                res = g;
                continue block0;
            }
        }
        return res;
    }

    public static MQExtObject[] getSelectedContexts(Trace t) {
        ArrayList<MQExtObject> list = new ArrayList<MQExtObject>();
        Enumeration<WMQContextGroup> e = WMQContextStore.getGroups().elements();
        while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            ArrayList<MQExtObject> al = g.getTickedExtObjects(t);
            for (MQExtObject ext : al) {
                list.add(ext);
            }
        }
        MQExtObject[] ret = null;
        ret = list.size() != 0 ? list.toArray(new MQExtObject[list.size()]) : new MQExtObject[]{};
        return ret;
    }

    public static TreeNode getTreeNode() {
        if (treeNode != null) {
            return treeNode;
        }
        if (treeNodes.length > 0) {
            return treeNodes[0];
        }
        return null;
    }

    public static void setTreeNode(TreeNode tn) {
        treeNode = tn;
    }

    public static TreeNode[] getSelectedTreeNodes() {
        return treeNodes;
    }

    public static void setSelectedTreeNodes(TreeNode[] tn) {
        treeNodes = tn;
    }

    public static WMQContextGroup getContextGroup(Trace t, String id) {
        Hashtable<String, WMQContextGroup> h = WMQContextStore.getGroups();
        WMQContextGroup group = h.get(id);
        return group;
    }

    public static Hashtable<MQExtObject, Integer> getObjects() {
        return objects;
    }

    public static void addObject(MQExtObject o, Integer i) {
        objects.put(o, i);
    }

    public static void setSelectedTreeNode(Trace t, MQExtObject obj, TreeNode selTreeNode) {
        if (selTreeNode != null) {
            selectedTreeNodes.put(obj, selTreeNode);
        }
    }

    public static TreeNode getSelectedTreeNode(MQExtObject obj) {
        TreeNode selTreeNode = treeNode;
        if (selectedTreeNodes.containsKey(obj)) {
            selTreeNode = selectedTreeNodes.get(obj);
        }
        return selTreeNode;
    }

    public static void setAllExtObjectsUnticked(Trace t) {
        Enumeration<MQExtObject> objs = objects.keys();
        while (objs.hasMoreElements()) {
            objects.put(objs.nextElement(), 0);
        }
    }
}

