/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextMatch;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class WMQContextGroup {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/objects/WMQContextGroup.java";
    private ArrayList<WMQContextMatch> contextMatchList = null;
    private String groupName = null;
    private String groupId = null;
    private Hashtable<MQExtObject, Integer> mqExtObjectList = null;

    public WMQContextGroup(Trace t, String gId, String gName) {
        this.groupId = gId;
        this.groupName = gName;
        this.contextMatchList = new ArrayList();
        this.mqExtObjectList = new Hashtable();
    }

    public String toString() {
        return this.groupName;
    }

    public void addMatch(WMQContextMatch m) {
        this.contextMatchList.add(m);
    }

    public ArrayList<WMQContextMatch> getContextMatchList() {
        return this.contextMatchList;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void clearList() {
        this.mqExtObjectList.clear();
    }

    public void addExtObject(MQExtObject o) {
        if (!WMQContextStore.getObjects().containsKey(o)) {
            this.mqExtObjectList.put(o, 0);
            WMQContextStore.addObject(o, 0);
        }
    }

    public void setExtObjectTicked(MQExtObject o, boolean b) {
        if (this.mqExtObjectList.containsKey(o)) {
            if (b) {
                this.mqExtObjectList.put(o, 1);
            } else {
                this.mqExtObjectList.put(o, 0);
            }
        }
    }

    public ArrayList<MQExtObject> getTickedExtObjects(Trace t) {
        ArrayList<MQExtObject> list = new ArrayList<MQExtObject>();
        Enumeration<MQExtObject> e = this.mqExtObjectList.keys();
        while (e.hasMoreElements()) {
            MQExtObject ext = e.nextElement();
            Integer i = this.mqExtObjectList.get(ext);
            if (!i.equals(1)) continue;
            list.add(ext);
        }
        return list;
    }

    public boolean isExtObjectTicked(Trace t, MQExtObject o) {
        boolean ticked = false;
        Integer i = this.mqExtObjectList.get(o);
        if (i != null && i.equals(1)) {
            ticked = true;
        }
        return ticked;
    }

    public Hashtable<MQExtObject, Integer> getExtObjects() {
        return this.mqExtObjectList;
    }
}

