/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategory;
import com.ibm.mq.explorer.tests.internal.objects.WMQMatchNodeId;
import com.ibm.mq.explorer.tests.internal.objects.WMQSubCategory;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class WMQCategoryStore {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/objects/WMQCategoryStore.java";
    private static Hashtable<String, WMQCategory> categories = null;
    private static WMQCategoryStore self = null;

    public WMQCategoryStore(Trace t) {
        categories = new Hashtable();
        WMQCategory c = new WMQCategory(t, "com.ibm.mq.explorer.tests.default", Messages.getString(t, "WMQCategoryStore.defaultCategoryName"), Messages.getString(t, "WMQCategoryStore.defaultCategoryDescription"), null, null);
        WMQCategoryStore.addCategory(t, c);
        self = this;
    }

    public static void clear(Trace t) {
        categories.clear();
        WMQCategory c = new WMQCategory(t, "com.ibm.mq.explorer.tests.default", Messages.getString(t, "WMQCategoryStore.defaultCategoryName"), Messages.getString(t, "WMQCategoryStore.defaultCategoryDescription"), null, null);
        WMQCategoryStore.addCategory(t, c);
    }

    public static WMQCategoryStore getDefault() {
        return self;
    }

    public static boolean addCategory(Trace t, WMQCategory c) {
        WMQCategory r;
        boolean result = true;
        String key = c.getId();
        if (categories.containsKey(key)) {
            if (Trace.isTracing) {
                t.data(66, "WMQCategoryStore.addCategory", 300, "category already exists: " + c.getName());
            }
            result = false;
        }
        if (result && (r = categories.put(key, c)) != null) {
            result = false;
            if (Trace.isTracing) {
                t.data(66, "WMQCategoryStore.addCategory", 300, "put to hash table failed");
            }
        }
        return result;
    }

    public static WMQCategory getCategory(String key) {
        return categories.get(key);
    }

    public static ArrayList<WMQTest> getAllTests(Trace t) {
        ArrayList<WMQTest> al = new ArrayList<WMQTest>();
        Enumeration<String> e = categories.keys();
        while (e.hasMoreElements()) {
            WMQCategory c = categories.get(e.nextElement());
            Hashtable<String, WMQSubCategory> h = c.getSubCategories(t);
            Enumeration<String> e1 = h.keys();
            while (e1.hasMoreElements()) {
                String key = e1.nextElement();
                WMQSubCategory s = c.getSubCategory(key);
                WMQTest[] tests = s.getTests();
                int k = 0;
                while (k < tests.length) {
                    al.add(tests[k]);
                    ++k;
                }
            }
        }
        return al;
    }

    public static WMQTest getTest(Trace t, final String testid) {
        WMQTest dummyForEquals = new WMQTest(){

            @Override
            public String getTestId() {
                return testid;
            }
        };
        ArrayList<WMQTest> tests = WMQCategoryStore.getAllTests(t);
        int index = tests.indexOf((Object)dummyForEquals);
        WMQTest res = null;
        if (index != -1) {
            res = tests.get(index);
        }
        return res;
    }

    public static WMQTest[] getTestsForTreeNode(Trace t, TreeNode treeNode) {
        ArrayList<WMQTest> tests = WMQCategoryStore.getAllTests(t);
        ArrayList<WMQTest> matchingTests = new ArrayList<WMQTest>();
        int k = 0;
        while (k < tests.size()) {
            WMQTest tst = tests.get(k);
            ArrayList<WMQMatchNodeId> matchIds = tst.getTestSubCategory().getMatchNodeIds();
            if (matchIds.size() == 0) {
                if (Trace.isTracing) {
                    t.data(66, "WMQCategoryStore.getTestsForTreeNode", 300, "no tree node id supplied, no pre-select can occur");
                }
            } else {
                for (WMQMatchNodeId m : matchIds) {
                    String matchNodeId = m.getNodeId();
                    if (m.getMatchType().equals("exact") && WMQCategoryStore.recurseTree(t, treeNode, matchNodeId, false)) {
                        if (!matchingTests.contains((Object)tst)) {
                            if (Trace.isTracing) {
                                t.data(66, "WMQCategoryStore.getTestsForTreeNode", 300, "adding test: " + tst.getName());
                            }
                            matchingTests.add(tst);
                            continue;
                        }
                        if (Trace.isTracing) {
                            t.data(66, "WMQCategoryStore.getTestsForTreeNode", 300, "test already added so not adding now: " + tst.getName());
                        }
                    }
                    if (!m.getMatchType().equals("startswith") || !WMQCategoryStore.recurseTree(t, treeNode, matchNodeId, true)) continue;
                    if (!matchingTests.contains((Object)tst)) {
                        if (Trace.isTracing) {
                            t.data(66, "WMQCategoryStore.getTestsForTreeNode", 300, "adding test: " + tst.getName());
                        }
                        matchingTests.add(tst);
                        continue;
                    }
                    if (!Trace.isTracing) continue;
                    t.data(66, "WMQCategoryStore.getTestsForTreeNode", 300, "test already added so not adding now: " + tst.getName());
                }
            }
            ++k;
        }
        WMQTest[] res = matchingTests.toArray(new WMQTest[matchingTests.size()]);
        return res;
    }

    private static boolean recurseTree(Trace t, TreeNode tn, String treeNodeId, boolean matchStarts) {
        boolean ret = false;
        if (!matchStarts && treeNodeId.equals(tn.getTreeNodeId())) {
            ret = true;
        }
        if (matchStarts && tn.getTreeNodeId().startsWith(treeNodeId)) {
            ret = true;
        }
        if (!ret && tn.hasChildren()) {
            TreeNode[] nodes = tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                ret = WMQCategoryStore.recurseTree(t, nodes[k], treeNodeId, matchStarts);
                if (ret) break;
                ++k;
            }
        }
        return ret;
    }

    public static Hashtable<String, WMQCategory> getCategories(Trace t) {
        Hashtable<String, WMQCategory> cats = new Hashtable<String, WMQCategory>(categories);
        WMQCategory c = WMQCategoryStore.getCategory("com.ibm.mq.explorer.tests.default");
        if (c.getSubCategories(t).size() == 0) {
            cats.remove("com.ibm.mq.explorer.tests.default");
            if (Trace.isTracing) {
                t.data(66, "WMQCategoryStore.getCategories", 300, "default category contains no sub cats - removing");
            }
        }
        return cats;
    }

    public static WMQSubCategory getSubCategory(Trace t, String key) {
        WMQSubCategory sub = null;
        Hashtable<String, WMQCategory> h = WMQCategoryStore.getCategories(t);
        Enumeration<WMQCategory> e = h.elements();
        while (e.hasMoreElements()) {
            WMQCategory cat = e.nextElement();
            WMQSubCategory s = cat.getSubCategory(key);
            if (s == null) continue;
            sub = s;
            break;
        }
        return sub;
    }

    public static WMQCategory getCategoryContainingSub(Trace t, String subid) {
        WMQCategory retcat = null;
        Hashtable<String, WMQCategory> h = WMQCategoryStore.getCategories(t);
        Enumeration<WMQCategory> e = h.elements();
        while (e.hasMoreElements()) {
            WMQCategory cat = e.nextElement();
            WMQSubCategory s = cat.getSubCategory(subid);
            if (s == null) continue;
            retcat = cat;
        }
        return retcat;
    }
}

