/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.launch;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.OpenBrowserAction;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategory;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQSubCategory;
import com.ibm.mq.explorer.tests.internal.ui.TestsContentProvider;
import com.ibm.mq.explorer.tests.internal.ui.TestsLabelProvider;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.CheckAndGreyTreeViewer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class TestsTab
implements ILaunchConfigurationTab {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/launch/TestsTab.java";
    private CheckAndGreyTreeViewer treeViewer = null;
    private Button expandSelection = null;
    private Menu mymenu = null;
    private Composite myComp = null;
    public static final String ENABLED_TESTS_KEY = "enabledTests";
    public static final String ENABLED_CATEGORIES = "enabledSubCategories";
    public static final String AUTO_EXPANSION_TEST_KEY = "autoExpandTests";
    public static final String YES = "yes";
    public static final String NO = "no";
    private ILaunchConfigurationDialog myDialog = null;

    public void createControl(final Composite parent) {
        final Trace t = Trace.getDefault();
        if (this.myComp == null) {
            this.myComp = new Composite(parent, 0);
            UiPlugin.getHelpSystem().setHelp((Control)this.myComp, "com.ibm.mq.explorer.tests.infopop.RunDialog_testsTab");
            GridLayout pageLayout = new GridLayout();
            pageLayout.verticalSpacing = 10;
            this.myComp.setLayout((Layout)pageLayout);
            Composite topComp = new Composite(this.myComp, 0);
            GridLayout gridLayout = new GridLayout();
            topComp.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            topComp.setLayoutData((Object)gridData);
            Group groupSelectTests = new Group(topComp, 0);
            groupSelectTests.setText(Messages.getString(t, "TestsTab.selectTests"));
            gridLayout = new GridLayout();
            groupSelectTests.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            groupSelectTests.setLayoutData((Object)gridData);
            Composite listTestsTable = new Composite((Composite)groupSelectTests, 0);
            listTestsTable.setLayout((Layout)new GridLayout(2, false));
            gridData = new GridData(1808);
            listTestsTable.setLayoutData((Object)gridData);
            Composite treeparent = new Composite(listTestsTable, 0);
            GridData layoutinfo = new GridData(1808);
            treeparent.setLayoutData((Object)layoutinfo);
            treeparent.setLayout((Layout)new FillLayout());
            TestsContentProvider contentProvider = new TestsContentProvider();
            this.treeViewer = new CheckAndGreyTreeViewer(treeparent);
            this.treeViewer.setContentProvider((IContentProvider)contentProvider);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new TestsLabelProvider());
            this.treeViewer.setInput((Object)WMQCategoryStore.getDefault());
            this.treeViewer.setSorter(new ViewerSorter());
            this.treeViewer.expandAll();
            TreeItem[] top = new TreeItem[1];
            TreeItem[] all = this.treeViewer.getTree().getItems();
            if (all != null && all.length != 0) {
                top[0] = all[0];
                if (top[0] != null) {
                    this.treeViewer.getTree().setSelection(top);
                }
            }
            Composite buttons = new Composite(listTestsTable, 0);
            buttons.setLayout((Layout)new GridLayout(1, false));
            layoutinfo = new GridData(1040);
            buttons.setLayoutData((Object)layoutinfo);
            Button selectAll = new Button(buttons, 8);
            selectAll.setText(Messages.getString(t, "RootContentPage.selectAll"));
            selectAll.setAlignment(0x1000000);
            layoutinfo = new GridData(770);
            layoutinfo.verticalAlignment = 1;
            selectAll.setLayoutData((Object)layoutinfo);
            Button selectNone = new Button(buttons, 8);
            selectNone.setText(Messages.getString(t, "RootContentPage.deselectAll"));
            selectNone.setAlignment(0x1000000);
            layoutinfo = new GridData(770);
            layoutinfo.verticalAlignment = 1;
            selectNone.setLayoutData((Object)layoutinfo);
            this.expandSelection = new Button(this.myComp, 32);
            this.expandSelection.setText(Messages.getString(t, "TestsTab.expandSelection"));
            gridData = new GridData(768);
            this.expandSelection.setLayoutData((Object)gridData);
            topComp.layout();
            this.expandSelection.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TestsTab.this.myDialog.updateButtons();
                    TestsTab.this.myDialog.updateMessage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (event.getSelection() instanceof StructuredSelection) {
                        StructuredSelection selection = (StructuredSelection)event.getSelection();
                        Object selectedItem = selection.getFirstElement();
                        if (selectedItem instanceof WMQTest) {
                            WMQTest test = (WMQTest)((Object)selectedItem);
                            OpenBrowserAction browser = new OpenBrowserAction(test);
                            parent.getDisplay().asyncExec((Runnable)browser);
                        } else if (selectedItem instanceof WMQCategory) {
                            WMQCategory cat = (WMQCategory)selectedItem;
                            OpenBrowserAction browser = new OpenBrowserAction(t, cat.getName(), cat.getFurtherinfo());
                            parent.getDisplay().asyncExec((Runnable)browser);
                        } else if (selectedItem instanceof WMQSubCategory) {
                            WMQSubCategory subcat = (WMQSubCategory)selectedItem;
                            OpenBrowserAction browser = new OpenBrowserAction(t, subcat.getName(), subcat.getFurtherinfo());
                            parent.getDisplay().asyncExec((Runnable)browser);
                        }
                    }
                }
            });
            MenuManager menumgr = new MenuManager();
            this.mymenu = menumgr.createContextMenu((Control)this.treeViewer.getTree());
            this.treeViewer.getTree().setMenu(this.mymenu);
            this.mymenu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    boolean enableMenu = false;
                    if (TestsTab.this.treeViewer.getSelection() instanceof StructuredSelection) {
                        WMQSubCategory sub;
                        WMQCategory c;
                        WMQTest tst;
                        StructuredSelection selection = (StructuredSelection)TestsTab.this.treeViewer.getSelection();
                        Object selectedItem = selection.getFirstElement();
                        enableMenu = selectedItem instanceof WMQTest ? (tst = (WMQTest)((Object)selectedItem)).getFurtherInfoPath() != null : (selectedItem instanceof WMQCategory ? (c = (WMQCategory)selectedItem).getFurtherinfo() != null : (selectedItem instanceof WMQSubCategory ? (sub = (WMQSubCategory)selectedItem).getFurtherinfo() != null : false));
                    }
                    int i = 0;
                    while (i < TestsTab.this.mymenu.getItemCount()) {
                        TestsTab.this.mymenu.getItem(i).setEnabled(enableMenu);
                        ++i;
                    }
                }
            });
            menumgr.add((IAction)new Action(Messages.getString(t, "RootContentPage.getMoreInfo")){

                public void run() {
                    if (TestsTab.this.treeViewer.getSelection() instanceof StructuredSelection) {
                        StructuredSelection selection = (StructuredSelection)TestsTab.this.treeViewer.getSelection();
                        Object selectedItem = selection.getFirstElement();
                        OpenBrowserAction browser = null;
                        if (selectedItem instanceof WMQTest) {
                            WMQTest test = (WMQTest)((Object)selectedItem);
                            browser = new OpenBrowserAction(test);
                        } else if (selectedItem instanceof WMQCategory) {
                            WMQCategory cat = (WMQCategory)selectedItem;
                            browser = new OpenBrowserAction(t, cat.getName(), cat.getFurtherinfo());
                        } else if (selectedItem instanceof WMQSubCategory) {
                            WMQSubCategory subcat = (WMQSubCategory)selectedItem;
                            browser = new OpenBrowserAction(t, subcat.getName(), subcat.getFurtherinfo());
                        }
                        if (browser != null) {
                            parent.getDisplay().asyncExec((Runnable)browser);
                        }
                    }
                }
            });
            this.treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    TestsTab.this.myDialog.updateButtons();
                    TestsTab.this.myDialog.updateMessage();
                }
            });
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TestsTab.this.selectAll(t);
                }
            });
            selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TestsTab.this.deselectAll(t);
                }
            });
            if (parent instanceof ScrolledComposite) {
                ((ScrolledComposite)parent).setShowFocusedControl(false);
            }
            Button selectAllButton = selectAll;
            Button selectNoneButton = selectNone;
            selectAll.addFocusListener((FocusListener)new FocusAdapter((Control)selectAllButton){
                private final /* synthetic */ Control val$selectAllButton;
                {
                    this.val$selectAllButton = control;
                }

                public void focusGained(FocusEvent e) {
                    if (parent instanceof ScrolledComposite) {
                        ((ScrolledComposite)parent).showControl(this.val$selectAllButton);
                    }
                }
            });
            selectNone.addFocusListener((FocusListener)new FocusAdapter((Control)selectNoneButton){
                private final /* synthetic */ Control val$selectNoneButton;
                {
                    this.val$selectNoneButton = control;
                }

                public void focusGained(FocusEvent e) {
                    if (parent instanceof ScrolledComposite) {
                        ((ScrolledComposite)parent).showControl(this.val$selectNoneButton);
                    }
                }
            });
        }
    }

    private void selectAll(Trace t) {
        this.treeViewer.setGrayedElements(new Object[0]);
        Hashtable<String, WMQCategory> cats = WMQCategoryStore.getCategories(t);
        Enumeration<WMQCategory> e = cats.elements();
        while (e.hasMoreElements()) {
            WMQCategory c = e.nextElement();
            this.treeViewer.setSubtreeChecked((Object)c, true);
        }
        this.myDialog.updateButtons();
        this.myDialog.updateMessage();
    }

    private void deselectAll(Trace t) {
        this.treeViewer.setGrayedElements(new Object[0]);
        Hashtable<String, WMQCategory> cats = WMQCategoryStore.getCategories(t);
        Enumeration<WMQCategory> e = cats.elements();
        while (e.hasMoreElements()) {
            WMQCategory c = e.nextElement();
            this.treeViewer.setSubtreeChecked((Object)c, false);
        }
        this.myDialog.updateButtons();
        this.myDialog.updateMessage();
    }

    public Control getControl() {
        return this.myComp;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Trace t = Trace.getDefault();
        IStructuredSelection selection = (IStructuredSelection)UiPlugin.getMQNavigatorViewSelection((Trace)Trace.getDefault());
        Object object = selection.getFirstElement();
        if (object instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)object;
            WMQTest[] tests = WMQCategoryStore.getTestsForTreeNode(t, treeNode);
            ArrayList<String> selectedTests = new ArrayList<String>();
            int k = 0;
            while (k < tests.length) {
                WMQTest tst = tests[k];
                selectedTests.add(tst.getTestId());
                ++k;
            }
            configuration.setAttribute(ENABLED_TESTS_KEY, selectedTests);
        }
        configuration.setAttribute(AUTO_EXPANSION_TEST_KEY, NO);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        Trace t = Trace.getDefault();
        String autoExpand = "";
        try {
            autoExpand = configuration.getAttribute(AUTO_EXPANSION_TEST_KEY, "");
        }
        catch (CoreException coreException) {}
        if (autoExpand.equals(YES)) {
            this.expandSelection.setSelection(true);
        } else {
            this.expandSelection.setSelection(false);
        }
        this.treeViewer.setCheckedElements(new Object[0]);
        ArrayList selectedTests = null;
        try {
            selectedTests = (ArrayList)configuration.getAttribute(ENABLED_TESTS_KEY, new ArrayList());
        }
        catch (CoreException coreException) {}
        if (autoExpand.equals(YES)) {
            try {
                ArrayList subcats = (ArrayList)configuration.getAttribute(ENABLED_CATEGORIES, new ArrayList());
                for (String key : subcats) {
                    WMQSubCategory s = WMQCategoryStore.getSubCategory(t, key);
                    t.data(66, "TestsTab.initializeFrom", 300, "Auto-Expanding " + s);
                    this.treeViewer.setChecked((Object)s, true);
                    this.treeViewer.setSubtreeChecked((Object)s, true);
                }
            }
            catch (CoreException coreException) {}
        }
        if (selectedTests != null) {
            for (String testId : selectedTests) {
                WMQTest tst = WMQCategoryStore.getTest(t, testId);
                if (tst == null) continue;
                this.treeViewer.setChecked((Object)tst, true);
            }
        }
    }

    public void dispose() {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Trace t = Trace.getDefault();
        ArrayList<String> selectedTests = new ArrayList<String>();
        Object[] objs = this.treeViewer.getCheckedElements();
        int k = 0;
        while (k < objs.length) {
            if (objs[k] instanceof WMQTest) {
                WMQTest tst = (WMQTest)((Object)objs[k]);
                selectedTests.add(tst.getTestId());
            }
            ++k;
        }
        ArrayList<String> selectedSubCats = new ArrayList<String>();
        Object[] items = this.treeViewer.getCheckedElements();
        int k2 = 0;
        while (k2 < items.length) {
            WMQSubCategory sub;
            if (items[k2] instanceof WMQSubCategory && !this.treeViewer.getGrayed((Object)(sub = (WMQSubCategory)items[k2]))) {
                selectedSubCats.add(sub.getId());
                t.data(66, "TestsTab.performApply", 300, "Added " + sub + " for future auto expand");
            }
            ++k2;
        }
        configuration.setAttribute(ENABLED_CATEGORIES, selectedSubCats);
        configuration.setAttribute(ENABLED_TESTS_KEY, selectedTests);
        String autoExpand = "";
        autoExpand = this.expandSelection.getSelection() ? YES : NO;
        configuration.setAttribute(AUTO_EXPANSION_TEST_KEY, autoExpand);
    }

    public String getErrorMessage() {
        String error = null;
        if (this.treeViewer.getCheckedElements().length == 0) {
            error = Messages.getString(Trace.getDefault(), "TestsTab.selectTestsError");
        }
        return error;
    }

    public String getMessage() {
        return Messages.getString(Trace.getDefault(), "TestsTab.selectTestsBannerText");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result = false;
        if (this.treeViewer.getCheckedElements().length > 0) {
            result = true;
        }
        return result;
    }

    public boolean canSave() {
        return true;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.myDialog = dialog;
    }

    public void launched(ILaunch launch) {
    }

    public String getName() {
        return Messages.getString(Trace.getDefault(), "TestsTab.TestsTabTitle");
    }

    public Image getImage() {
        return Icons.getImage(Trace.getDefault(), "com.ibm.mq.explorer.tests.imagekey.Test");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

