/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.launch;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.launch.ConfigurationManager;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextGroup;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextMatch;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class RunDefaultTests
implements IActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/launch/RunDefaultTests.java";
    public static final String LAUNCH_DIALOG_GROUPID = "com.ibm.mq.explorer.tests";
    public static final String EXACT = "exact";
    public static final String STARTSWITH = "startswith";

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        IStructuredSelection selection = (IStructuredSelection)UiPlugin.getMQNavigatorViewSelection((Trace)Trace.getDefault());
        Object[] objects = selection.toArray();
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TreeNode) {
                treeNodes.add((TreeNode)o);
            }
            ++n2;
        }
        WMQContextStore.setSelectedTreeNodes(treeNodes.toArray(new TreeNode[0]));
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.ibm.mq.explorer.tests.internal.launchConfigurationType");
        String configName = Messages.getString(t, "TestsPlugin.newConfig");
        ILaunchConfigurationWorkingCopy configuration = null;
        try {
            configuration = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configName));
        }
        catch (CoreException e1) {
            t.FFST(66, "RunDefaultTests.run", 0, 50999, "Failed to create new configuration instance: " + e1.getMessage());
        }
        if (Trace.isTracing) {
            t.data(66, "RunDefaultTests.run", 300, "Created a new configuration called: " + (configuration == null ? "null" : configuration.getName()));
        }
        TreeNode initialNode = (TreeNode)objects[0];
        WMQContextStore.clearExtObjects(t);
        if (Trace.isTracing) {
            t.data(66, "RunDefaultTests.run", 300, "Recursing tree looking for context objects..");
        }
        TreeNode topNode = initialNode;
        while (topNode.getParent() != null) {
            topNode = topNode.getParent();
        }
        this.recurseTree(t, topNode);
        if (configuration != null) {
            int iObj = 0;
            while (iObj < objects.length) {
                if (objects[iObj] instanceof TreeNode) {
                    TreeNode current = (TreeNode)objects[iObj];
                    TreeNode tn = (TreeNode)objects[iObj];
                    while (tn.getParent() != null) {
                        Object o = tn.getObject();
                        if (o != null && o instanceof MQExtObject) {
                            MQExtObject e = (MQExtObject)o;
                            WMQContextStore.setExtObjectTicked(t, e, true);
                            WMQContextStore.setSelectedTreeNode(t, e, tn);
                        }
                        tn = tn.getParent();
                    }
                    this.setTicked(t, current);
                }
                ++iObj;
            }
            ArrayList<String> selectedObjects = new ArrayList<String>();
            Hashtable<String, WMQContextGroup> h = WMQContextStore.getGroups();
            Enumeration<WMQContextGroup> e = h.elements();
            while (e.hasMoreElements()) {
                WMQContextGroup g = e.nextElement();
                ArrayList<MQExtObject> al = g.getTickedExtObjects(t);
                for (MQExtObject ext : al) {
                    String name = TestsPlugin.generateObjectName(t, ext);
                    selectedObjects.add(name);
                }
            }
            if (Trace.isTracing) {
                t.data(66, "RunDefaultTests.run", 300, "adding contexts and expansion state to configuration");
            }
            configuration.setAttribute("enabledContexts", selectedObjects);
            configuration.setAttribute("autoExpandContext", "no");
            WMQTest[] tests = WMQCategoryStore.getTestsForTreeNode(t, initialNode);
            ArrayList<String> selectedTests = new ArrayList<String>();
            int k = 0;
            while (k < tests.length) {
                WMQTest tst = tests[k];
                selectedTests.add(tst.getTestId());
                ++k;
            }
            configuration.setAttribute("enabledTests", selectedTests);
            configuration.setAttribute("autoExpandTests", "no");
            ILaunchConfiguration[] configs = new ILaunchConfiguration[]{};
            try {
                configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            }
            catch (CoreException e2) {
                t.FFST(66, "RunDefaultTests.run", 0, 50999, "Failed to get list of configurations: " + e2.getMessage());
            }
            int k2 = 0;
            while (k2 < configs.length) {
                ILaunchConfiguration conf = configs[k2];
                boolean r = false;
                try {
                    r = ConfigurationManager.compareConfig(t, configuration, conf);
                }
                catch (CoreException e4) {
                    t.FFST(66, "RunDefaultTests.run", 0, 50999, "Failed to compare configurations: " + e4.getMessage());
                }
                if (r) {
                    try {
                        configuration.delete();
                        configuration = conf.getWorkingCopy();
                        break;
                    }
                    catch (CoreException e3) {
                        t.FFST(66, "RunDefaultTests.run", 0, 50999, "Failed to delete or get working copy: " + e3.getMessage());
                    }
                }
                ++k2;
            }
            new WMQTestEngine(t, (ILaunchConfiguration)configuration, initialNode).run();
        } else {
            t.FFST(66, "RunDefaultTests.run", 0, 50999, "null configuration found!");
        }
    }

    private void setTicked(Trace t, TreeNode tn) {
        Object o = tn.getObject();
        if (o != null && o instanceof MQExtObject) {
            MQExtObject e = (MQExtObject)o;
            WMQContextStore.setExtObjectTicked(t, e, true);
        }
        if (tn.hasChildren()) {
            TreeNode[] nodes = tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                this.setTicked(t, nodes[k]);
                ++k;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && (structSel = (IStructuredSelection)selection).size() > 1) {
            boolean isSame = true;
            Object firstObj = structSel.getFirstElement();
            Class<?> firstClass = firstObj.getClass();
            for (Object obj : structSel.toList()) {
                if (firstClass.isInstance(obj)) continue;
                isSame = false;
                break;
            }
            action.setEnabled(isSame);
        }
    }

    private void recurseTree(Trace t, TreeNode tn) {
        Object o = tn.getObject();
        if (o != null && o instanceof MQExtObject) {
            MQExtObject e = (MQExtObject)o;
            this.filterObject(t, e);
        }
        if (tn.hasChildren()) {
            if (Trace.isTracing) {
                t.data(66, "RunDefaultTests.recurseTree", 300, "checking node children of node " + tn.getId());
            }
            TreeNode[] nodes = null;
            nodes = PreferenceStoreManager.getIncludeHiddenQmgrsPreference() ? tn.getChildren() : tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                this.recurseTree(t, nodes[k]);
                ++k;
            }
        }
    }

    private void filterObject(Trace t, MQExtObject o) {
        Hashtable<String, WMQContextGroup> ht = WMQContextStore.getGroups();
        Enumeration<WMQContextGroup> e = ht.elements();
        while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            ArrayList<WMQContextMatch> matches = g.getContextMatchList();
            block7: for (WMQContextMatch m : matches) {
                String matchType = m.getType();
                String matchData = m.getData();
                switch (m.getWhatForSwitch(t)) {
                    case 2: {
                        if (!o.getClass().getName().equals(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    case 4: {
                        if (matchType.equals(EXACT) && o.getObjectId() != null && o.getObjectId().equals(matchData)) {
                            g.addExtObject(o);
                        }
                        if (o.getObjectId() == null || !matchType.equals(STARTSWITH) || !o.getObjectId().startsWith(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    case 3: {
                        if (o.getObjectId() != null && matchType.equals(EXACT) && o.getName().equals(matchData)) {
                            g.addExtObject(o);
                        }
                        if (o.getObjectId() == null || !matchType.equals(STARTSWITH) || !o.getName().startsWith(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    case 1: {
                        if (o.getMqType() != null && matchType.equals(EXACT) && o.getMqType().equals(matchData)) {
                            g.addExtObject(o);
                        }
                        if (o.getMqType() == null || !matchType.equals(STARTSWITH) || !o.getMqType().startsWith(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    default: {
                        t.FFST(66, "RunDefaultTests.filterObject", 0, 50999, "Bad WMQContextMatch object type");
                    }
                }
            }
        }
    }
}

