/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.launch;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextGroup;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextMatch;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class OpenLaunchDialogAction
implements IActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/launch/OpenLaunchDialogAction.java";
    public static final String LAUNCH_DIALOG_GROUPID = "com.ibm.mq.explorer.tests";
    public static final String EXACT = "exact";
    public static final String STARTSWITH = "startswith";

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        IStructuredSelection selection = (IStructuredSelection)UiPlugin.getMQNavigatorViewSelection((Trace)Trace.getDefault());
        Object[] objects = selection.toArray();
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TreeNode) {
                treeNodes.add((TreeNode)o);
            }
            ++n2;
        }
        WMQContextStore.setSelectedTreeNodes(treeNodes.toArray(new TreeNode[0]));
        if (Trace.isTracing) {
            t.data(66, "OpenLaunchDialogAction.run", 300, "setting context tree node ids: " + treeNodes.toString());
        }
        WMQContextStore.clearExtObjects(t);
        for (TreeNode treeNode : treeNodes) {
            while (treeNode.getParent() != null) {
                treeNode = treeNode.getParent();
            }
            if (Trace.isTracing) {
                t.data(66, "OpenLaunchDialogAction.run", 300, "Recursing tree looking for context objects..");
            }
            this.recurseTree(t, treeNode);
        }
        if (Trace.isTracing) {
            t.data(66, "OpenLaunchDialogAction.run", 300, "Open dialog");
        }
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)UiPlugin.getShell(), (IStructuredSelection)new StructuredSelection(){}, (String)LAUNCH_DIALOG_GROUPID);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && (structSel = (IStructuredSelection)selection).size() > 1) {
            boolean isSame = true;
            Object firstObj = structSel.getFirstElement();
            Class<?> firstClass = firstObj.getClass();
            for (Object obj : structSel.toList()) {
                if (firstClass.isInstance(obj)) continue;
                isSame = false;
                break;
            }
            action.setEnabled(isSame);
        }
    }

    private void recurseTree(Trace t, TreeNode tn) {
        Object o = tn.getObject();
        if (o != null && o instanceof MQExtObject) {
            MQExtObject e = (MQExtObject)o;
            this.filterObject(t, e);
        }
        if (tn.hasChildren()) {
            if (Trace.isTracing) {
                t.data(66, "OpenLaunchDialogAction.recurseTree", 300, "checking node children of node " + tn.getId());
            }
            TreeNode[] nodes = null;
            nodes = PreferenceStoreManager.getIncludeHiddenQmgrsPreference() ? tn.getChildren() : tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                this.recurseTree(t, nodes[k]);
                ++k;
            }
        }
    }

    private void filterObject(Trace t, MQExtObject o) {
        Hashtable<String, WMQContextGroup> ht = WMQContextStore.getGroups();
        Enumeration<WMQContextGroup> e = ht.elements();
        while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            ArrayList<WMQContextMatch> matches = g.getContextMatchList();
            block7: for (WMQContextMatch m : matches) {
                String matchType = m.getType();
                String matchData = m.getData();
                switch (m.getWhatForSwitch(t)) {
                    case 2: {
                        if (!o.getClass().getName().equals(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    case 4: {
                        if (matchType.equals(EXACT) && o.getObjectId() != null && o.getObjectId().equals(matchData)) {
                            g.addExtObject(o);
                        }
                        if (o.getObjectId() == null || !matchType.equals(STARTSWITH) || !o.getObjectId().startsWith(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    case 3: {
                        if (o.getObjectId() != null && matchType.equals(EXACT) && o.getName().equals(matchData)) {
                            g.addExtObject(o);
                        }
                        if (o.getObjectId() == null || !matchType.equals(STARTSWITH) || !o.getName().startsWith(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    case 1: {
                        if (o.getMqType() != null && matchType.equals(EXACT) && o.getMqType().equals(matchData)) {
                            g.addExtObject(o);
                        }
                        if (o.getMqType() == null || !matchType.equals(STARTSWITH) || !o.getMqType().startsWith(matchData)) continue block7;
                        g.addExtObject(o);
                        break;
                    }
                    default: {
                        t.FFST(66, "OpenLaunchDialogAction.filterObject", 0, 50999, "Bad WMQContextMatch object type");
                    }
                }
            }
        }
    }
}

