/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.launch;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextGroup;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.tests.internal.ui.TestConfigurationMismatchDialog;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LaunchConfigurationDelegate1
implements ILaunchConfigurationDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/launch/LaunchConfigurationDelegate1.java";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        final Trace t = Trace.getDefault();
        TreeNode[] treeNodes = WMQContextStore.getSelectedTreeNodes();
        ArrayList<Object> contexts = new ArrayList<Object>();
        MQExtObject[] mQExtObjectArray = WMQContextStore.getSelectedContexts(t);
        int n = mQExtObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            MQExtObject context = mQExtObjectArray[n2];
            contexts.add(context);
            ++n2;
        }
        final ArrayList<MQExtObject> mismatchedObjects = new ArrayList<MQExtObject>(contexts.size());
        ArrayList<MQExtObject> selectedObjects = new ArrayList<MQExtObject>(treeNodes.length);
        if (configuration != null) {
            TreeNode[] treeNodeArray = treeNodes;
            int n3 = treeNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeNode node = treeNodeArray[n4];
                this.setTicked(t, node);
                while (node.getParent() != null) {
                    Object o = node.getObject();
                    if (o != null && o instanceof MQExtObject) {
                        MQExtObject e = (MQExtObject)o;
                        WMQContextStore.setExtObjectTicked(t, e, true);
                        WMQContextStore.setSelectedTreeNode(t, e, node);
                    }
                    node = node.getParent();
                }
                ++n4;
            }
            for (WMQContextGroup contextGroup : WMQContextStore.getGroups().values()) {
                for (MQExtObject ext : contextGroup.getTickedExtObjects(t)) {
                    selectedObjects.add(ext);
                }
            }
        }
        for (MQExtObject obj : selectedObjects) {
            if (contexts.contains(obj)) continue;
            mismatchedObjects.add(obj);
        }
        final int[] rc = new int[]{0};
        final boolean[] persist = new boolean[]{false};
        if (mismatchedObjects.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = UiPlugin.getShell();
                    TestConfigurationMismatchDialog d = new TestConfigurationMismatchDialog(t, shell, mismatchedObjects);
                    if (d.open() == 0) {
                        rc[0] = d.getSelectedAction();
                        persist[0] = d.isPersistChanges();
                    } else {
                        rc[0] = -1;
                    }
                }
            });
        }
        switch (rc[0]) {
            case 1: {
                contexts = selectedObjects;
                break;
            }
            case 2: {
                contexts.addAll(mismatchedObjects);
                break;
            }
            case 0: {
                new WMQTestEngine(t, configuration, treeNodes[0]).run();
            }
            default: {
                return;
            }
        }
        ArrayList<String> newEnabledContexts = new ArrayList<String>();
        for (MQExtObject mQExtObject : contexts) {
            newEnabledContexts.add(String.valueOf(mQExtObject.getMqType()) + mQExtObject.getMqType() + mQExtObject.toString());
        }
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = configuration.getWorkingCopy();
        iLaunchConfigurationWorkingCopy.setAttribute("enabledContexts", newEnabledContexts);
        if (persist[0]) {
            iLaunchConfigurationWorkingCopy.doSave();
        }
        new WMQTestEngine(t, (ILaunchConfiguration)iLaunchConfigurationWorkingCopy, treeNodes[0]).run();
    }

    private void setTicked(Trace t, TreeNode tn) {
        Object o = tn.getObject();
        if (o != null && o instanceof MQExtObject) {
            MQExtObject e = (MQExtObject)o;
            WMQContextStore.setExtObjectTicked(t, e, true);
        }
        if (tn.hasChildren()) {
            TreeNode[] nodes = tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                this.setTicked(t, nodes[k]);
                ++k;
            }
        }
    }
}

