/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.launch;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextGroup;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.tests.internal.ui.ContextContentProvider;
import com.ibm.mq.explorer.tests.internal.ui.ContextLabelProvider;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.CheckAndGreyTreeViewer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class ContextObjectsTab
implements ILaunchConfigurationTab {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/launch/ContextObjectsTab.java";
    private Composite myComp = null;
    private CheckAndGreyTreeViewer treeViewer = null;
    private Button expandSelection = null;
    public static final String CONTEXTS_KEY = "enabledContexts";
    public static final String CONTEXTS_GROUP_KEY = "enabledContextGroups";
    public static final String AUTO_EXPANSION_CONTEXT_KEY = "autoExpandContext";
    public static final String YES = "yes";
    public static final String NO = "no";
    private ILaunchConfigurationDialog myDialog;

    public void createControl(Composite parent) {
        final Trace t = Trace.getDefault();
        this.myComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 10;
        this.myComp.setLayout((Layout)gl);
        UiPlugin.getHelpSystem().setHelp((Control)this.myComp, "com.ibm.mq.explorer.tests.infopop.RunDialog_contextTab");
        ContextContentProvider contentProvider = new ContextContentProvider();
        Group groupSelectContexts = new Group(this.myComp, 0);
        groupSelectContexts.setText(Messages.getString(t, "ContextObjectsTab.selectObjects"));
        GridLayout gridLayout = new GridLayout();
        groupSelectContexts.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupSelectContexts.setLayoutData((Object)gridData);
        Composite listContextsTable = new Composite((Composite)groupSelectContexts, 0);
        listContextsTable.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(1808);
        listContextsTable.setLayoutData((Object)gridData);
        Composite treeparent = new Composite(listContextsTable, 0);
        GridData layoutinfo = new GridData(1808);
        treeparent.setLayoutData((Object)layoutinfo);
        treeparent.setLayout((Layout)new FillLayout());
        this.treeViewer = new CheckAndGreyTreeViewer(treeparent);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ContextLabelProvider());
        this.treeViewer.setInput((Object)WMQContextStore.getDefault());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.expandAll();
        TreeItem[] top = new TreeItem[1];
        TreeItem[] all = this.treeViewer.getTree().getItems();
        if (all != null && all.length != 0) {
            top[0] = all[0];
            if (top[0] != null) {
                this.treeViewer.getTree().setSelection(top);
            }
        }
        Composite buttons = new Composite(listContextsTable, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        layoutinfo = new GridData(1040);
        buttons.setLayoutData((Object)layoutinfo);
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(Messages.getString(t, "RootContentPage.selectAll"));
        selectAll.setAlignment(0x1000000);
        layoutinfo = new GridData(770);
        layoutinfo.verticalAlignment = 1;
        selectAll.setLayoutData((Object)layoutinfo);
        Button selectNone = new Button(buttons, 8);
        selectNone.setText(Messages.getString(t, "RootContentPage.deselectAll"));
        selectNone.setAlignment(0x1000000);
        layoutinfo = new GridData(770);
        layoutinfo.verticalAlignment = 1;
        selectNone.setLayoutData((Object)layoutinfo);
        this.expandSelection = new Button(this.myComp, 32);
        this.expandSelection.setText(Messages.getString(t, "ContextObjectsTab.expandSelection"));
        gridData = new GridData(768);
        this.expandSelection.setLayoutData((Object)gridData);
        this.expandSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextObjectsTab.this.myDialog.updateButtons();
                ContextObjectsTab.this.myDialog.updateMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ContextObjectsTab.this.myDialog.updateButtons();
                ContextObjectsTab.this.myDialog.updateMessage();
            }
        });
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextObjectsTab.this.selectAll(t);
            }
        });
        selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextObjectsTab.this.deselectAll(t);
            }
        });
        this.myComp.layout();
    }

    public void selectAll(Trace t) {
        this.treeViewer.setGrayedElements(new Object[0]);
        TreeItem[] items = this.treeViewer.getTree().getItems();
        int k = 0;
        while (k < items.length) {
            this.treeViewer.setSubtreeChecked(items[k].getData(), true);
            ++k;
        }
        this.myDialog.updateButtons();
        this.myDialog.updateMessage();
    }

    public void deselectAll(Trace t) {
        this.treeViewer.setGrayedElements(new Object[0]);
        this.treeViewer.setCheckedElements(new Object[0]);
        this.myDialog.updateButtons();
        this.myDialog.updateMessage();
    }

    public Control getControl() {
        return this.myComp;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Trace t = Trace.getDefault();
        IStructuredSelection selection = (IStructuredSelection)UiPlugin.getMQNavigatorViewSelection((Trace)Trace.getDefault());
        Object[] objects = selection.toArray();
        int iObj = 0;
        while (iObj < objects.length) {
            if (objects[iObj] instanceof TreeNode) {
                TreeNode current = (TreeNode)objects[iObj];
                TreeNode tn = (TreeNode)objects[iObj];
                while (tn.getParent() != null) {
                    Object o = tn.getObject();
                    if (o != null && o instanceof MQExtObject) {
                        MQExtObject e = (MQExtObject)o;
                        WMQContextStore.setExtObjectTicked(t, e, true);
                    }
                    tn = tn.getParent();
                }
                this.setTicked(t, current);
            }
            ++iObj;
        }
        ArrayList<String> selectedObjects = new ArrayList<String>();
        Hashtable<String, WMQContextGroup> h = WMQContextStore.getGroups();
        Enumeration<WMQContextGroup> e = h.elements();
        while (e.hasMoreElements()) {
            WMQContextGroup g = e.nextElement();
            ArrayList<MQExtObject> al = g.getTickedExtObjects(t);
            for (MQExtObject ext : al) {
                String name = TestsPlugin.generateObjectName(t, ext);
                selectedObjects.add(name);
            }
        }
        configuration.setAttribute(CONTEXTS_KEY, selectedObjects);
        configuration.setAttribute(AUTO_EXPANSION_CONTEXT_KEY, NO);
    }

    private void setTicked(Trace t, TreeNode tn) {
        Object o = tn.getObject();
        if (o != null && o instanceof MQExtObject) {
            MQExtObject e = (MQExtObject)o;
            WMQContextStore.setExtObjectTicked(t, e, true);
        }
        if (tn.hasChildren()) {
            TreeNode[] nodes = tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                this.setTicked(t, nodes[k]);
                ++k;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        Trace t = Trace.getDefault();
        String autoExpand = "";
        try {
            autoExpand = configuration.getAttribute(AUTO_EXPANSION_CONTEXT_KEY, "");
        }
        catch (CoreException coreException) {}
        if (autoExpand.equals(YES)) {
            this.expandSelection.setSelection(true);
        } else {
            this.expandSelection.setSelection(false);
        }
        this.treeViewer.setCheckedElements(new Object[0]);
        ArrayList selectContexts = null;
        try {
            selectContexts = (ArrayList)configuration.getAttribute(CONTEXTS_KEY, new ArrayList());
        }
        catch (CoreException coreException) {}
        if (autoExpand.equals(YES)) {
            try {
                ArrayList subcats = (ArrayList)configuration.getAttribute(CONTEXTS_GROUP_KEY, new ArrayList());
                for (String key : subcats) {
                    WMQContextGroup c = WMQContextStore.getContextGroup(t, key);
                    if (c == null) continue;
                    t.data(66, "ContextObjectsTab.initializeFrom", 300, "Auto-Expanding " + c);
                    this.treeViewer.setChecked((Object)c, true);
                    this.treeViewer.setSubtreeChecked((Object)c, true);
                }
            }
            catch (CoreException coreException) {}
        }
        WMQContextStore.setAllExtObjectsUnticked(t);
        if (selectContexts != null) {
            for (String contextId : selectContexts) {
                MQExtObject o = WMQContextStore.getExtObject(t, contextId);
                if (o == null) continue;
                WMQContextStore.setExtObjectTicked(t, o, true);
                this.treeViewer.setChecked((Object)o, true);
            }
        }
    }

    public void dispose() {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Trace t = Trace.getDefault();
        ArrayList<String> list = new ArrayList<String>();
        Object[] objs = this.treeViewer.getCheckedElements();
        int k = 0;
        while (k < objs.length) {
            if (objs[k] instanceof MQExtObject) {
                MQExtObject o = (MQExtObject)objs[k];
                String name = TestsPlugin.generateObjectName(t, o);
                list.add(name);
            }
            ++k;
        }
        ArrayList<String> selectedGroups = new ArrayList<String>();
        Object[] items = this.treeViewer.getCheckedElements();
        int k2 = 0;
        while (k2 < items.length) {
            WMQContextGroup group;
            if (items[k2] instanceof WMQContextGroup && !this.treeViewer.getGrayed((Object)(group = (WMQContextGroup)items[k2]))) {
                selectedGroups.add(group.getGroupId());
                t.data(66, "ContextObjectsTab.performApply", 300, "Added " + group + " for future auto expand");
            }
            ++k2;
        }
        configuration.setAttribute(CONTEXTS_GROUP_KEY, selectedGroups);
        configuration.setAttribute(CONTEXTS_KEY, list);
        String autoExpand = "";
        autoExpand = this.expandSelection.getSelection() ? YES : NO;
        configuration.setAttribute(AUTO_EXPANSION_CONTEXT_KEY, autoExpand);
    }

    public String getErrorMessage() {
        return null;
    }

    public String getMessage() {
        return Messages.getString(Trace.getDefault(), "ContextObjectsTab.contextObjectsBannerText");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public boolean canSave() {
        return true;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.myDialog = dialog;
    }

    public void launched(ILaunch launch) {
    }

    public String getName() {
        return Messages.getString(Trace.getDefault(), "ContextObjectsTab.contextObjects");
    }

    public Image getImage() {
        return Icons.getImage(Trace.getDefault(), Icons.CONTEXT);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

