/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.launch;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class ConfigurationManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/launch/ConfigurationManager.java";

    public static WMQTest[] getTests(Trace t, ILaunchConfiguration config) {
        WMQTest[] wmqtests = null;
        if (config != null) {
            ArrayList tests;
            block6: {
                tests = new ArrayList();
                if (Trace.isTracing) {
                    String configName = "";
                    if (config.getName() != null) {
                        configName = config.getName();
                    }
                    t.data(66, "ConfigurationManager.getTests", 300, "finding test for config " + configName);
                }
                try {
                    tests = (ArrayList)config.getAttribute("enabledTests", new ArrayList());
                }
                catch (CoreException coreException) {
                    if (!Trace.isTracing) break block6;
                    t.data(66, "ConfigurationManager.getTests", 300, "exception getting attributes, returning noting");
                }
            }
            wmqtests = new WMQTest[tests.size()];
            int k = 0;
            while (k < tests.size()) {
                WMQTest tst;
                wmqtests[k] = tst = WMQCategoryStore.getTest(t, (String)tests.get(k));
                ++k;
            }
        }
        return wmqtests;
    }

    public static ArrayList<String> getTestsArrayList(Trace t, ILaunchConfiguration config) {
        ArrayList tests;
        block2: {
            tests = new ArrayList();
            try {
                tests = (ArrayList)config.getAttribute("enabledTests", new ArrayList());
            }
            catch (CoreException coreException) {
                if (!Trace.isTracing) break block2;
                t.data(66, "ConfigurationManager.getTestsArrayList", 300, "exception getting attribute, returning nothing");
            }
        }
        return tests;
    }

    public static MQExtObject[] getContextObjects(Trace t, ILaunchConfiguration config) {
        ArrayList objects = new ArrayList();
        MQExtObject[] extobjects = null;
        if (config != null) {
            block4: {
                try {
                    objects = (ArrayList)config.getAttribute("enabledContexts", new ArrayList());
                }
                catch (CoreException coreException) {
                    if (!Trace.isTracing) break block4;
                    t.data(66, "ConfigurationManager.getContextObjects", 300, "Exception getting attribute, returning nothing");
                }
            }
            extobjects = new MQExtObject[objects.size()];
            int k = 0;
            while (k < objects.size()) {
                MQExtObject ex;
                extobjects[k] = ex = WMQContextStore.getExtObject(t, (String)objects.get(k));
                ++k;
            }
        }
        return extobjects;
    }

    public static ArrayList<String> getContextObjectsArrayList(Trace t, ILaunchConfiguration config) {
        ArrayList objects;
        block2: {
            objects = new ArrayList();
            try {
                objects = (ArrayList)config.getAttribute("enabledContexts", new ArrayList());
            }
            catch (CoreException coreException) {
                if (!Trace.isTracing) break block2;
                t.data(66, "ConfigurationManager.getContextObjectsArrayList", 300, "Exception getting attribute, returning nothing");
            }
        }
        return objects;
    }

    public static ILaunchConfiguration getConfiguration(Trace t, IMarker marker) {
        ILaunchConfiguration config = null;
        int i = 0;
        i = marker.getAttribute("config", 0);
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.ibm.mq.explorer.tests.internal.launchConfigurationType");
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int k = 0;
            while (k < configs.length) {
                if (configs[k].hashCode() == i) {
                    config = configs[k];
                    break;
                }
                ++k;
            }
        }
        catch (CoreException coreException) {
            t.FFST(66, "ConfigurationManager.getConfiguration", 0, 50036, "Could not get configuration out of Marker");
        }
        return config;
    }

    public static boolean compareConfig(Trace t, ILaunchConfigurationWorkingCopy configuration, ILaunchConfiguration conf) throws CoreException {
        String configurationExpand;
        boolean ret = true;
        String confExpand = conf.getAttribute("autoExpandContext", "no");
        if (!confExpand.equals(configurationExpand = configuration.getAttribute("autoExpandContext", "no"))) {
            ret = false;
            if (Trace.isTracing) {
                t.data(66, "ConfigurationManager.compareConfig", 300, "auto expand context state is different");
            }
        } else if (Trace.isTracing) {
            t.data(66, "ConfigurationManager.compareConfig", 300, "auto expand context state is the same");
        }
        if (ret) {
            confExpand = conf.getAttribute("autoExpandTests", "no");
            if (!confExpand.equals(configurationExpand = configuration.getAttribute("autoExpandTests", "no"))) {
                ret = false;
                if (Trace.isTracing) {
                    t.data(66, "ConfigurationManager.compareConfig", 300, "auto expand test state is different");
                }
            } else if (Trace.isTracing) {
                t.data(66, "ConfigurationManager.compareConfig", 300, "auto expand test state is the same");
            }
        }
        if (ret) {
            ArrayList<String> configurationTsts;
            ArrayList<String> confTsts = ConfigurationManager.getTestsArrayList(t, conf);
            if (confTsts.containsAll(configurationTsts = ConfigurationManager.getTestsArrayList(t, (ILaunchConfiguration)configuration)) && configurationTsts.containsAll(confTsts)) {
                if (Trace.isTracing) {
                    t.data(66, "ConfigurationManager.compareConfig", 300, "list of tests is identical");
                }
            } else {
                ret = false;
                if (Trace.isTracing) {
                    t.data(66, "ConfigurationManager.compareConfig", 300, "list of tests is different");
                }
            }
        }
        if (ret) {
            ArrayList<String> configurationContext;
            ArrayList<String> confContext = ConfigurationManager.getContextObjectsArrayList(t, conf);
            if (confContext.containsAll(configurationContext = ConfigurationManager.getContextObjectsArrayList(t, (ILaunchConfiguration)configuration)) && configurationContext.containsAll(confContext)) {
                if (Trace.isTracing) {
                    t.data(66, "ConfigurationManager.compareConfig", 300, "list of contexts is identical");
                }
            } else {
                ret = false;
                if (Trace.isTracing) {
                    t.data(66, "ConfigurationManager.compareConfig", 300, "list of contexts is different");
                }
            }
        }
        return ret;
    }
}

