/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.launch.ConfigurationManager;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategory;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQSubCategory;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;

public class WMQTestEngine {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/WMQTestEngine.java";
    private static final String TESTRUNTHREADS = "com.ibm.mq.explorer.tests.testrun.thread";
    private static final String TESTRUNENGINE = "com.ibm.mq.explorer.tests.testengine.thread";
    private static final int BATCH_SIZE = 4;
    private static final int TIMEOUT = 3000;
    private static final int LONGTIMEOUT = 5000;
    private static boolean testManagerInUse = false;
    private Object[] enabledtests = new Object[0];
    private int nxtTestNum = 0;
    private int remaining_tests = 0;
    private int tests_to_run = 0;
    private int active_threads = 0;
    private IProgressMonitor mainmonitor = null;
    private MQExtObject[] contextObjects = null;
    private TreeNode selectedTreeNode = null;
    private ILaunchConfiguration configuration = null;

    public WMQTestEngine(Trace t, ILaunchConfiguration config, TreeNode node) {
        this.configuration = config;
        this.enabledtests = ConfigurationManager.getTests(t, this.configuration);
        this.contextObjects = ConfigurationManager.getContextObjects(t, this.configuration);
        this.selectedTreeNode = node;
        if (Trace.isTracing) {
            t.data(66, "WMQTestEngine.WMQTestEngine", 300, "Creating test engine..");
            t.data(66, "WMQTestEngine.WMQTestEngine", 300, "context tree node: " + (node == null ? "null" : node.getTreeNodeId()));
            t.data(66, "WMQTestEngine.WMQTestEngine", 300, "context objects:");
            int k = 0;
            while (k < this.contextObjects.length) {
                t.data(66, "WMQTestEngine.WMQTestEngine", 300, " [" + this.contextObjects[k] + "] ");
                ++k;
            }
            t.data(66, "WMQTestEngine.WMQTestEngine", 300, "enabled tests:");
            k = 0;
            while (k < this.enabledtests.length) {
                t.data(66, "WMQTestEngine.WMQTestEngine", 300, " [" + this.enabledtests[k] + "] ");
                ++k;
            }
        }
    }

    public WMQTestEngine(Trace t, ILaunchConfiguration config, Object[] override, TreeNode node) {
        this(t, config, node);
        this.enabledtests = override;
        if (Trace.isTracing) {
            t.data(66, "WMQTestEngine.WMQTestEngine", 300, "Tests overridden to only run: ");
            int k = 0;
            while (k < this.enabledtests.length) {
                t.data(66, "WMQTestEngine.WMQTestEngine", 300, " [" + this.enabledtests[k] + "] ");
                ++k;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        final Trace t = Trace.getDefault();
        WMQTestEngine wMQTestEngine = this;
        synchronized (wMQTestEngine) {
            if (testManagerInUse) {
                Shell activeShell;
                if (Trace.isTracing) {
                    t.data(66, "WMQTestEngine.run", 300, "test manager in use - aborting");
                }
                if ((activeShell = UiPlugin.getShell()) != null) {
                    UiPlugin.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String msg = CommonServices.getSystemMessage((String)"AMQ4850");
                            MessageBox.showMessageFailure((Trace)t, (Shell)activeShell, (String)msg, (String)"AMQ4850");
                        }
                    });
                }
                return;
            }
            WMQTestEngine.abortEngine(t);
            this.tests_to_run = this.enabledtests.length;
            this.remaining_tests = this.enabledtests.length;
            this.active_threads = 0;
            this.nxtTestNum = 0;
            if (this.tests_to_run == 0) {
                final Shell activeShell = UiPlugin.getShell();
                if (activeShell != null) {
                    UiPlugin.getDisplay().asyncExec(new Runnable(){
                        final String msgTxt = CommonServices.getSystemMessage((String)"AMQ4851");

                        @Override
                        public void run() {
                            MessageBox.showMessageFailure((Trace)t, (Shell)activeShell, (String)this.msgTxt, (String)"AMQ4851");
                        }
                    });
                }
                return;
            }
            testManagerInUse = true;
        }
        Job testEngineThread = new Job(Messages.getString(t, "WMQTestEngine.testRunJobTitle")){

            public synchronized IStatus run(IProgressMonitor monitor) {
                if (Trace.isTracing) {
                    t.data(66, "WMQTestEngine.run", 300, "test engine starting");
                }
                WMQTestEngine.this.mainmonitor = monitor;
                monitor.beginTask(Messages.getString(t, "WMQTestEngine.runningCheck"), WMQTestEngine.this.tests_to_run + 1);
                this.setProperty(IProgressConstants.ICON_PROPERTY, Icons.getDescriptor(t, Icons.TEST_RESULTS));
                monitor.subTask(Messages.getString(t, "WMQTestEngine.preparingProblemsView"));
                TestsPlugin.openProblemView(t);
                monitor.worked(1);
                monitor.subTask(Messages.getString(t, "WMQTestEngine.remainingTests", new String[]{"" + (WMQTestEngine.this.tests_to_run - WMQTestEngine.this.remaining_tests), "" + WMQTestEngine.this.tests_to_run}));
                boolean testsStillToRun = true;
                if (Trace.isTracing) {
                    t.data(66, "WMQTestEngine.run", 300, "creating 4 test threads");
                }
                int i = 0;
                while (i < 4) {
                    if (WMQTestEngine.this.tests_to_run > i) {
                        Job activethread = WMQTestEngine.this.createNewTestThread(t, this);
                        activethread.schedule();
                        WMQTestEngine wMQTestEngine = WMQTestEngine.this;
                        wMQTestEngine.active_threads = wMQTestEngine.active_threads + 1;
                    }
                    ++i;
                }
                while (testsStillToRun) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        t.data(66, "WMQTestEngine.run", 900, "Unexpected exception received by test run engine: " + e.getMessage());
                    }
                    if (Trace.isTracing) {
                        t.data(66, "WMQTestEngine.run", 300, "tests still to run: " + testsStillToRun);
                    }
                    testsStillToRun = WMQTestEngine.this.remaining_tests > 0 && WMQTestEngine.this.nxtTestNum < WMQTestEngine.this.tests_to_run && !WMQTestEngine.this.mainmonitor.isCanceled();
                    while (testsStillToRun && WMQTestEngine.this.active_threads < 4) {
                        Job nexttestthread = WMQTestEngine.this.createNewTestThread(t, this);
                        nexttestthread.schedule();
                        WMQTestEngine wMQTestEngine = WMQTestEngine.this;
                        wMQTestEngine.active_threads = wMQTestEngine.active_threads + 1;
                    }
                }
                while (WMQTestEngine.this.remaining_tests > 0 && !WMQTestEngine.this.mainmonitor.isCanceled()) {
                    try {
                        ((Object)((Object)this)).wait(3000L);
                    }
                    catch (InterruptedException e) {
                        t.data(66, "WMQTestEngine.run", 900, "Unexpected exception received by test run engine: " + e.getMessage());
                    }
                }
                IJobManager jobmanager = Job.getJobManager();
                jobmanager.sleep((Object)WMQTestEngine.TESTRUNTHREADS);
                jobmanager.cancel((Object)WMQTestEngine.TESTRUNTHREADS);
                monitor.done();
                testManagerInUse = false;
                final Shell activeShell = UiPlugin.getShell();
                if (activeShell != null) {
                    if (WMQTestEngine.this.isCancelled()) {
                        UiPlugin.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox.showSystemMessageById((Trace)t, (Shell)activeShell, (String)"AMQ4855", null, (String)"AMQ4855");
                            }
                        });
                    } else {
                        UiPlugin.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox.showSystemMessageById((Trace)t, (Shell)activeShell, (String)"AMQ4854", (String[])new String[]{"" + WMQTestEngine.this.tests_to_run}, (String)"AMQ4854");
                            }
                        });
                    }
                }
                if (TestsPlugin.getProblemView() != null) {
                    TestsPlugin.getProblemView().refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(WMQTestEngine.TESTRUNENGINE);
            }
        };
        testEngineThread.setUser(true);
        testEngineThread.schedule();
    }

    public void processTestCompletion(WMQTestResult result, WMQTest test) {
        this.processTestResult(result, test, true);
    }

    public void processTestResult(WMQTestResult result, WMQTest test) {
        this.processTestResult(result, test, false);
    }

    private void processTestResult(final WMQTestResult result, final WMQTest test, final boolean isCompletion) {
        block3: {
            final Trace t = Trace.getDefault();
            IFolder qmgr = TestsPlugin.getDefault().getQmgr(t, result.getObjectName());
            final IFile obj = TestsPlugin.getDefault().getObjectType(t, qmgr, result.getObjectType());
            IWorkspaceRunnable op = new IWorkspaceRunnable(){

                public void run(IProgressMonitor mon) throws CoreException {
                    String tnid = "";
                    if (WMQTestEngine.this.selectedTreeNode != null) {
                        tnid = WMQTestEngine.this.selectedTreeNode.getTreeNodeId();
                    }
                    IMarker marker = obj.createMarker("com.ibm.mq.explorer.tests.mqmarker");
                    marker.setAttribute("severity", result.getSeverity());
                    marker.setAttribute("message", (Object)result.getDescription());
                    marker.setAttribute("furtherinfo", (Object)test.getFurtherInfoPath());
                    marker.setAttribute("qmgrname", (Object)result.getObjectName());
                    marker.setAttribute("testname", (Object)test.getTestName());
                    marker.setAttribute("testid", (Object)test.getTestId());
                    marker.setAttribute("treenodeid", (Object)tnid);
                    marker.setAttribute("config", WMQTestEngine.this.configuration.hashCode());
                    marker.setAttribute("testcomplete", isCompletion);
                    WMQSubCategory sub = test.getTestSubCategory();
                    WMQCategory cat = WMQCategoryStore.getCategoryContainingSub(t, sub.getId());
                    String catname = Messages.getString(t, "MQMarkerCategoryField", new String[]{cat.getName(), sub.getName()});
                    marker.setAttribute("formattedcategory", (Object)catname);
                }
            };
            try {
                if (obj != null) {
                    obj.getWorkspace().run(op, null, 1, null);
                }
            }
            catch (CoreException exc) {
                t.FFST(66, "WMQTestEngine.processTestResult", 0, 0, 0, 0, "Error encountered while creating problem markers", exc.getMessage(), "");
                if (!Trace.isTracing) break block3;
                t.data(66, "WMQTestEngine.processTestResult", 300, "failed to create marker " + exc.getMessage());
            }
        }
    }

    public static void clearMQMarkers(Trace t, WMQTest test) {
        block4: {
            TestsPlugin plugin = TestsPlugin.getDefault();
            IProject runtimeproj = plugin.getProject();
            try {
                IMarker[] markers = runtimeproj.findMarkers("com.ibm.mq.explorer.tests.mqmarker", true, 2);
                String testId = test.getTestId();
                int i = 0;
                while (i < markers.length) {
                    IMarker nxtMarker = markers[i];
                    String markerTestId = (String)nxtMarker.getAttribute("testid");
                    if (markerTestId.equals(testId)) {
                        nxtMarker.delete();
                    }
                    ++i;
                }
            }
            catch (CoreException exc) {
                t.FFST(66, "WMQTestEngine.clearMQMarkers", 0, 50014, "failed to get marker " + exc.getMessage());
                if (!Trace.isTracing) break block4;
                t.data(66, "WMQTestEngine.clearMQMarkers", 300, "failed to get marker " + exc.getMessage());
            }
        }
    }

    public static void resetMQMarkers(Trace t) {
        block2: {
            try {
                TestsPlugin.getDefault().getProject().deleteMarkers("com.ibm.mq.explorer.tests.mqmarker", true, 2);
            }
            catch (CoreException exc) {
                t.FFST(66, "WMQTestEngine.resetMQMarkers", 0, 0, 0, 0, "Error while deleting WMQ Explorer Tests markers from Problems View", exc.getMessage(), "");
                if (!Trace.isTracing) break block2;
                t.data(66, "WMQTestEngine.resetMQMarkers", 300, "failed to delete marker " + exc.getMessage());
            }
        }
    }

    public synchronized void returnResult(WMQTestResult[] results, WMQTest test) {
        int j = 0;
        while (j < results.length) {
            this.processTestResult(results[j], test);
            ++j;
        }
    }

    Job createNewTestThread(final Trace t, final Job waitingparent) {
        Job nxtJob = new Job(Messages.getString(t, "WMQTestEngine.checkTestTitle")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus run(IProgressMonitor monitor) {
                boolean testsStillToRun = false;
                WMQTest nxtTest = null;
                Job job = waitingparent;
                synchronized (job) {
                    boolean bl = testsStillToRun = WMQTestEngine.this.remaining_tests > 0 && WMQTestEngine.this.nxtTestNum < WMQTestEngine.this.tests_to_run && !WMQTestEngine.this.mainmonitor.isCanceled();
                    if (testsStillToRun) {
                        nxtTest = (WMQTest)((Object)WMQTestEngine.this.enabledtests[WMQTestEngine.this.nxtTestNum]);
                        WMQTestEngine wMQTestEngine = WMQTestEngine.this;
                        wMQTestEngine.nxtTestNum = wMQTestEngine.nxtTestNum + 1;
                        this.setName(String.valueOf(Messages.getString(t, "WMQTestEngine.checkTitle")) + nxtTest.getTestName());
                        WMQSubCategory parentset = nxtTest.getTestSubCategory();
                        String type = parentset.getIcon();
                        this.setProperty(IProgressConstants.ICON_PROPERTY, Icons.getDescriptor(t, type));
                    }
                }
                if (testsStillToRun && nxtTest != null) {
                    MQExtObject[] testObjs;
                    block23: {
                        try {
                            nxtTest.runApplicableTests(WMQTestEngine.this, monitor, WMQTestEngine.this.contextObjects, WMQTestEngine.this.selectedTreeNode);
                        }
                        catch (Exception e) {
                            String idoftest = nxtTest.getTestId();
                            if (idoftest.length() > 50) {
                                idoftest = idoftest.substring(idoftest.length() - 50, idoftest.length());
                            }
                            t.FFST(66, "WMQTestEngine.createNewTestThread.run", 0, 0, 0, 0, "Error encountered running test", idoftest, e.getMessage());
                            t.FFST(66, "WMQTestEngine.createNewTestThread.run", 1, 0, e.getMessage());
                            nxtTest.testComplete(new WMQTestResult[0]);
                        }
                        Object e = nxtTest.runningMonitor;
                        synchronized (e) {
                            while (true) {
                                while (true) {
                                    if (nxtTest.isTestComplete() || WMQTestEngine.this.isCancelled()) {
                                        break block23;
                                    }
                                    try {
                                        nxtTest.runningMonitor.wait(5000L);
                                    }
                                    catch (InterruptedException e2) {
                                        t.FFST(66, "WMQTestEngine.createNewTestThread.run", 0, 0, 0, 0, "Unexpected exception received by test thread", e2.getMessage(), nxtTest.getTestId());
                                    }
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    MQExtObject[] mQExtObjectArray = testObjs = nxtTest.getApplicableObjects(WMQTestEngine.this.contextObjects);
                    int n = testObjs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MQExtObject extObj = mQExtObjectArray[n2];
                        if (extObj != null) {
                            String objName = extObj.getName();
                            WMQTestResult result = new WMQTestResult(0, Messages.getString(t, "WMQTestEngine.testCompleted", new String[]{"'" + nxtTest.getTestName() + "'"}), objName, nxtTest.getTestSubCategory());
                            WMQTestEngine.this.processTestCompletion(result, nxtTest);
                        }
                        ++n2;
                    }
                    WMQTestEngine wMQTestEngine = WMQTestEngine.this;
                    wMQTestEngine.remaining_tests = wMQTestEngine.remaining_tests - 1;
                    if (WMQTestEngine.this.remaining_tests <= WMQTestEngine.this.tests_to_run && WMQTestEngine.this.remaining_tests >= 0) {
                        WMQTestEngine.this.mainmonitor.subTask(Messages.getString(t, "WMQTestEngine.remainingTests", new String[]{"" + (WMQTestEngine.this.tests_to_run - WMQTestEngine.this.remaining_tests), "" + WMQTestEngine.this.tests_to_run}));
                    } else {
                        WMQTestEngine.this.mainmonitor.subTask(Messages.getString(t, "WMQTestEngine.testEnding"));
                    }
                    WMQTestEngine.this.mainmonitor.worked(1);
                }
                job = waitingparent;
                synchronized (job) {
                    WMQTestEngine wMQTestEngine = WMQTestEngine.this;
                    wMQTestEngine.active_threads = wMQTestEngine.active_threads - 1;
                    waitingparent.notify();
                    return Status.OK_STATUS;
                }
            }

            public boolean belongsTo(Object family) {
                return family.equals(WMQTestEngine.TESTRUNTHREADS);
            }
        };
        return nxtJob;
    }

    public boolean isCancelled() {
        if (this.mainmonitor == null) {
            return true;
        }
        return this.mainmonitor.isCanceled();
    }

    public static void abortEngine(Trace t) {
        IJobManager manager = Job.getJobManager();
        manager.sleep((Object)TESTRUNENGINE);
        manager.cancel((Object)TESTRUNENGINE);
        manager.sleep((Object)TESTRUNTHREADS);
        manager.cancel((Object)TESTRUNTHREADS);
    }
}

