/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.FilterState;
import com.ibm.mq.explorer.tests.internal.actions.FilterWMQTestResultsAction;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import java.util.ArrayList;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class TestsImportExportFilter
implements IExplorerRuntimeImportExport {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/TestsImportExportFilter.java";
    public static final String SUBCATEGORY_ID_TEST_FILTERS = "com.ibm.mq.explorer.tests.subcategory.filters";
    protected static final String TESTFILTERS_NODE = "TestFilters";

    public boolean importData(String categoryId, String subcategoryId, IMemento rootRead) {
        IMemento child;
        Trace t = Trace.getDefault();
        boolean result = false;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.filters.schemes") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_TEST_FILTERS) == 0 && (child = this.getTestFiltersNode(t, rootRead)) != null) {
            String dcontains = child.getString("filter_doesnt_contain");
            String isError = child.getString("filter_error");
            String isInfo = child.getString("filter_info");
            String isSeverity = child.getString("filter_severity");
            String isWarning = child.getString("filter_warning");
            String name = child.getString("filter_name");
            String isCompleteString = child.getString("filter_complete");
            boolean isComplete = isCompleteString == null ? TestsPlugin.getDefault().getPreferenceStore().getBoolean("filter_complete") : Boolean.parseBoolean(isCompleteString);
            FilterState filters = new FilterState(Boolean.parseBoolean(isSeverity), Boolean.parseBoolean(isError), Boolean.parseBoolean(isWarning), Boolean.parseBoolean(isInfo), name, Boolean.parseBoolean(dcontains), isComplete);
            FilterWMQTestResultsAction.saveFiltersToPreferences(filters);
            result = true;
        }
        return result;
    }

    public IMemento exportData(String categoryId, String subcategoryId) {
        Trace t = Trace.getDefault();
        XMLMemento rootWrite = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.filters.schemes") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_TEST_FILTERS) == 0) {
            rootWrite = XMLMemento.createWriteRoot((String)"ROOTNODE");
            FilterState filters = FilterWMQTestResultsAction.loadFiltersFromPreferences();
            IMemento msgWrite = TestsImportExportFilter.openChild(t, (IMemento)rootWrite, TESTFILTERS_NODE);
            boolean boolValue = filters.isDoesntContain();
            msgWrite.putString("filter_doesnt_contain", String.valueOf(boolValue));
            boolValue = filters.isErrorFilterEnabled();
            msgWrite.putString("filter_error", String.valueOf(boolValue));
            boolValue = filters.isInfoFilterEnabled();
            msgWrite.putString("filter_info", String.valueOf(boolValue));
            boolValue = filters.isSeverityFilterEnabled();
            msgWrite.putString("filter_severity", String.valueOf(boolValue));
            boolValue = filters.isWarningFilterEnabled();
            msgWrite.putString("filter_warning", String.valueOf(boolValue));
            String stringValue = filters.getNameFilter();
            msgWrite.putString("filter_name", stringValue);
            boolValue = filters.isCompleteFilterEnabled();
            msgWrite.putString("filter_complete", String.valueOf(boolValue));
        }
        return rootWrite;
    }

    protected static IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    private IMemento getTestFiltersNode(Trace t, IMemento rootRead) {
        IMemento testFiltersNode = rootRead.getChild(TESTFILTERS_NODE);
        if (testFiltersNode == null) {
            String[] atts = rootRead.getAttributeKeys();
            ArrayList<String> attsList = new ArrayList<String>();
            int i = 0;
            while (i < atts.length) {
                attsList.add(atts[i]);
                ++i;
            }
            if (attsList.contains("filter_doesnt_contain") && attsList.contains("filter_error") && attsList.contains("filter_info") && attsList.contains("filter_error") && attsList.contains("filter_severity") && attsList.contains("filter_warning") && attsList.contains("filter_name")) {
                testFiltersNode = rootRead;
            }
        }
        return testFiltersNode;
    }

    public boolean persistData() {
        return false;
    }

    public boolean isDestructiveImport() {
        return true;
    }
}

