/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class TestsImportExport
implements IExplorerRuntimeImportExport {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/TestsImportExport.java";
    public static final String SUBCATEGORY_ID_PREFS_TESTS = "com.ibm.mq.explorer.tests.subcategory.prefs";
    protected static final String ROOT_NODE = "TestPreferences";
    private static final String TEST_NODE = "Test";

    public boolean importData(String categoryId, String subcategoryId, IMemento rootRead) {
        IMemento child;
        boolean result = false;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_PREFS_TESTS) == 0 && (child = rootRead.getChild(TEST_NODE)) != null) {
            String value = child.getString("include_hidden_qmgrs");
            PreferenceStoreManager.setIncludeHiddenQmgrsPreference(Boolean.parseBoolean(value));
            value = child.getString("include_system_objs");
            PreferenceStoreManager.setIncludeSysObjsPreference(Boolean.parseBoolean(value));
            result = true;
        }
        return result;
    }

    public boolean importData(String categoryId, String subcategoryId, InputStream inputStream) {
        Trace t = Trace.getDefault();
        boolean result = false;
        try {
            StringBuffer buf = new StringBuffer();
            InputStreamReader isr = new InputStreamReader(inputStream);
            int letter = isr.read();
            while (letter != -1) {
                buf.append((char)letter);
                letter = isr.read();
            }
            if (Trace.isTracing) {
                t.data(66, "TestsImportExport.importData", 300, "importing tests settings string: " + buf.toString());
            }
            result = PreferenceStoreManager.setPreferencesAsString(buf.toString());
        }
        catch (IOException e) {
            t.FFST(66, "TestsImportExport.importData", 0, 50028, e.getMessage());
        }
        return result;
    }

    public IMemento exportData(String categoryId, String subcategoryId) {
        Trace t = Trace.getDefault();
        XMLMemento rootWrite = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_PREFS_TESTS) == 0) {
            rootWrite = XMLMemento.createWriteRoot((String)ROOT_NODE);
            IMemento msgWrite = TestsImportExport.openChild(t, (IMemento)rootWrite, TEST_NODE);
            boolean value = PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
            msgWrite.putString("include_hidden_qmgrs", String.valueOf(value));
            value = PreferenceStoreManager.getIncludeSysObjsPreference();
            msgWrite.putString("include_system_objs", String.valueOf(value));
        }
        return rootWrite;
    }

    protected static IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    public boolean persistData() {
        return true;
    }

    public boolean isDestructiveImport() {
        return true;
    }
}

