/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.ui.BrowserHelpDialog;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class OpenBrowserAction
implements Runnable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/OpenBrowserAction.java";
    private String url = "";
    private String name = "";

    public OpenBrowserAction(WMQTest test) {
        this.url = test.getFurtherInfoPath();
        this.name = test.getTestName();
    }

    public OpenBrowserAction(Trace t, String testname, String testurl) {
        this.url = testurl;
        this.name = testname;
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        if (this.url != null) {
            URL actualURL;
            block7: {
                actualURL = null;
                try {
                    actualURL = new URL(this.url);
                    if (actualURL.getProtocol().equals("jar")) {
                        actualURL = this.handleJarProtocol(t, actualURL);
                    }
                }
                catch (MalformedURLException e) {
                    if (!Trace.isTracing) break block7;
                    t.data(66, "OpenBrowserAction.run", 900, "MalformedURLException for " + this.url + ": " + e.getMessage());
                }
            }
            if (actualURL != null) {
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(72, "com.ibm.mq.explorer.tests", String.valueOf(Messages.getString(t, "OpenBrowserAction.browserTitle")) + this.name, "");
                    browser.openURL(actualURL);
                }
                catch (PartInitException partInitException) {
                    this.noBrowser(t, actualURL);
                }
            }
        }
    }

    private void noBrowser(Trace t, URL pageURL) {
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        shell.setLayout((Layout)new FillLayout());
        shell.setText(String.valueOf(Messages.getString(t, "OpenBrowserAction.browserTitle")) + this.name);
        shell.setImage(Icons.get((String)Icons.iconkeyExplorerSmall));
        if (BrowserHelpDialog.displayErrorIfFail) {
            BrowserHelpDialog helpdialog = new BrowserHelpDialog(shell);
            helpdialog.setBlockOnOpen(true);
            helpdialog.create();
            helpdialog.open();
        }
        UiPlugin.getHelpSystem().displayHelpResource(pageURL.toString());
    }

    private URL handleJarProtocol(Trace t, URL jarurl) {
        URL localurl = jarurl;
        try {
            JarURLConnection connection = (JarURLConnection)jarurl.openConnection();
            JarFile jar = connection.getJarFile();
            String jarName = new File(jar.getName()).getName();
            File base = new File(TestsPlugin.getDefault().getStateLocation().toFile(), jarName);
            if (!base.exists()) {
                if (Trace.isTracing) {
                    t.data(66, "OpenBrowserAction.handleJarProtocol", 300, "extracting JAR file: " + jarurl);
                }
                this.extractJarFile(jar, base);
            }
            File extracted = new File(base, connection.getJarEntry().getName());
            localurl = extracted.toURL();
        }
        catch (IOException e) {
            t.data(66, "OpenBrowserAction.handleJarProtocol", 900, "IOException processing jar URL: " + e.getMessage());
        }
        catch (SecurityException e) {
            t.data(66, "OpenBrowserAction.handleJarProtocol", 900, "SecurityException processing jar URL: " + e.getMessage());
        }
        return localurl;
    }

    private void extractJarFile(JarFile jar, File dir) throws IOException {
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> em = jar.entries();
        while (em.hasMoreElements()) {
            JarEntry entry = em.nextElement();
            if (entry.isDirectory()) continue;
            File dest = new File(dir, entry.getName());
            dest.getParentFile().mkdirs();
            BufferedInputStream is = new BufferedInputStream(jar.getInputStream(entry));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
            int len = 0;
            while ((len = is.read(buffer, 0, buffer.length)) != -1) {
                os.write(buffer, 0, len);
            }
            os.close();
            is.close();
        }
    }
}

