/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.FilterState;
import com.ibm.mq.explorer.tests.internal.problems.TestsProblemView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FilterWMQTestResultsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/FilterWMQTestResultsAction.java";
    private Shell parentShell;
    private FilterState filters = null;
    public static final String FILTER_SEVERITY_PREFERENCE = "filter_severity";
    public static final String FILTER_ERROR_PREFERENCE = "filter_error";
    public static final String FILTER_WARNING_PREFERENCE = "filter_warning";
    public static final String FILTER_INFO_PREFERENCE = "filter_info";
    public static final String FILTER_NAME_PREFERENCE = "filter_name";
    public static final String FILTER_DOESNT_CONTAIN_PREFERENCE = "filter_doesnt_contain";
    public static final String FILTER_COMPLETE_PREFERENCE = "filter_complete";

    public FilterWMQTestResultsAction(Trace t, TestsProblemView viewpart) {
        this.parentShell = viewpart.getSite().getShell();
        String msg = Messages.getString(t, "FilterWMQTestResultsAction.filterActionText");
        this.setText(msg);
        this.setToolTipText(msg);
    }

    public FilterWMQTestResultsAction() {
    }

    public void run() {
        FilterDialog dialog = new FilterDialog(this.parentShell);
        if (dialog.open() == 0) {
            this.filters = dialog.getFilterSettings();
            if (TestsPlugin.getProblemView() != null) {
                TestsPlugin.getProblemView().refresh();
            }
        }
    }

    public FilterState getFilterState() {
        if (this.filters == null) {
            this.filters = FilterWMQTestResultsAction.loadFiltersFromPreferences();
        }
        return this.filters;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow win) {
    }

    public static void saveFiltersToPreferences(FilterState filters) {
        IPreferenceStore store = TestsPlugin.getDefault().getPreferenceStore();
        store.setValue(FILTER_SEVERITY_PREFERENCE, filters.isSeverityFilterEnabled());
        store.setValue(FILTER_ERROR_PREFERENCE, filters.isErrorFilterEnabled());
        store.setValue(FILTER_WARNING_PREFERENCE, filters.isWarningFilterEnabled());
        store.setValue(FILTER_INFO_PREFERENCE, filters.isInfoFilterEnabled());
        store.setValue(FILTER_NAME_PREFERENCE, filters.getNameFilter());
        store.setValue(FILTER_DOESNT_CONTAIN_PREFERENCE, filters.isDoesntContain());
        store.setValue(FILTER_COMPLETE_PREFERENCE, filters.isCompleteFilterEnabled());
    }

    public static FilterState loadFiltersFromPreferences() {
        IPreferenceStore store = TestsPlugin.getDefault().getPreferenceStore();
        boolean isSeverity = store.getBoolean(FILTER_SEVERITY_PREFERENCE);
        boolean isError = store.getBoolean(FILTER_ERROR_PREFERENCE);
        boolean isWarning = store.getBoolean(FILTER_WARNING_PREFERENCE);
        boolean isInfo = store.getBoolean(FILTER_INFO_PREFERENCE);
        String name = store.getString(FILTER_NAME_PREFERENCE);
        boolean dcontains = store.getBoolean(FILTER_DOESNT_CONTAIN_PREFERENCE);
        if (!store.contains(FILTER_COMPLETE_PREFERENCE)) {
            store.setDefault(FILTER_COMPLETE_PREFERENCE, true);
        }
        boolean isComplete = store.getBoolean(FILTER_COMPLETE_PREFERENCE);
        return new FilterState(isSeverity, isError, isWarning, isInfo, name, dcontains, isComplete);
    }

    static class FilterDialog
    extends SelectionDialog {
        private static final int CONTROL_WIDTH_HINT = 80;
        private static final int INDENT_FOR_CONTROLS = 16;
        private static final int NUM_COLS = 3;
        private Button severityButton;
        private Button errorButton;
        private Button warningButton;
        private Button infoButton;
        private Text nameField;
        private Combo combo;
        private FilterState filters = FilterWMQTestResultsAction.loadFiltersFromPreferences();

        public FilterDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void configureShell(Shell shell) {
            Trace t = Trace.getDefault();
            this.setTitle(Messages.getString(t, "FilterWMQTestResultsDialog.title"));
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.mq.explorer.tests.infopop.ProblemViewAction_filter");
        }

        public FilterState getFilterSettings() {
            return this.filters;
        }

        protected Control createDialogArea(Composite parent) {
            Trace t = Trace.getDefault();
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Group group = new Group(composite, 0);
            group.setText(Messages.getString(t, "FilterWMQTestResultsDialog.heading"));
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createNameGroup(t, (Composite)group);
            this.createSeverityGroup(t, (Composite)group);
            Label spacer = new Label((Composite)group, 0);
            spacer.setLayoutData((Object)new GridData(4, 4, true, true));
            FilterDialog.applyDialogFont((Control)parent);
            return parent;
        }

        private void createNameGroup(Trace t, Composite parent) {
            Composite nameComposite = new Composite(parent, 0);
            nameComposite.setLayout((Layout)new GridLayout(3, false));
            nameComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label = new Label(nameComposite, 0);
            label.setText(Messages.getString(t, "ProblemView.object"));
            GridData gridData = new GridData();
            gridData.horizontalIndent = 16;
            label.setLayoutData((Object)gridData);
            this.combo = new Combo(nameComposite, 12);
            this.combo.add(Messages.getString(t, "FilterWMQTestResultsDialog.contain"));
            this.combo.add(Messages.getString(t, "FilterWMQTestResultsDialog.notContain"));
            this.combo.select(this.filters.isDoesntContain() ? 1 : 0);
            this.nameField = new Text(nameComposite, 2052);
            this.nameField.setText(this.filters.getNameFilter());
            gridData = new GridData(4, 128, true, false);
            gridData.widthHint = 80;
            this.nameField.setLayoutData((Object)gridData);
        }

        private void createSeverityGroup(Trace t, Composite parent) {
            Composite severityComposite = new Composite(parent, 0);
            severityComposite.setLayout((Layout)new GridLayout(3, true));
            severityComposite.setLayoutData((Object)new GridData(16384, 1, false, false));
            this.severityButton = new Button(severityComposite, 32);
            this.severityButton.setText(Messages.getString(t, "FilterWMQTestResultsDialog.severity"));
            this.severityButton.setSelection(this.filters.isSeverityFilterEnabled());
            this.severityButton.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
            this.errorButton = new Button(severityComposite, 32);
            this.errorButton.setText(Messages.getString(t, "FilterWMQTestResultsDialog.severityError"));
            this.errorButton.setSelection(this.filters.isErrorFilterEnabled());
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 16;
            this.errorButton.setLayoutData((Object)gridData);
            this.warningButton = new Button(severityComposite, 32);
            this.warningButton.setText(Messages.getString(t, "FilterWMQTestResultsDialog.severityWarning"));
            this.warningButton.setSelection(this.filters.isWarningFilterEnabled());
            this.infoButton = new Button(severityComposite, 32);
            this.infoButton.setText(Messages.getString(t, "FilterWMQTestResultsDialog.severityInfo"));
            this.infoButton.setSelection(this.filters.isInfoFilterEnabled());
            if (!this.severityButton.getSelection()) {
                this.errorButton.setEnabled(false);
                this.warningButton.setEnabled(false);
                this.infoButton.setEnabled(false);
            }
            this.severityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (severityButton.getSelection()) {
                        errorButton.setEnabled(true);
                        warningButton.setEnabled(true);
                        infoButton.setEnabled(true);
                    } else {
                        errorButton.setEnabled(false);
                        warningButton.setEnabled(false);
                        infoButton.setEnabled(false);
                    }
                }
            });
        }

        protected void okPressed() {
            String str = this.nameField.getText().trim();
            this.filters = new FilterState(this.severityButton.getSelection(), this.errorButton.getSelection(), this.warningButton.getSelection(), this.infoButton.getSelection(), str, this.combo.getSelectionIndex() == 1, this.filters.isCompleteFilterEnabled());
            FilterWMQTestResultsAction.saveFiltersToPreferences(this.filters);
            super.okPressed();
        }
    }
}

