/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.problems.TestsProblemView;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ExportResultsAction
extends Action {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/ExportResultsAction.java";
    private Shell parentShell;
    private TableViewer viewer;

    public ExportResultsAction(Trace t, TestsProblemView viewpart, TableViewer viewer) {
        this.parentShell = viewpart.getSite().getShell();
        this.viewer = viewer;
        String text = Messages.getString(Trace.getDefault(), "ExportAction.name");
        this.setText(text);
        this.setToolTipText(text);
    }

    public void run() {
        Trace t = Trace.getDefault();
        this.viewer.refresh();
        if (TestsPlugin.getProblemView() != null) {
            TestsPlugin.getProblemView().refresh();
        }
        if (this.viewer.getTable().getItemCount() > 0) {
            FileDialog saveDialog = new FileDialog(this.parentShell, 8192);
            saveDialog.setFilterExtensions(new String[]{"*.log", "*.*"});
            String path = saveDialog.open();
            if (path != null) {
                try {
                    String message;
                    File f = new File(path);
                    if (f.exists() && MessageBox.showYesNoMessage((Trace)t, (Shell)this.parentShell, (String)(message = CommonServices.getSystemMessage((String)"AMQ4869", (String)path)), (int)0, null) == 1) {
                        return;
                    }
                    this.writeToFile(path);
                }
                catch (IOException iOException) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)this.parentShell, (String)"AMQ4539", (String[])new String[]{path});
                }
            }
        } else {
            MessageBox.showSystemMessageById((Trace)t, (Shell)this.parentShell, (String)"AMQ4554", null);
        }
    }

    public void writeToFile(String path) throws IOException {
        FileWriter fstream = new FileWriter(path);
        try (BufferedWriter out = new BufferedWriter(fstream);){
            out.write(this.contentAsPlainText());
        }
    }

    public String contentAsPlainText() {
        String newLine = System.getProperty("line.separator");
        String recordSeparator = "\t";
        StringBuffer out = new StringBuffer();
        String[][] content = this.getTableContent();
        int columnCount = this.viewer.getTable().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            String heading = this.viewer.getTable().getColumn(i).getText();
            if (heading.length() == 0) {
                heading = Messages.getString(Trace.getDefault(), "ProblemView.severity");
            }
            out.append(heading);
            if (i < columnCount - 1) {
                out.append(recordSeparator);
            } else {
                out.append(newLine);
            }
            ++i;
        }
        i = 0;
        while (i < content.length) {
            int j = 0;
            while (j < content[0].length) {
                out.append(content[i][j]);
                if (j < content[0].length - 1) {
                    out.append(recordSeparator);
                } else {
                    out.append(newLine);
                }
                ++j;
            }
            ++i;
        }
        return out.toString();
    }

    public String[][] getTableContent() {
        Table table = this.viewer.getTable();
        int cols = table.getColumnCount();
        int rows = table.getItemCount();
        String[][] content = new String[rows][cols];
        IBaseLabelProvider baseLabelProvider = this.viewer.getLabelProvider();
        if (baseLabelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider labelProvider = (ITableLabelProvider)baseLabelProvider;
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < cols) {
                    content[i][j] = labelProvider.getColumnText(items[i].getData(), j);
                    ++j;
                }
                ++i;
            }
        }
        return content;
    }
}

