/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyAction
extends Action {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/internal/actions/CopyAction.java";
    private TableViewer fViewer;
    private Clipboard fClipboard;

    public CopyAction(TableViewer viewer, Clipboard clipboard) {
        this.fClipboard = clipboard;
        this.fViewer = viewer;
        String text = Messages.getString(Trace.getDefault(), "CopyAction.name");
        this.setText(text);
        this.setToolTipText(text);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void run() {
        this.fClipboard.setContents(new Object[]{this.getContentsAsText()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public String getContentsAsText() {
        String newLine = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        int numCols = this.fViewer.getTable().getColumnCount();
        int i = 0;
        while (i < numCols) {
            String colText = this.fViewer.getTable().getColumn(i).getText();
            if (colText.length() == 0) {
                colText = Messages.getString(Trace.getDefault(), "ProblemView.severity");
            }
            buf.append(colText);
            if (i < numCols - 1) {
                buf.append('\t');
            }
            ++i;
        }
        buf.append(newLine);
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object[] items = structured.toArray();
            int i2 = 0;
            while (i2 < items.length) {
                IBaseLabelProvider base = this.fViewer.getLabelProvider();
                if (base instanceof ITableLabelProvider) {
                    ITableLabelProvider provider = (ITableLabelProvider)base;
                    int j = 0;
                    while (j < numCols) {
                        String text = provider.getColumnText(items[i2], j);
                        buf.append(text);
                        if (j < numCols - 1) {
                            buf.append('\t');
                        }
                        ++j;
                    }
                    buf.append(newLine);
                }
                ++i2;
            }
        }
        return buf.toString();
    }
}

