/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.Messages;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.tests.internal.problems.TestsProblemView;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TestsPlugin
extends AbstractUIPlugin {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/TestsPlugin.java";
    private static TestsPlugin plugin;
    public static final String PLUGIN_ID = "com.ibm.mq.explorer.tests";
    public static final String SYSTEM_IDENTIFIER = "SYSTEM.";
    public static final String SYSTEM_DYNAMIC_OBJ_IDENTIFIER = "SYSTEM.AUTO.";
    public static final String ID_ROOT_PAGE = "com.ibm.mq.explorer.tests.ui.contentpage.RootContentPage";
    public static final String ID_TESTSET_PAGE = "com.ibm.mq.explorer.tests.ui.contentpage.TestSetContentPage";
    public static final String ID_TEST_PAGE = "com.ibm.mq.explorer.tests.ui.contentpage.TestContentPage";
    public static final String ID_PREFERENCES = "com.ibm.mq.explorer.tests.enabletests";
    public static final String ID_PROBLEMSVIEW = "com.ibm.mq.explorer.tests.problemview";
    public static String PLACEHOLDER_MSG;
    public static final String MQ_MARKER_ID = "com.ibm.mq.explorer.tests.mqmarker";
    public static final String MARKER_QMGRATTR = "qmgrname";
    public static final String MARKER_TESTNAMEATTR = "testname";
    public static final String MARKER_TESTIDATTR = "testid";
    public static final String MARKER_CONFIG = "config";
    public static final String MARKER_TREENODEID = "treenodeid";
    public static final String MARKER_CATEGORY = "formattedcategory";
    public static final String MARKER_TESTCOMPLETIONRECORD = "testcomplete";
    private IProject testsproject = null;
    public static final String RUNTIME_PROJ_NAME = "WMQ Explorer Tests Data";
    private static WMQCategoryStore categoryStore;
    private static WMQContextStore contextStore;
    private static TestsProblemView problemView;

    static {
        PLACEHOLDER_MSG = null;
        categoryStore = null;
        contextStore = null;
        problemView = null;
    }

    public TestsPlugin() {
        Trace t = Trace.getDefault();
        PLACEHOLDER_MSG = Messages.getString(t, "TestsPlugin.placeholder_file_text");
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        Trace t = Trace.getDefault();
        super.start(context);
        new Icons();
        categoryStore = new WMQCategoryStore(t);
        contextStore = new WMQContextStore(t);
        PreferenceStoreManager.initializeDefaultPreferences(TestsPlugin.getDefault().getPreferenceStore());
    }

    public static TestsPlugin getDefault() {
        return plugin;
    }

    public static void openProblemView(Trace t) {
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(TestsPlugin.ID_PROBLEMSVIEW);
                }
                catch (Exception exc) {
                    System.out.println(exc.getMessage());
                }
            }
        });
    }

    public static void closeProblemView(Trace t) {
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewReference viewRef = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(TestsPlugin.ID_PROBLEMSVIEW);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(viewRef);
                }
                catch (Exception exc) {
                    System.out.println(exc.getMessage());
                }
            }
        });
    }

    public IProject getProject() {
        return this.testsproject;
    }

    public IFolder getQmgr(Trace t, String name) {
        String qmgrName = name;
        if (qmgrName.length() < 1) {
            qmgrName = Messages.getString(t, "TestsPlugin.unknown");
        }
        if (CommonServices.PLATFORM_ID == 1) {
            qmgrName = qmgrName.toUpperCase();
        }
        qmgrName = TestsPlugin.stripSpecialChars(t, qmgrName);
        IWorkspaceRoot root = this.getProject().getWorkspace().getRoot();
        IFolder folder = this.getFolder(t, root, this.getProject().getFullPath().append(qmgrName));
        return folder;
    }

    public IFile getObjectType(Trace t, IFolder qmgr, String type) {
        String objtype = type;
        if (objtype.length() < 1) {
            objtype = Messages.getString(t, "TestsPlugin.general");
        }
        if (CommonServices.PLATFORM_ID == 1) {
            String fixedtype;
            objtype = fixedtype = String.valueOf(objtype.substring(0, 1).toUpperCase()) + objtype.substring(1).toLowerCase();
        }
        IWorkspaceRoot root = this.getProject().getWorkspace().getRoot();
        IPath projpath = this.getProject().getLocation();
        IPath qmgrpath = projpath.append(qmgr.getName());
        IPath objtpath = qmgrpath.append(objtype);
        String abspath = objtpath.toString();
        IFile file = this.getFile(t, root, objtpath, abspath);
        return file;
    }

    private synchronized IFolder getFolder(Trace t, IWorkspaceRoot root, IPath path) {
        IFolder folder = root.getFolder(path);
        if (!folder.exists()) {
            try {
                folder.create(false, true, null);
            }
            catch (CoreException exc) {
                t.FFST(66, "TestsPlugin.getFolder", 0, 0, 0, 0, "Error while creating folder for Tests Plugin", folder.getName(), exc.getMessage());
            }
        }
        return folder;
    }

    private synchronized IFile getFile(Trace t, IWorkspaceRoot root, IPath path, String ospath) {
        IFile file = root.getFileForLocation(path.makeAbsolute());
        if (!file.exists()) {
            try {
                File myFile = new File(ospath);
                boolean fileCreated = myFile.createNewFile();
                if (fileCreated) {
                    FileInputStream str = new FileInputStream(myFile);
                    file.create((InputStream)str, true, null);
                    FileOutputStream writer = new FileOutputStream(myFile);
                    writer.write(PLACEHOLDER_MSG.getBytes());
                } else {
                    file = null;
                }
            }
            catch (FileNotFoundException e1) {
                t.FFST(66, "TestsPlugin.getFile", 0, 0, 0, 0, "Error while creating file for Tests Plugin", ospath, e1.getMessage());
            }
            catch (IOException e2) {
                t.FFST(66, "TestsPlugin.getFile", 1, 0, 0, 0, "Error while creating file for Tests Plugin", ospath, e2.getMessage());
            }
            catch (CoreException e3) {
                t.FFST(66, "TestsPlugin.getFile", 2, 0, 0, 0, "Error while creating file for Tests Plugin", ospath, e3.getMessage());
            }
        }
        return file;
    }

    public Image getPluginIcon(Trace t) {
        Image i = Icons.getImage(t, Icons.TEST_RESULTS);
        return i;
    }

    public static TreeNode findTreeNode(Trace t, String treeNodeId) {
        TreeNode tn = null;
        IStructuredSelection selection = (IStructuredSelection)UiPlugin.getMQNavigatorViewSelection((Trace)Trace.getDefault());
        Object object = selection.getFirstElement();
        if (object instanceof TreeNode) {
            tn = (TreeNode)object;
        }
        if (tn != null) {
            while (tn.getParent() != null) {
                tn = tn.getParent();
            }
            tn = TestsPlugin.recurse(tn, treeNodeId);
        }
        return tn;
    }

    private static TreeNode recurse(TreeNode tn, String treeNodeId) {
        TreeNode rtn = null;
        if (tn.getTreeNodeId().equals(treeNodeId)) {
            rtn = tn;
        } else if (tn.hasChildren()) {
            TreeNode[] nodes = tn.getVisibleChildren();
            int k = 0;
            while (k < nodes.length) {
                rtn = TestsPlugin.recurse(nodes[k], treeNodeId);
                if (rtn == null) {
                    ++k;
                    continue;
                }
                break;
            }
        } else {
            return null;
        }
        return rtn;
    }

    public static TestsPlugin getPlugin() {
        return plugin;
    }

    public static WMQCategoryStore getCategoryStore() {
        return categoryStore;
    }

    private static final String stripSpecialChars(Trace t, String string) {
        String res = Integer.valueOf(string.hashCode()).toString();
        return res;
    }

    public static final String generateObjectName(Trace t, MQExtObject obj) {
        String ret = "";
        String name = obj.getName();
        String id = obj.getObjectId();
        String type = obj.getMqType();
        if (obj instanceof MQQmgrExtObject) {
            UiQueueManager uiqm = (UiQueueManager)obj.getInternalObject();
            name = uiqm.getTreeName();
        }
        ret = String.valueOf(type) + id + name;
        return ret;
    }

    public void stop(BundleContext context) throws Exception {
        Trace t = Trace.getDefault();
        try {
            WMQTestEngine.abortEngine(t);
            if (this.testsproject != null) {
                this.testsproject.close(null);
            }
            this.deleteDir(TestsPlugin.getDefault().getStateLocation().toFile());
        }
        finally {
            super.stop(context);
        }
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.deleteDir(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static WMQContextStore getContextStore() {
        return contextStore;
    }

    public void setTestsproject(IProject testsproject) {
        this.testsproject = testsproject;
    }

    public static TestsProblemView getProblemView() {
        return problemView;
    }

    public static void setProblemView(TestsProblemView problemView) {
        TestsPlugin.problemView = problemView;
    }
}

