/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategory;
import com.ibm.mq.explorer.tests.internal.objects.WMQCategoryStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextGroup;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextMatch;
import com.ibm.mq.explorer.tests.internal.objects.WMQContextStore;
import com.ibm.mq.explorer.tests.internal.objects.WMQSubCategory;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class ProcessPluginTests {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/ProcessPluginTests.java";
    private static final String TEST_EXTENSION_POINT = "com.ibm.mq.explorer.tests.Tests";
    private static final String TESTSET_EXTENSION_POINT = "com.ibm.mq.explorer.tests.Testset";
    private static final String CATEGORY_EXTENSION_POINT = "com.ibm.mq.explorer.tests.TestCategorys";
    private static final String CONTEXTGROUP_EXTENSION_POINT = "com.ibm.mq.explorer.tests.ContextGroup";
    public static final String CATEGORYID_ATTRIBUTE = "categoryId";
    public static final String NAME_ATTRIBUTE = "name";
    private static final String TESTSET_ATTRIBUTE = "testset";
    private static final String TESTSUBSET_ATTRIBUTE = "testsubset";
    public static final String FURTHERINFO_ATTRIBUTE = "furtherinfo";
    private static final String ID_ATTRIBUTE = "id";
    private static final String GROUPID_ATTRIBUTE = "groupId";
    static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String MATCHTYPE_ATTRIBUTE = "matchtype";
    private static final String TREENODEID_ATTRIBUTE = "treenodeid";
    private static final String TYPE_ATTRIBUTE = "type";

    private ProcessPluginTests() {
    }

    public static final void process(Trace t) {
        WMQCategoryStore.clear(t);
        WMQContextStore.clear();
        ProcessPluginTests.processCategories(t);
        ProcessPluginTests.processAdditionalCategories(t);
        ProcessPluginTests.processTests(t);
        ProcessPluginTests.processContexts(t);
    }

    private static void processCategories(Trace t) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(CATEGORY_EXTENSION_POINT);
        IConfigurationElement[] categories = extensionPoint.getConfigurationElements();
        if (Trace.isTracing) {
            t.data(66, "ProcessPluginTests.processCategories", 300, "Processing extension point: com.ibm.mq.explorer.tests.TestCategorys");
        }
        int m = 0;
        while (m < categories.length) {
            String catid = categories[m].getAttribute(ID_ATTRIBUTE);
            String catname = categories[m].getAttribute(NAME_ATTRIBUTE);
            String catdescription = categories[m].getAttribute(DESCRIPTION_ATTRIBUTE);
            String caticon = categories[m].getAttribute(ICON_ATTRIBUTE);
            String catfurtherinfo = categories[m].getAttribute(FURTHERINFO_ATTRIBUTE);
            String pluginID = categories[m].getDeclaringExtension().getContributor().getName();
            if (!UiPlugin.getPluginRegistrationManager().isPluginRegistered(pluginID) || UiPlugin.isPluginEnabled((String)pluginID)) {
                Bundle classBundle = Platform.getBundle((String)pluginID);
                if (caticon != null) {
                    URL url = classBundle.getEntry(caticon);
                    caticon = url.toString();
                }
                catfurtherinfo = ProcessPluginTests.processFurtherInfoUrl(t, pluginID, catfurtherinfo);
                WMQCategory cat = new WMQCategory(t, catid, catname, catdescription, caticon, catfurtherinfo);
                WMQCategoryStore.addCategory(t, cat);
                if (Trace.isTracing) {
                    t.data(66, "ProcessPluginTests.processCategories", 300, "categroy created and stored: " + catname);
                }
                IConfigurationElement[] testsets = categories[m].getChildren();
                int a = 0;
                while (a < testsets.length) {
                    String testseticon = testsets[a].getAttribute(ICON_ATTRIBUTE);
                    String testsetdescription = testsets[a].getAttribute(DESCRIPTION_ATTRIBUTE);
                    String testsetname = testsets[a].getAttribute(NAME_ATTRIBUTE);
                    String testsetid = testsets[a].getAttribute(ID_ATTRIBUTE);
                    String testfurtherinfo = testsets[a].getAttribute(FURTHERINFO_ATTRIBUTE);
                    pluginID = categories[m].getDeclaringExtension().getContributor().getName();
                    classBundle = Platform.getBundle((String)pluginID);
                    if (testseticon != null) {
                        URL url = classBundle.getEntry(testseticon);
                        testseticon = url.toString();
                    }
                    testfurtherinfo = ProcessPluginTests.processFurtherInfoUrl(t, pluginID, testfurtherinfo);
                    WMQSubCategory sub = new WMQSubCategory(t, testsetid, testsetname, testsetdescription, testseticon, testfurtherinfo);
                    cat.addSubCategory(t, sub);
                    if (Trace.isTracing) {
                        t.data(66, "ProcessPluginTests.processCategories", 300, "Subcat (testset) created and added: " + testsetname);
                    }
                    IConfigurationElement[] treeNodeIds = testsets[a].getChildren();
                    int b = 0;
                    while (b < treeNodeIds.length) {
                        String nodeid = treeNodeIds[b].getAttribute(TREENODEID_ATTRIBUTE);
                        String matchtype = treeNodeIds[b].getAttribute(MATCHTYPE_ATTRIBUTE);
                        sub.addMatchNodeId(t, nodeid, matchtype);
                        if (Trace.isTracing) {
                            t.data(66, "ProcessPluginTests.processCategories", 300, "added treenode " + nodeid + " match type " + matchtype);
                        }
                        ++b;
                    }
                    ++a;
                }
            }
            ++m;
        }
    }

    private static void processAdditionalCategories(Trace t) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TESTSET_EXTENSION_POINT);
        IConfigurationElement[] testsets = extensionPoint.getConfigurationElements();
        if (Trace.isTracing) {
            t.data(66, "ProcessPluginTests.processAdditionalCategories", 300, "Processing extension point: com.ibm.mq.explorer.tests.Testset");
        }
        int a = 0;
        while (a < testsets.length) {
            String categoryId = testsets[a].getAttribute(CATEGORYID_ATTRIBUTE);
            String testseticon = testsets[a].getAttribute(ICON_ATTRIBUTE);
            String testsetdescription = testsets[a].getAttribute(DESCRIPTION_ATTRIBUTE);
            String testsetname = testsets[a].getAttribute(NAME_ATTRIBUTE);
            String testsetid = testsets[a].getAttribute(ID_ATTRIBUTE);
            String testfurtherinfo = testsets[a].getAttribute(FURTHERINFO_ATTRIBUTE);
            String pluginID = testsets[a].getDeclaringExtension().getContributor().getName();
            if (!UiPlugin.getPluginRegistrationManager().isPluginRegistered(pluginID) || UiPlugin.isPluginEnabled((String)pluginID)) {
                Bundle classBundle = Platform.getBundle((String)pluginID);
                if (testseticon != null) {
                    URL url = classBundle.getEntry(testseticon);
                    testseticon = url.toString();
                }
                testfurtherinfo = ProcessPluginTests.processFurtherInfoUrl(t, pluginID, testfurtherinfo);
                WMQSubCategory sub = new WMQSubCategory(t, testsetid, testsetname, testsetdescription, testseticon, testfurtherinfo);
                WMQCategory cat = WMQCategoryStore.getCategory(categoryId);
                if (cat == null) {
                    t.FFST(66, "ProcessPluginTests.processAdditionalCategories", 0, 0, "tried to add sub category (" + categoryId + " ) to no-existant category");
                } else {
                    cat.addSubCategory(t, sub);
                    if (Trace.isTracing) {
                        t.data(66, "ProcessPluginTests.processAdditionalCategories", 300, "subcat (testset) " + testsetname + " created and added to category " + cat.getName());
                    }
                    IConfigurationElement[] treeNodeIds = testsets[a].getChildren();
                    int b = 0;
                    while (b < treeNodeIds.length) {
                        String nodeid = treeNodeIds[b].getAttribute(TREENODEID_ATTRIBUTE);
                        String matchtype = treeNodeIds[b].getAttribute(MATCHTYPE_ATTRIBUTE);
                        sub.addMatchNodeId(t, nodeid, matchtype);
                        if (Trace.isTracing) {
                            t.data(66, "ProcessPluginTests.processAdditionalCategories", 300, "added treenode " + nodeid + " match type " + matchtype);
                        }
                        ++b;
                    }
                }
            }
            ++a;
        }
    }

    private static void processTests(Trace t) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TEST_EXTENSION_POINT);
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        if (Trace.isTracing) {
            t.data(66, "ProcessPluginTests.processTests", 300, "Processing extension point: com.ibm.mq.explorer.tests.Tests");
        }
        int m = 0;
        while (m < members.length) {
            block20: {
                IConfigurationElement member = members[m];
                String testname = member.getAttribute(NAME_ATTRIBUTE);
                String testid = member.getAttribute(ID_ATTRIBUTE);
                String desc = member.getAttribute(DESCRIPTION_ATTRIBUTE);
                String furtherinfo = member.getAttribute(FURTHERINFO_ATTRIBUTE);
                String testSetId = member.getAttribute(TESTSET_ATTRIBUTE);
                String testSubSetId = member.getAttribute(TESTSUBSET_ATTRIBUTE);
                String pluginID = member.getDeclaringExtension().getContributor().getName();
                if (!UiPlugin.getPluginRegistrationManager().isPluginRegistered(pluginID) || UiPlugin.isPluginEnabled((String)pluginID)) {
                    WMQSubCategory subcat;
                    block21: {
                        WMQCategory cat;
                        if (Trace.isTracing) {
                            t.data(66, "ProcessPluginTests.processTests", 300, "Processing test: " + testname);
                        }
                        if (testSetId == null) {
                            testSetId = "com.ibm.mq.explorer.tests.default";
                            if (Trace.isTracing) {
                                t.data(66, "ProcessPluginTests.processTests", 300, "test has not specified a category - using default");
                            }
                        }
                        if ((cat = WMQCategoryStore.getCategory(testSetId)) == null) {
                            if (Trace.isTracing) {
                                t.data(66, "ProcessPluginTests.processTests", 300, "Category " + testSetId + " does not exsit, retrieving default instead");
                            }
                            testSetId = "com.ibm.mq.explorer.tests.default";
                            cat = WMQCategoryStore.getCategory(testSetId);
                        }
                        if (testSubSetId == null) {
                            testSubSetId = "com.ibm.mq.explorer.tests.sub.other";
                            if (Trace.isTracing) {
                                t.data(66, "ProcessPluginTests.processTests", 300, "test has not specified a sub category - using deafult");
                            }
                        }
                        if ((subcat = cat.getSubCategory(testSubSetId)) == null) {
                            if (Trace.isTracing) {
                                t.data(66, "ProcessPluginTests.processTests", 300, "sub category " + testSubSetId + " does not exist, retrieving default instead");
                            }
                            testSubSetId = "com.ibm.mq.explorer.tests.sub.other";
                            subcat = cat.getSubCategory(testSubSetId);
                        }
                        furtherinfo = ProcessPluginTests.processFurtherInfoUrl(t, pluginID, furtherinfo);
                        if (desc == null) {
                            desc = "";
                        }
                        try {
                            String classname = member.getAttribute(CLASS_ATTRIBUTE);
                            if (classname.equals("")) {
                                t.FFST(66, "ProcessPluginTests.processTests", 0, 50046, 0, 0, testid, "Test specified an empty test class", "");
                                break block20;
                            }
                            Object callback = member.createExecutableExtension(CLASS_ATTRIBUTE);
                            if (!(callback instanceof WMQTest)) {
                                t.FFST(66, "ProcessPluginTests.processTests", 1, 50046, 0, 0, testid, "Test specified a test that is not an instance of WMQTest", "");
                            }
                            break block21;
                        }
                        catch (CoreException ex) {
                            t.FFST(66, "ProcessPluginTests.processTests", 2, 50046, 0, 0, testid, "Test failed with exception", ex.getMessage());
                        }
                        catch (Exception classexc) {
                            t.FFST(66, "ProcessPluginTests.processTests", 3, 50046, 0, 0, testid, "Test failed with exception", classexc.getMessage());
                        }
                        catch (Error err) {
                            t.FFST(66, "ProcessPluginTests.processTests", 4, 50046, 0, 0, testid, "Test failed with exception", err.getMessage());
                        }
                        break block20;
                    }
                    TestProxy proxy = new TestProxy(member);
                    ((WMQTest)proxy).setTestName(testname);
                    ((WMQTest)proxy).setTestId(testid);
                    ((WMQTest)proxy).setTestSet(subcat);
                    ((WMQTest)proxy).setFurtherInfoPath(furtherinfo);
                    ((WMQTest)proxy).setDescription(desc);
                    subcat.addTest(proxy);
                    if (Trace.isTracing) {
                        t.data(66, "ProcessPluginTests.processTests", 300, "Test created and added");
                    }
                }
            }
            ++m;
        }
    }

    private static String processFurtherInfoUrl(Trace t, String pluginID, String url) {
        String furtherinfo = url;
        if (furtherinfo != null && !furtherinfo.startsWith("http://")) {
            if (Trace.isTracing) {
                t.data(66, "ProcessPluginTests.processFurtherInfoUrl", 300, "Further info is a file, generating url relative to plugin");
            }
            Bundle bundle = Platform.getBundle((String)pluginID);
            furtherinfo = "$nl$/" + furtherinfo;
            Path path = new Path(furtherinfo);
            if (Trace.isTracing) {
                t.data(66, "ProcessPluginTests.processFurtherInfoUrl", 300, "trying to find url for " + furtherinfo + " in language " + Platform.getNL());
            }
            URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
            if (Trace.isTracing) {
                t.data(66, "ProcessPluginTests.processFurtherInfoUrl", 300, "URL found for file = " + fileURL);
            }
            try {
                fileURL = FileLocator.resolve((URL)fileURL);
                furtherinfo = fileURL.toExternalForm();
            }
            catch (Exception exception) {
                furtherinfo = "";
            }
            if (Trace.isTracing) {
                t.data(66, "ProcessPluginTests.processFurtherInfoUrl", 300, "resolved to url" + furtherinfo);
            }
        }
        return furtherinfo;
    }

    private static void processContexts(Trace t) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(CONTEXTGROUP_EXTENSION_POINT);
        IConfigurationElement[] contexts = extensionPoint.getConfigurationElements();
        if (Trace.isTracing) {
            t.data(66, "ProcessPluginTests.processContexts", 300, "Processing extension point: com.ibm.mq.explorer.tests.ContextGroup");
        }
        int m = 0;
        while (m < contexts.length) {
            String groupid = contexts[m].getAttribute(GROUPID_ATTRIBUTE);
            String groupname = contexts[m].getAttribute(NAME_ATTRIBUTE);
            String pluginID = contexts[m].getDeclaringExtension().getContributor().getName();
            if (!UiPlugin.getPluginRegistrationManager().isPluginRegistered(pluginID) || UiPlugin.isPluginEnabled((String)pluginID)) {
                WMQContextGroup group = new WMQContextGroup(t, groupid, groupname);
                WMQContextStore.addGroup(group);
                if (Trace.isTracing) {
                    t.data(66, "ProcessPluginTests.processContexts", 300, "Context group created: " + groupname);
                }
                IConfigurationElement[] matching = contexts[m].getChildren();
                int a = 0;
                while (a < matching.length) {
                    String matchWhat = matching[a].getName();
                    String matchType = null;
                    String matchData = null;
                    if (matchWhat.equals("objectType")) {
                        matchType = matching[a].getAttribute(MATCHTYPE_ATTRIBUTE);
                        matchData = matching[a].getAttribute(TYPE_ATTRIBUTE);
                    }
                    if (matchWhat.equals("instanceOf")) {
                        matchType = "exact";
                        matchData = matching[a].getAttribute(CLASS_ATTRIBUTE);
                    }
                    if (matchWhat.equals("objectName")) {
                        matchType = matching[a].getAttribute(MATCHTYPE_ATTRIBUTE);
                        matchData = matching[a].getAttribute(NAME_ATTRIBUTE);
                    }
                    if (matchWhat.equals("objectId")) {
                        matchType = matching[a].getAttribute(MATCHTYPE_ATTRIBUTE);
                        matchData = matching[a].getAttribute(ID_ATTRIBUTE);
                    }
                    WMQContextMatch match = new WMQContextMatch(t, matchWhat, matchType, matchData);
                    group.addMatch(match);
                    if (Trace.isTracing) {
                        t.data(66, "ProcessPluginTests.processContexts", 300, "Group match details added...");
                        t.data(66, "ProcessPluginTests.processContexts", 300, "matchWhat: " + matchWhat);
                        t.data(66, "ProcessPluginTests.processContexts", 300, "matchType: " + matchType);
                        t.data(66, "ProcessPluginTests.processContexts", 300, "matchData: " + matchData);
                    }
                    ++a;
                }
            }
            ++m;
        }
    }

    private static class TestProxy
    extends WMQTest {
        private WMQTest delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        TestProxy(IConfigurationElement configelement) {
            this.element = configelement;
        }

        public final String toString() {
            return this.getTestName();
        }

        @Override
        public String getTestName() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.getTestName();
        }

        @Override
        public void setTestName(String name) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.setTestName(name);
        }

        @Override
        public void setTestSet(WMQSubCategory set) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.setTestSet(set);
        }

        @Override
        public WMQSubCategory getTestSubCategory() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.getTestSubCategory();
        }

        @Override
        public void setDescription(String desc) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.setDescription(desc);
        }

        @Override
        public String getDescription() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.getDescription();
        }

        @Override
        public String getTestId() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.getTestId();
        }

        @Override
        public void setTestId(String id) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.setTestId(id);
        }

        @Override
        public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.runApplicableTests(callback, guimonitor, contextObjects, treenode);
        }

        @Override
        public IProgressMonitor getGUIMonitor() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.getGUIMonitor();
        }

        @Override
        public void testComplete(WMQTestResult[] results) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.testComplete(results);
        }

        @Override
        public String getFurtherInfoPath() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.getFurtherInfoPath();
        }

        @Override
        public void setFurtherInfoPath(String furtherInfoURL) {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            this.delegate.setFurtherInfoPath(furtherInfoURL);
        }

        @Override
        public boolean isTestComplete() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.isTestComplete();
        }

        @Override
        public boolean isCancelled() {
            Trace t = Trace.getDefault();
            this.getDelegate(t);
            return this.delegate.isCancelled();
        }

        private final void getDelegate(Trace t) {
            if (this.invoked) {
                return;
            }
            this.invoked = true;
            try {
                Object callback = this.element.createExecutableExtension(ProcessPluginTests.CLASS_ATTRIBUTE);
                if (!(callback instanceof WMQTest)) {
                    t.FFST(66, "ProcessPluginTests.TestProxy.getDelegate", 1, 50046, 0, 0, this.getTestId(), "Test specified a test that is not an instance of WMQTest", "");
                    return;
                }
                this.delegate = (WMQTest)((Object)callback);
            }
            catch (CoreException ex) {
                t.FFST(66, "ProcessPluginTests.TestProxy.getDelegate", 2, 50046, 0, 0, this.getTestId(), "Test failed with exception", ex.getMessage());
            }
            catch (Exception classexc) {
                t.FFST(66, "ProcessPluginTests.TestProxy.getDelegate", 3, 50046, 0, 0, this.getTestId(), "Test failed with exception", classexc.getMessage());
            }
            catch (Error err) {
                t.FFST(66, "ProcessPluginTests.TestProxy.getDelegate", 4, 50046, 0, 0, this.getTestId(), "Test failed with exception", err.getMessage());
            }
        }
    }
}

