/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests;

import com.ibm.mq.explorer.tests.TestsPlugin;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceStoreManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/PreferenceStoreManager.java";
    public static String PREFERENCE_DELIMITER = ";;";
    public static final String SYSTEMTESTS_PREFERENCE = "include_system_objs";
    public static final String HIDDENQMGRS_PREFERENCE = "include_hidden_qmgrs";
    public static final String NAMEVALUE_DELIMITER = "=";

    private static IPreferenceStore getPreferenceStore() {
        return TestsPlugin.getDefault().getPreferenceStore();
    }

    public static boolean getIncludeSysObjsPreference() {
        return PreferenceStoreManager.getPreferenceStore().getBoolean(SYSTEMTESTS_PREFERENCE);
    }

    public static void setIncludeSysObjsPreference(boolean state) {
        PreferenceStoreManager.getPreferenceStore().setValue(SYSTEMTESTS_PREFERENCE, state);
    }

    public static boolean getIncludeHiddenQmgrsPreference() {
        return PreferenceStoreManager.getPreferenceStore().getBoolean(HIDDENQMGRS_PREFERENCE);
    }

    public static void setIncludeHiddenQmgrsPreference(boolean state) {
        PreferenceStoreManager.getPreferenceStore().setValue(HIDDENQMGRS_PREFERENCE, state);
    }

    public static void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(SYSTEMTESTS_PREFERENCE, false);
        store.setDefault(HIDDENQMGRS_PREFERENCE, false);
    }

    public static String getPreferencesAsString() {
        String prefs = "";
        prefs = prefs.concat("include_system_objs=" + PreferenceStoreManager.getIncludeSysObjsPreference() + PREFERENCE_DELIMITER);
        prefs = prefs.concat("include_hidden_qmgrs=" + PreferenceStoreManager.getIncludeHiddenQmgrsPreference() + PREFERENCE_DELIMITER);
        return prefs;
    }

    public static boolean setPreferencesAsString(String prefs) {
        boolean result = true;
        StringTokenizer st = new StringTokenizer(prefs, PREFERENCE_DELIMITER);
        while (st.hasMoreElements()) {
            String pref = st.nextToken();
            int equalsIndex = pref.indexOf(NAMEVALUE_DELIMITER);
            String name = pref.substring(0, equalsIndex);
            String value = pref.substring(equalsIndex + 1);
            Boolean val = Boolean.valueOf(value);
            if (name.equals(SYSTEMTESTS_PREFERENCE)) {
                PreferenceStoreManager.setIncludeSysObjsPreference(val);
                continue;
            }
            if (!name.equals(HIDDENQMGRS_PREFERENCE)) continue;
            PreferenceStoreManager.setIncludeHiddenQmgrsPreference(val);
        }
        return result;
    }
}

