/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.tests.Icons;
import com.ibm.mq.explorer.tests.ProcessPluginTests;
import com.ibm.mq.explorer.tests.TestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotifyAdapter;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Shell;

public class Notify
extends IExplorerNotifyAdapter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests/src/com/ibm/mq/explorer/tests/Notify.java";
    private boolean isExplorerInitialised = false;
    private boolean hasPluginBeenDisabled = false;

    public void explorerInitialised() {
        this.isExplorerInitialised = true;
        if (TestsPlugin.getProblemView() != null) {
            TestsPlugin.getProblemView().refresh();
        }
    }

    public void pluginEnabled(ExplorerNotifyEvent event) {
        final Trace t = Trace.getDefault();
        if (event.getId().equals("com.ibm.mq.explorer.tests")) {
            if (this.hasPluginBeenDisabled) {
                this.isExplorerInitialised = true;
            }
            Thread ourThread = new Thread(){

                @Override
                public void run() {
                    new Icons();
                    try {
                        IProjectDescription projdesc = ResourcesPlugin.getWorkspace().newProjectDescription("WMQ Explorer Tests Data");
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IProject testsproject = root.getProject("WMQ Explorer Tests Data");
                        if (!testsproject.exists()) {
                            testsproject.create(projdesc, null);
                            testsproject.open(null);
                        } else {
                            testsproject.open(null);
                            testsproject.refreshLocal(2, null);
                        }
                        TestsPlugin.getDefault().setTestsproject(testsproject);
                    }
                    catch (Exception e) {
                        t.FFST(66, "Notify.pluginEnabled.run", 0, 0, 0, 0, "Error while creating runtime project for Tests Plugin", e.getMessage(), "");
                    }
                    try {
                        ProcessPluginTests.process(t);
                    }
                    catch (Exception exception) {
                        UiPlugin.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String msg = CommonServices.getSystemMessage((String)"AMQ4852");
                                MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msg, (String)"AMQ4852");
                            }
                        });
                    }
                }
            };
            ourThread.setName("Initialising tests plug-in project");
            ourThread.start();
        } else if (this.isExplorerInitialised && UiPlugin.getPluginRegistrationManager().isPluginEnabled("com.ibm.mq.explorer.tests")) {
            ProcessPluginTests.process(t);
        }
    }

    public void pluginDisabled(ExplorerNotifyEvent event) {
        Trace t = Trace.getDefault();
        if (event.getId().equals("com.ibm.mq.explorer.tests")) {
            TestsPlugin.closeProblemView(t);
            WMQTestEngine.abortEngine(t);
            this.hasPluginBeenDisabled = true;
        } else if (this.isExplorerInitialised && UiPlugin.getPluginRegistrationManager().isPluginEnabled("com.ibm.mq.explorer.tests")) {
            ProcessPluginTests.process(t);
        }
    }
}

