/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.services;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmService;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public class UiService
extends UiMQObject
implements DmActionListener,
IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/services/UiService.java";
    private String objectType = "";
    private Action actionStart = null;
    private Action actionStop = null;
    private BusyDialog busyDialog = null;
    private Shell shell = null;
    private boolean starting;
    private UiQueueManager uiQueueManager = null;
    private boolean isDeleteing = false;

    public UiService() {
    }

    public UiService(Trace t, IDmObject dmService, UiMQObject parent) {
        super(t, dmService);
        Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Object_Types");
        this.objectType = msgFile.getMessage(t, "UI.OBJECT.Type.Service");
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
    }

    public void appendToContextMenu(Shell sh, IMenuManager manager, Object contextObject) {
        final Trace t = Trace.getDefault();
        this.shell = sh;
        if (this.actionStart == null) {
            this.actionStart = new Action(){

                public void run() {
                    UiService.this.startService(t);
                }
            };
            this.actionStart.setText(QmgradminPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.SERV.Services.Start.Menu"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionStart, "com.ibm.mq.explorer.ui.infopop.UI_Service_StartMenuItem");
        }
        if (this.actionStop == null) {
            this.actionStop = new Action(){

                public void run() {
                    UiService.this.stopService(t);
                }
            };
            this.actionStop.setText(QmgradminPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.SERV.Services.Stop.Menu"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionStop, "com.ibm.mq.explorer.ui.infopop.UI_Service_StopMenuItem");
        }
        DmService dmServ = (DmService)this.getDmObject();
        if (this.isTypeCommand(t)) {
            manager.add((IAction)this.actionStart);
            manager.add((IAction)this.actionStop);
        } else if (dmServ.isRunning(t)) {
            manager.add((IAction)this.actionStop);
        } else {
            manager.add((IAction)this.actionStart);
        }
        super.appendToContextMenu(this.shell, manager, contextObject);
    }

    private boolean isTypeCommand(Trace t) {
        Integer type;
        int inttype;
        boolean result = false;
        DmService dmServ = (DmService)this.getDmObject();
        AttrInt att = (AttrInt)dmServ.getAttribute(t, 121, 0);
        if (att != null && (inttype = (type = (Integer)att.getValue(t)).intValue()) == 0) {
            result = true;
        }
        return result;
    }

    private void startService(Trace t) {
        this.busyDialog = new BusyDialog(this.shell, QmgradminPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.SERV.Services.Busy.Starting"));
        this.starting = true;
        ((DmService)this.getDmObject()).actionStart(t, (DmActionListener)this);
        this.busyDialog.showDialog(t);
    }

    private void stopService(Trace t) {
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4132", (String)this.toFormattedString());
        int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.shell, (String)msg, (int)1, (String)"AMQ4132");
        if (rc == 0) {
            this.busyDialog = new BusyDialog(this.shell, QmgradminPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.SERV.Services.Busy.Stopping"));
            this.starting = false;
            ((DmService)this.getDmObject()).actionStop(t, (DmActionListener)this);
            this.busyDialog.showDialog(t);
        }
    }

    public String getId() {
        return "com.ibm.mq.explorer.service";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getNLSResourceFileKey() {
        return "KEY_Services";
    }

    public void updateIcon() {
        Trace t = Trace.getDefault();
        if (this.isTypeCommand(t)) {
            this.setImage(Icons.get((String)Icons.iconkeyMQservice));
        } else {
            Attr attr = this.getDmObject().getAttribute(t, 1260, 0);
            if (attr != null) {
                Integer i = (Integer)attr.getValue(t);
                int status = i;
                this.setImage(UiService.getUpdateIcon(t, status));
            } else {
                this.setImage(Icons.get((String)Icons.iconkeyMQserviceWarning1));
            }
        }
    }

    public static Image getUpdateIcon(Trace t, int status) {
        Image img = null;
        switch (status) {
            case 2: {
                img = Icons.get((String)Icons.iconkeyMQserviceRunning1);
                break;
            }
            case 1: 
            case 3: {
                img = Icons.get((String)Icons.iconkeyMQserviceAlert1);
                break;
            }
            case 4: {
                img = Icons.get((String)Icons.iconkeyMQserviceWarning1);
                break;
            }
            case 0: {
                img = Icons.get((String)Icons.iconkeyMQserviceStopped1);
                break;
            }
            default: {
                img = Icons.get((String)Icons.iconkeyMQserviceStopped1);
            }
        }
        return img;
    }

    public int getDataModelObjectType(Trace t) {
        return 153;
    }

    public boolean isSupportDelete() {
        return true;
    }

    public void deleteMenuAction(Trace t) {
        this.isDeleteing = true;
        super.deleteMenuAction(t);
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public void dmActionDone(DmActionEvent event) {
        if (this.isDeleteing) {
            super.dmActionDone(event);
            this.isDeleteing = false;
        } else {
            final int rc = event.getReasonCode();
            final DmCoreException exc = event.getException();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace trace = Trace.getDefault();
                    UiService.this.busyDialog.closeDialog(trace);
                    String amqNumber = null;
                    amqNumber = UiService.this.starting ? "AMQ4151" : "AMQ4152";
                    if (rc == 0) {
                        MessageBox.showSystemMessageById((Trace)trace, (Shell)UiPlugin.getShell(), (String)amqNumber, null, (String)amqNumber);
                    } else if (exc != null) {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                    } else {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                    }
                }
            });
        }
    }

    public UiQueueManager getOwningUiQueueManager() {
        return this.uiQueueManager;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "UiService.testAttribute", 300, "testing object '" + target.toString() + "'");
            t.data(67, "UiService.testAttribute", 300, "checking attribute '" + name + "'");
            t.data(67, "UiService.testAttribute", 300, "for value '" + value + "'");
        }
        boolean result = false;
        UiMQObject targetObject = null;
        if (target instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)target;
            targetObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (targetObject != null && targetObject instanceof UiService) {
            if (name.compareTo("ServiceStatus") == 0) {
                int status = 0;
                Attr attr = this.getDmObject().getAttribute(t, 1260, 0);
                if (attr != null && attr instanceof AttrInt) {
                    Integer intStatus = (Integer)((AttrInt)attr).getValue(t);
                    status = intStatus;
                }
                if (value.compareTo("Running") == 0 && status == 2) {
                    result = true;
                } else if (value.compareTo("Stopped") == 0 && status == 0) {
                    result = true;
                } else if (value.compareTo("Starting") == 0 && status == 1) {
                    result = true;
                } else if (value.compareTo("Stopping") == 0 && status == 3) {
                    result = true;
                } else if (value.compareTo("Retrying") == 0 && status == 4) {
                    result = true;
                }
            } else {
                int iResult = this.uiQueueManager.testQmgrAttribute(t, (Object)this.uiQueueManager, name, value);
                switch (iResult) {
                    case 1: {
                        result = true;
                        break;
                    }
                    case 0: {
                        result = false;
                        break;
                    }
                    default: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(67, "UiService.testAttribute", 900, "Object is not a UiService");
            }
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(67, "UiService.testAttribute", 300, "returning " + result);
        }
        return result;
    }
}

