/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.remoteadmin;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmListenerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.listeners.UiListener;
import com.ibm.mq.explorer.qmgradmin.internal.listeners.UiListenerActions;
import com.ibm.mq.explorer.qmgradmin.internal.remoteadmin.CreateListener;
import com.ibm.mq.explorer.qmgradmin.internal.remoteadmin.CreateListenerDialog;
import com.ibm.mq.explorer.qmgradmin.internal.remoteadmin.CreateSvrConnChannel;
import com.ibm.mq.explorer.qmgradmin.internal.remoteadmin.DeleteListener;
import com.ibm.mq.explorer.qmgradmin.internal.remoteadmin.DeleteSvrConnChannel;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteAdminDialog
extends ExtDialog
implements DmObjectListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/remoteadmin/RemoteAdminDialog.java";
    private static String titleText = null;
    private Point preferredSize = null;
    private Button createSvrConnButton = null;
    private Button deleteSvrConnButton = null;
    private Button createListenerButton = null;
    private Button deleteListenerButton = null;
    private Button startListenerButton = null;
    private Button stopListenerButton = null;
    private static String remoteAdminExplanationLabelText = null;
    private static String remoteAdminStatusLabelText = null;
    private static String svrConnLabelText = null;
    private static String createSvrConnButtonText = null;
    private static String deleteSvrConnButtonText = null;
    private static String createListenerButtonText = null;
    private static String deleteListenerButtonText = null;
    private static String stopListenerButtonText = null;
    private static String startListenerButtonText = null;
    private static String listenerLabelText = null;
    private static String listenerStatusLabelText = null;
    private static String createSvrConnChannelBusyDlgText = null;
    private static String deleteSvrConnChannelBusyDlgText = null;
    private static String createlistenerBusyDlgText = null;
    private static String deleteListenerBusyDlgText = null;
    private static String EXISTS = null;
    private static String DOESNT_EXIST = null;
    private Text svrConnText;
    private Text listenerText;
    public Text listenerStatusText;
    private DmQueueManager dmQmgr = null;
    private DmChannel dmChannel = null;
    private DmListener dmListener = null;
    private UiListener uiListener = null;
    private UiListenerActions uiListenerActions = null;
    private UiQueueManager uiQmgr = null;
    public int listenerStatusInt = 0;
    public String listenerStatus = null;
    public static final String CHANNEL_DELETED = "AMQ4137";
    public static final String CHANNEL_CREATED = "AMQ4139";
    public static final String CHANNEL_CREATE_FAILED = "AMQ4142";
    public static final String CHANNEL_CLONE_FAILED = "AMQ4143";
    public static final String CHANNEL_DELETE_FAILED = "AMQ4144";
    public static final String LISTENER_DELETED = "AMQ4123";
    public static final String LISTENER_DELETE_FAILED = "AMQ4862";
    public static final String START_LISTENER_ACCEPTED = "AMQ4149";
    public static final String STOP_LISTENER_ACCEPTED = "AMQ4150";
    public static final String DELETE_QUESTION = "AMQ4002";
    public static final String STOP_QUESTION = "AMQ4132";
    private static final String LISTENER_CREATED = "AMQ4460";
    private static final String LISTENER_CREATE_FAILED = "AMQ4461";
    private static final String LISTENER_CLONE_FAILED = "AMQ4461";
    private static final int HORIZONTAL_SPAN = 5;

    public RemoteAdminDialog(Shell parent, int style) {
        super(parent, style, 1);
    }

    public RemoteAdminDialog(Shell parent, DmQueueManager dmQueueManager, DmChannel dmChnl, DmListener dmLsnr, String lsnrStatus, UiQueueManager uiQueueManager, int lsnrStatusInt) {
        this(parent, 0);
        Trace t = Trace.getDefault();
        this.setHeadingsInfo(t);
        this.dmQmgr = dmQueueManager;
        this.uiQmgr = uiQueueManager;
        this.dmChannel = dmChnl;
        this.dmListener = dmLsnr;
        this.listenerStatusInt = lsnrStatusInt;
        this.listenerStatus = lsnrStatus;
    }

    private void setHeadingsInfo(Trace t) {
        Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
        titleText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Title");
        remoteAdminExplanationLabelText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Description");
        remoteAdminStatusLabelText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Default.Status");
        svrConnLabelText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.SvrConn.Channel");
        listenerLabelText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Listener");
        listenerStatusLabelText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Listener.Status");
        startListenerButtonText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Start.Listener.Button.Text");
        stopListenerButtonText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Stop.Listener.Button.Text");
        createListenerButtonText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Create.Button.Text");
        deleteListenerButtonText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Delete.Button.Text");
        createSvrConnButtonText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Create.Button.Text");
        deleteSvrConnButtonText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Delete.Button.Text");
        createSvrConnChannelBusyDlgText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Busy.Create.SvrConnChannel");
        deleteSvrConnChannelBusyDlgText = Message.format((String)UiPlugin.getNLSString((Trace)t, (String)"KEY_General", (String)"UI.GENERAL.BUSY.DELETE"), (String)"SYSTEM.ADMIN.SVRCONN");
        createlistenerBusyDlgText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Busy.Create.Listener");
        deleteListenerBusyDlgText = Message.format((String)UiPlugin.getNLSString((Trace)t, (String)"KEY_General", (String)"UI.GENERAL.BUSY.DELETE"), (String)"LISTENER.TCP");
        EXISTS = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Object.Exists");
        DOESNT_EXIST = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Object.Doesnt.Exist");
    }

    public void cancelPressed(Trace t) {
    }

    public void createContent(Trace t, Composite composite) {
        Button[] buttons = new Button[6];
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        UiUtils.createBlankLine((Composite)composite, (int)5);
        final Label remoteAdminLabel = new Label(composite, 64);
        remoteAdminLabel.setText(remoteAdminExplanationLabelText);
        GridData gridData = new GridData(4, 128, true, false, 5, 1);
        gridData.widthHint = 500;
        remoteAdminLabel.setLayoutData((Object)gridData);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace t2 = Trace.getDefault();
                UiUtils.resizeControl((Trace)t2, (Control)remoteAdminLabel);
            }
        });
        UiUtils.createBlankLine((Composite)composite, (int)5);
        Label label = new Label(composite, 16384);
        label.setText(remoteAdminStatusLabelText);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 131072);
        label.setText(svrConnLabelText);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.svrConnText = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.svrConnText.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.svrConnText, (boolean)true);
        this.svrConnText.setText(DOESNT_EXIST);
        if (this.dmChannel != null) {
            this.svrConnText.setText(EXISTS);
        }
        buttons[0] = this.createSvrConnButton = new Button(composite, 8);
        this.createSvrConnButton.setText(createSvrConnButtonText);
        gridData = new GridData();
        this.createSvrConnButton.setLayoutData((Object)gridData);
        this.createSvrConnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                RemoteAdminDialog.this.createSvrConnChannel(t2);
            }
        });
        buttons[1] = this.deleteSvrConnButton = new Button(composite, 8);
        this.deleteSvrConnButton.setText(deleteSvrConnButtonText);
        gridData = new GridData();
        this.deleteSvrConnButton.setLayoutData((Object)gridData);
        this.deleteSvrConnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                RemoteAdminDialog.this.deleteSvrConnChannel(t2);
            }
        });
        label = new Label(composite, 131072);
        label.setText(listenerLabelText);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.listenerText = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.listenerText.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.listenerText, (boolean)true);
        if (this.dmListener != null) {
            this.listenerText.setText(EXISTS);
        } else {
            this.listenerText.setText(DOESNT_EXIST);
        }
        buttons[2] = this.createListenerButton = new Button(composite, 8);
        this.createListenerButton.setText(createListenerButtonText);
        gridData = new GridData();
        this.createListenerButton.setLayoutData((Object)gridData);
        this.createListenerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                RemoteAdminDialog.this.createListener(t2);
            }
        });
        buttons[3] = this.deleteListenerButton = new Button(composite, 8);
        this.deleteListenerButton.setText(deleteListenerButtonText);
        gridData = new GridData();
        this.deleteListenerButton.setLayoutData((Object)gridData);
        this.deleteListenerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                RemoteAdminDialog.this.deleteListener(t2);
            }
        });
        label = new Label(composite, 131072);
        label.setText(listenerStatusLabelText);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.listenerStatusText = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.listenerStatusText.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.listenerStatusText, (boolean)true);
        if (this.dmListener != null) {
            this.listenerStatusText.setText(this.listenerStatus);
        }
        buttons[4] = this.startListenerButton = new Button(composite, 8);
        this.startListenerButton.setText(startListenerButtonText);
        gridData = new GridData();
        this.startListenerButton.setLayoutData((Object)gridData);
        this.startListenerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                RemoteAdminDialog.this.startListener(t2);
            }
        });
        buttons[5] = this.stopListenerButton = new Button(composite, 8);
        this.stopListenerButton.setText(stopListenerButtonText);
        gridData = new GridData();
        this.stopListenerButton.setLayoutData((Object)gridData);
        this.stopListenerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                RemoteAdminDialog.this.stopListener(t2);
            }
        });
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])buttons);
        this.enableButtons();
        this.enableDataModelListener(t);
        composite.pack();
        this.preferredSize = composite.getSize();
    }

    private void enableDataModelListener(Trace t) {
        DmObjectFilter listenerStatusFilter = new DmObjectFilter(t, "LISTENER.TCP", 98, 2);
        this.dmQmgr.addObserver(t, (DmObjectListener)this, listenerStatusFilter);
    }

    private void disableDataModelListener(Trace t) {
        this.dmQmgr.deleteObserver(t, (DmObjectListener)this);
    }

    protected void stopListener(Trace t) {
        if (this.uiListener == null) {
            this.uiListener = new UiListener(t, (IDmObject)this.dmListener, (UiMQObject)this.uiQmgr);
            this.uiListenerActions = new UiListenerActions(this.getShell(), this.uiListener);
        }
        this.uiListenerActions.stopListener(t);
        this.dmQmgr.refreshObservable(t, (DmObjectListener)this);
        this.enableButtons();
    }

    protected void startListener(Trace t) {
        if (this.uiListener == null) {
            this.uiListener = new UiListener(t, (IDmObject)this.dmListener, (UiMQObject)this.uiQmgr);
            this.uiListenerActions = new UiListenerActions(this.getShell(), this.uiListener);
        }
        this.uiListenerActions.startListener(t);
        this.dmQmgr.refreshObservable(t, (DmObjectListener)this);
        this.enableButtons();
    }

    protected void closePressed(Trace t) {
        this.disableDataModelListener(t);
    }

    public void createSvrConnChannel(Trace t) {
        BusyDialog waitbox = new BusyDialog(this.getShell(), createSvrConnChannelBusyDlgText);
        CreateSvrConnChannel createSvrConnChannel = new CreateSvrConnChannel(this.dmQmgr, waitbox);
        createSvrConnChannel.start();
        waitbox.showDialog(t);
        int rc = createSvrConnChannel.getReturnCode();
        if (createSvrConnChannel.getChannelCloneFailed()) {
            if (Trace.isTracing) {
                t.data(67, "RemoteAdminDialog.createSvrConnChannel", 900, "Channel clone failed when attempting to create the SYSTEM.ADMIN.SVRCONN channel");
            }
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)CHANNEL_CLONE_FAILED), (String)CHANNEL_CLONE_FAILED);
        } else if (rc == 0) {
            MessageBox.showSystemMessageById((Trace)t, (Shell)this.getShell(), (String)CHANNEL_CREATED);
            UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
            this.svrConnText.setText(EXISTS);
            this.dmChannel = createSvrConnChannel.getSvrConnChannel();
        } else {
            if (Trace.isTracing) {
                t.data(67, "RemoteAdminDialog.createSvrConnChannel", 900, "PCF Reason Code: " + rc + " creating SYSTEM.ADMIN.SVRCONN channel");
            }
            if (rc == 4001) {
                this.svrConnText.setText(EXISTS);
                this.dmChannel = createSvrConnChannel.getSvrConnChannel();
            } else {
                MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)CHANNEL_CREATE_FAILED), (String)CHANNEL_CREATE_FAILED);
            }
        }
        this.enableButtons();
    }

    protected void enableButtons() {
        if (this.dmChannel == null) {
            this.createSvrConnButton.setEnabled(true);
            this.deleteSvrConnButton.setEnabled(false);
        } else {
            this.createSvrConnButton.setEnabled(false);
            this.deleteSvrConnButton.setEnabled(true);
        }
        if (this.dmListener == null) {
            this.createListenerButton.setEnabled(true);
            this.deleteListenerButton.setEnabled(false);
            this.startListenerButton.setEnabled(false);
            this.stopListenerButton.setEnabled(false);
        } else {
            this.createListenerButton.setEnabled(false);
            if (this.listenerStatusInt == 2) {
                this.startListenerButton.setEnabled(false);
                this.stopListenerButton.setEnabled(true);
                this.deleteListenerButton.setEnabled(false);
            } else if (this.listenerStatusInt == 0) {
                this.startListenerButton.setEnabled(true);
                this.stopListenerButton.setEnabled(false);
                this.deleteListenerButton.setEnabled(true);
            } else {
                this.startListenerButton.setEnabled(false);
                this.stopListenerButton.setEnabled(false);
                this.deleteListenerButton.setEnabled(false);
            }
        }
    }

    public void deleteSvrConnChannel(Trace t) {
        int rc = 1;
        String msg = CommonServices.getSystemMessage((Trace)t, (String)DELETE_QUESTION, (String)"SYSTEM.ADMIN.SVRCONN");
        rc = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)this.getShell(), (String)msg, (int)1, (String)DELETE_QUESTION);
        if (rc == 0) {
            BusyDialog waitbox = new BusyDialog(this.getShell(), deleteSvrConnChannelBusyDlgText);
            DeleteSvrConnChannel deleteSvrConnChannel = new DeleteSvrConnChannel(this.dmChannel, waitbox);
            deleteSvrConnChannel.start();
            waitbox.showDialog(t);
            int deleteResult = deleteSvrConnChannel.getReturnCode();
            if (deleteResult == 0) {
                MessageBox.showSystemMessageById((Trace)t, (Shell)this.getShell(), (String)CHANNEL_DELETED);
            } else {
                if (Trace.isTracing) {
                    t.data(67, "RemoteAdminDialog.deleteSvrConnChannel", 900, "PCF Reason Code: " + rc + " deleting SYSTEM.ADMIN.SVRCONN channel");
                }
                MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)CHANNEL_DELETE_FAILED), (String)CHANNEL_DELETE_FAILED);
            }
            if (deleteResult == 0 || deleteResult == 4032) {
                UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
                this.dmChannel = null;
                this.svrConnText.setText(DOESNT_EXIST);
            }
        }
        this.enableButtons();
    }

    public void createListener(Trace t) {
        CreateListenerDialog createListenerDialog = new CreateListenerDialog(this.getShell());
        createListenerDialog.create(t);
        boolean response = createListenerDialog.open(t);
        if (response) {
            int port = createListenerDialog.getPortNumber();
            BusyDialog waitbox = new BusyDialog(this.getShell(), createlistenerBusyDlgText);
            CreateListener createListener = new CreateListener(this.dmQmgr, waitbox, port);
            createListener.start();
            waitbox.showDialog(t);
            int rc = createListener.getReturnCode();
            if (createListener.getListenerCloneFailed()) {
                if (Trace.isTracing) {
                    t.data(67, "RemoteAdminDialog.createListener", 900, "Listener clone failed when attempting to create the LISTENER.TCP listener");
                }
                MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)"AMQ4461"), (String)"AMQ4461");
            } else {
                if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)this.getShell(), (String)LISTENER_CREATED);
                } else {
                    if (Trace.isTracing) {
                        t.data(67, "RemoteAdminDialog.createListener", 900, "PCF Reason Code: " + rc + " creating LISTENER.TCP listener");
                    }
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)"AMQ4461"), (String)"AMQ4461");
                }
                if (rc == 0 || rc == 4001) {
                    UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
                    this.dmListener = createListener.getDefaultListener();
                    this.listenerText.setText(EXISTS);
                    this.listenerStatusText.setText(this.getStoppedString(t));
                }
            }
            this.enableButtons();
        }
    }

    public void deleteListener(Trace t) {
        int rc = 1;
        String msg = CommonServices.getSystemMessage((Trace)t, (String)DELETE_QUESTION, (String)"LISTENER.TCP");
        rc = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)this.getShell(), (String)msg, (int)1, (String)DELETE_QUESTION);
        if (rc == 0) {
            BusyDialog waitbox = new BusyDialog(this.getShell(), deleteListenerBusyDlgText);
            DeleteListener deleteListener = new DeleteListener(this.dmListener, waitbox);
            deleteListener.start();
            waitbox.showDialog(t);
            int deleteResult = deleteListener.getReturnCode();
            if (deleteResult == 0) {
                MessageBox.showSystemMessageById((Trace)t, (Shell)this.getShell(), (String)LISTENER_DELETED, (String[])new String[]{"LISTENER.TCP"});
            } else {
                if (Trace.isTracing) {
                    t.data(67, "RemoteAdminDialog.deleteListener", 900, "PCF Reason Code: " + rc + " deleting LISTENER.TCP listener");
                }
                MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)LISTENER_DELETE_FAILED), (String)LISTENER_DELETE_FAILED);
            }
            if (deleteResult == 0 || deleteResult == 2085) {
                UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
                this.dmListener = null;
                this.listenerStatusText.setText("");
                this.listenerText.setText(DOESNT_EXIST);
            }
        }
        this.enableButtons();
    }

    public void createUserButtons(Trace t, Composite composite) {
    }

    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerRemoteAdminDialog";
    }

    public Image getImage(Trace t) {
        return Icons.get((String)Icons.iconkeyExplorerSmall);
    }

    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    public String getTitle(Trace t) {
        return titleText;
    }

    public boolean isEnableOK(Trace t) {
        return false;
    }

    public boolean isPackDialog(Trace t) {
        return false;
    }

    public boolean isUserButtons(Trace t) {
        return false;
    }

    public boolean okPressed(Trace t) {
        return true;
    }

    public void packDialog(Trace t) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
        this.setListenerStatusText(event);
    }

    private void setListenerStatusText(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        if (event.getSource() instanceof DmListenerStatus) {
            block4: {
                DmListenerStatus dmListenerStatus = (DmListenerStatus)event.getSource();
                this.listenerStatus = dmListenerStatus.getAttributeValue(t, 1599, 0);
                Attr a = dmListenerStatus.getAttribute(t, 1599, 0);
                if (a != null) {
                    try {
                        this.listenerStatusInt = (Integer)a.getValue(t);
                    }
                    catch (Exception e) {
                        if (!Trace.isTracing) break block4;
                        t.data(67, "RemoteAdminDialog.setListenerStatusText", 900, "Error getting CMQCFC.MQIACH_LISTENER_STATUS : " + e.toString());
                    }
                }
            }
            UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RemoteAdminDialog.this.listenerStatusText.setText(RemoteAdminDialog.this.listenerStatus);
                    RemoteAdminDialog.this.enableButtons();
                }
            });
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
        this.setListenerStatusText(event);
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        this.listenerStatusInt = 0;
        this.listenerStatus = this.getStoppedString(t);
        UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RemoteAdminDialog.this.listenerStatusText.setText(RemoteAdminDialog.this.listenerStatus);
                RemoteAdminDialog.this.enableButtons();
            }
        });
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        this.setListenerStatusText(event);
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    private String getStoppedString(Trace t) {
        AttrTypeEnum attrType;
        String lsnrStatus;
        block3: {
            lsnrStatus = "";
            attrType = null;
            try {
                attrType = (AttrTypeEnum)DmListenerStatus.getAttributeType((Trace)t, (int)1599);
            }
            catch (ClassCastException e) {
                if (!Trace.isTracing) break block3;
                t.data(67, "RemoteAdminDialog.getStoppedString", 900, "Error getting CMQCFC.MQIACH_LISTENER_STATUS : " + e.toString());
            }
        }
        if (attrType != null) {
            lsnrStatus = attrType.getEnumeratedValue(t, (Number)0);
        }
        return lsnrStatus;
    }
}

